/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.datetime.v0;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class Duration
implements Comparable<Duration>,
Serializable,
Cloneable {
    private final double duration;

    public Duration(double duration) {
        this.duration = duration;
    }

    @Contract(value="_->new")
    public static Duration ofYoctoseconds(double value) {
        return new Duration(value / 1.0E24);
    }

    @Contract(value="_->new")
    public static Duration ofZeptoseconds(double value) {
        return new Duration(value / 1.0E21);
    }

    @Contract(value="_->new")
    public static Duration ofAttoseconds(double value) {
        return new Duration(value / 1.0E18);
    }

    @Contract(value="_->new")
    public static Duration ofFemtoseconds(double value) {
        return new Duration(value / 1.0E15);
    }

    @Contract(value="_->new")
    public static Duration ofPicoseconds(double value) {
        return new Duration(value / 1.0E12);
    }

    @Contract(value="_->new")
    public static Duration ofNanoseconds(double value) {
        return new Duration(value / 1.0E9);
    }

    @Contract(value="_->new")
    public static Duration ofMicroseconds(double value) {
        return new Duration(value / 1000000.0);
    }

    @Contract(value="_->new")
    public static Duration ofMilliseconds(double value) {
        return new Duration(value / 1000.0);
    }

    @Contract(value="_->new")
    public static Duration ofSeconds(double value) {
        return new Duration(value);
    }

    @Contract(value="_->new")
    public static Duration ofMinutes(double value) {
        return new Duration(value * 60.0);
    }

    @Contract(value="_->new")
    public static Duration ofHours(double value) {
        return new Duration(value * 3600.0);
    }

    @Contract(value="_->new")
    public static Duration ofDays(double value) {
        return new Duration(value * 86400.0);
    }

    @Contract(value="_->new")
    public static Duration ofWeeks(double value) {
        return new Duration(value * 604800.0);
    }

    @Deprecated
    @Contract(value="_->new")
    public static Duration ofYears(double value) {
        return new Duration(value * 3.15576E7);
    }

    public void sleep() throws InterruptedException {
        Thread.sleep((long)this.duration * 1000L);
    }

    public double getYoctoseconds() {
        return this.duration * 1.0E24;
    }

    public double getZeptoseconds() {
        return this.duration * 1.0E21;
    }

    public double getAttoseconds() {
        return this.duration * 1.0E18;
    }

    public double getFemtoseconds() {
        return this.duration * 1.0E15;
    }

    public double getPicoseconds() {
        return this.duration * 1.0E12;
    }

    public double getNanoseconds() {
        return this.duration * 1.0E9;
    }

    public double getMicroseconds() {
        return this.duration * 1000000.0;
    }

    public double getMilliseconds() {
        return this.duration * 1000.0;
    }

    public double getSeconds() {
        return this.duration;
    }

    public double getMinutes() {
        return this.duration / 60.0;
    }

    public double getHours() {
        return this.duration / 3600.0;
    }

    public double getDays() {
        return this.duration / 86400.0;
    }

    public double getWeeks() {
        return this.duration / 604800.0;
    }

    @Deprecated
    public double getYears() {
        return this.duration / 3.15576E7;
    }

    public long getYoctosecondPart() {
        return (long)(this.duration * 1.0E24 % 1000.0);
    }

    public long getZeptosecondPart() {
        return (long)(this.duration * 1.0E21 % 1000.0);
    }

    public long getAttosecondPart() {
        return (long)(this.duration * 1.0E18 % 1000.0);
    }

    public long getFemtosecondPart() {
        return (long)(this.duration * 1.0E15 % 1000.0);
    }

    public long getPicosecondPart() {
        return (long)(this.duration * 1.0E12 % 1000.0);
    }

    public long getNanosecondPart() {
        return (long)(this.duration * 1.0E9 % 1000.0);
    }

    public long getMicrosecondPart() {
        return (long)(this.duration * 1000000.0 % 1000.0);
    }

    public long getMillisecondPart() {
        return (long)(this.duration * 1000.0 % 1000.0);
    }

    public long getSecondPart() {
        return (long)(this.duration % 60.0);
    }

    public long getMinutePart() {
        return (long)(this.duration / 60.0 % 60.0);
    }

    public long getHourPart() {
        return (long)(this.duration / 3600.0 % 24.0);
    }

    public long getDayPart() {
        return (long)(this.duration / 86400.0 % 7.0);
    }

    public long getWeekPart() {
        return (long)(this.duration / 604800.0 % 51.0);
    }

    public String toString() {
        return "Duration{duration=" + this.duration + '}';
    }

    @ApiStatus.Experimental
    public String toSimpleString() {
        long days = (long)Math.floor(this.getDays());
        long hour = this.getHourPart();
        long minute = this.getMinutePart();
        long second = this.getSecondPart();
        if (days != 0L) {
            return String.format("%d:%02d:%02d:%02d", days, hour, minute, second);
        }
        if (hour != 0L) {
            return String.format("%d:%02d:%02d", hour, minute, second);
        }
        return String.format("%d:%02d", minute, second);
    }

    public int toInt() {
        return (int)this.duration;
    }

    public long toLong() {
        return (long)this.duration;
    }

    public double toDouble() {
        return this.duration;
    }

    public float toFloat() {
        return (float)this.duration;
    }

    public long toNanos() {
        return (long)this.getNanoseconds();
    }

    public long toMillis() {
        return (long)this.getMilliseconds();
    }

    public long toSeconds() {
        return (long)this.getSeconds();
    }

    public Duration plus(Duration duration) {
        return new Duration(this.duration + duration.duration);
    }

    public Duration minus(Duration duration) {
        return new Duration(this.duration - duration.duration);
    }

    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.duration);
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf((long)this.duration);
    }

    public boolean isZero() {
        return this.duration == 0.0;
    }

    public boolean isNegative() {
        return this.duration < 0.0;
    }

    public boolean isPositive() {
        return this.duration > 0.0;
    }

    public Duration negate() {
        return new Duration(-this.duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration1 = (Duration)o;
        return Double.compare(duration1.duration, this.duration) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }

    @Override
    public int compareTo(Duration o) {
        return Double.compare(this.toDouble(), o.toDouble());
    }

    public Duration clone() {
        try {
            return (Duration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

