/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.datetime.v0;

import com.ultreon.libs.datetime.v0.Date;
import com.ultreon.libs.datetime.v0.DayPeriod;
import com.ultreon.libs.datetime.v0.Duration;
import com.ultreon.libs.datetime.v0.Month;
import com.ultreon.libs.datetime.v0.Time;
import com.ultreon.libs.datetime.v0.exceptions.DateTimeError;
import com.ultreon.libs.datetime.v0.exceptions.DateTimeException;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.ApiStatus;

public class DateTime
implements Comparable<DateTime>,
Serializable,
Cloneable {
    private static final Duration DURATION = new Duration(0.0);
    private int hour;
    private int minute;
    private int second;
    private int day;
    private int year;
    private Month month;
    private int nano;

    public static DateTime current() {
        LocalDateTime dateTime = LocalDateTime.now();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int day = dateTime.getDayOfMonth();
        int month = dateTime.getMonthValue();
        int year = dateTime.getYear();
        int nano = dateTime.getNano();
        return new DateTime(day, month, year, hour, minute, second, nano);
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public DateTime(DateTime dateTime) {
        this(dateTime.day, dateTime.month, dateTime.year, dateTime.hour, dateTime.minute, dateTime.second, dateTime.nano);
    }

    public DateTime(Date date, Time time) {
        this(date.getDay(), date.getMonth(), date.getYear(), time.getHour(), time.getMinute(), time.getSecond());
    }

    public DateTime(int day, int month, int year, int hour, int minute, int second) {
        this(day, Month.from(month), year, hour, minute, second);
    }

    public DateTime(int day, Month month, int year, int hour, int minute, int second) {
        this(day, month, year, hour, minute, second, 0);
    }

    public DateTime(int day, int month, int year, int hour, int minute, int second, int nano) {
        this(day, Month.from(month), year, hour, minute, second);
    }

    public DateTime(int day, Month month, int year, int hour, int minute, int second, int nano) {
        if (second < 0 || second > 59) {
            throw new DateTimeException("Second must be between 0 and 59");
        }
        if (minute < 0 || minute > 59) {
            throw new DateTimeException("Minute must be between 0 and 59");
        }
        if (hour < 0 || hour > 59) {
            throw new DateTimeException("Minute must be between 0 and 59");
        }
        if (nano < 0 || nano > 999999999) {
            throw new DateTimeException("Nano must be between 0 and 999'999'999");
        }
        Date.checkDayOfMonth(day, month, year);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.day = day;
        this.month = month;
        this.year = year;
        this.nano = nano;
    }

    public static DateTime ofEpochSecond(long second, ZoneOffset offset) {
        return DateTime.ofLocalDateTime(LocalDateTime.ofEpochSecond(second, 0, offset));
    }

    public static DateTime ofEpochMilli(long milli, ZoneOffset offset) {
        return DateTime.ofLocalDateTime(LocalDateTime.ofEpochSecond(milli / 1000L, (int)(milli % 1000L * 1000000L), offset));
    }

    public static DateTime ofEpochNano(long nano, ZoneOffset offset) {
        return DateTime.ofLocalDateTime(LocalDateTime.ofEpochSecond(nano / 1000000000L, (int)(nano % 1000000000L), offset));
    }

    public static DateTime ofLocalDateTime(LocalDateTime ldt) {
        return new DateTime(ldt.getDayOfMonth(), ldt.getMonthValue(), ldt.getYear(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
    }

    public static DateTime ofInstant(Instant lt, ZoneOffset offset) {
        return DateTime.ofEpochMilli(lt.toEpochMilli(), offset);
    }

    public static boolean isBetween(DateTime lo, DateTime hi) {
        if (lo.toEpochNano() > hi.toEpochNano()) {
            throw new NullPointerException("\u2018lo\u2019 is higher than \u2018hi\u2019");
        }
        return lo.toEpochNano() <= hi.toEpochNano() && hi.toEpochNano() >= lo.toEpochNano();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public long toEpochSeconds() {
        return this.toEpochSecond();
    }

    public long toEpochSecond() {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.of(this.year, this.month.getIndex(), this.day), LocalTime.of(this.hour, this.minute, this.second));
        return localDateTime.toEpochSecond(ZoneOffset.ofTotalSeconds(0));
    }

    public long toEpochMilli() {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.of(this.year, this.month.getIndex(), this.day), LocalTime.of(this.hour, this.minute, this.second));
        return localDateTime.toEpochSecond(ZoneOffset.ofTotalSeconds(0)) + (long)(this.nano / 1000000);
    }

    public long toEpochNano() {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.of(this.year, this.month.getIndex(), this.day), LocalTime.of(this.hour, this.minute, this.second));
        return localDateTime.toEpochSecond(ZoneOffset.ofTotalSeconds(0)) + (long)this.nano;
    }

    public long toEpochSecond(ZoneOffset offset) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.of(this.year, this.month.getIndex(), this.day), LocalTime.of(this.hour, this.minute, this.second));
        return localDateTime.toEpochSecond(offset);
    }

    public long toEpochMilli(ZoneOffset offset) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.of(this.year, this.month.getIndex(), this.day), LocalTime.of(this.hour, this.minute, this.second));
        return localDateTime.toEpochSecond(offset) + (long)(this.nano / 1000000);
    }

    public long toEpochNano(ZoneOffset offset) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.of(this.year, this.month.getIndex(), this.day), LocalTime.of(this.hour, this.minute, this.second));
        return localDateTime.toEpochSecond(offset) + (long)this.nano;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new DateTimeException("Hour must be between 0 and 23");
        }
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new DateTimeException("Minute must be between 0 and 59");
        }
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        if (second < 0 || second > 59) {
            throw new DateTimeException("Second must be between 0 and 59");
        }
        this.second = second;
    }

    public int getNano() {
        return this.nano;
    }

    public void setNano(int nano) {
        if (nano < 0 || nano > 999999999) {
            throw new DateTimeException("Nano must be between 0 and 999'999'999");
        }
        this.nano = nano;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        int days = this.getMonth().getDays(this.year);
        if (this.minute < 1 || this.minute > days) {
            throw new DateTimeException("Minute must be between 1 and " + days);
        }
        this.day = day;
    }

    public int getMonthIndex() {
        return this.month.getIndex();
    }

    public void setMonthIndex(int index) {
        this.month = Month.from(index);
    }

    public Month getMonth() {
        return this.month;
    }

    public void setMonth(Month month) {
        this.month = month;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Time getTime() {
        return new Time(this.hour, this.minute, this.second, this.nano);
    }

    public void setTime(Time time) {
        this.hour = time.getHour();
        this.minute = time.getMinute();
        this.second = time.getSecond();
        this.nano = time.getNano();
    }

    public Date getDate() {
        return new Date(this.day, this.month, this.year);
    }

    public void getDate(Date date) {
        this.year = date.getYear();
        this.month = date.getMonth();
        this.day = date.getDay();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public Duration getDuration() {
        return DURATION;
    }

    public DayPeriod getDayPeriod() {
        Time time = this.getTime();
        if (DayPeriod.NIGHT.isWithin(time)) {
            return DayPeriod.NIGHT;
        }
        if (DayPeriod.MORNING.isWithin(time)) {
            return DayPeriod.MORNING;
        }
        if (DayPeriod.AFTERNOON.isWithin(time)) {
            return DayPeriod.AFTERNOON;
        }
        if (DayPeriod.NIGHT.isWithin(time)) {
            return DayPeriod.NIGHT;
        }
        throw new DateTimeError("Can't find valid day period.");
    }

    public LocalTime toLocalTime() {
        return LocalTime.of(this.hour, this.minute, this.second, this.nano);
    }

    public LocalDate toLocalDate() {
        return LocalDate.of(this.year, this.month.getIndex(), this.day);
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.year, this.month.getIndex(), this.day, this.hour, this.minute, this.second, this.nano);
    }

    @Override
    public int compareTo(DateTime o) {
        return Long.compare(this.toEpochNano(), o.toEpochNano());
    }

    public int hashCode() {
        return Long.hashCode(this.toEpochNano());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.toEpochNano() == ((DateTime)o).toEpochNano();
    }

    public DateTime clone() {
        try {
            return (DateTime)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

