/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.datetime.v0;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class Duration
implements Comparable<Duration>,
Serializable {
    private final double duration;

    public Duration(double duration) {
        this.duration = duration;
    }

    public void sleep() throws InterruptedException {
        Thread.sleep((long)this.duration * 1000L);
    }

    public double getYoctoseconds() {
        return this.duration * 1.0E24;
    }

    public double getZeptoseconds() {
        return this.duration * 1.0E21;
    }

    public double getAttoseconds() {
        return this.duration * 1.0E18;
    }

    public double getFemtoseconds() {
        return this.duration * 1.0E15;
    }

    public double getPicoseconds() {
        return this.duration * 1.0E12;
    }

    public double getNanoseconds() {
        return this.duration * 1.0E9;
    }

    public double getMicroseconds() {
        return this.duration * 1000000.0;
    }

    public double getMilliseconds() {
        return this.duration * 1000.0;
    }

    public double getSeconds() {
        return this.duration;
    }

    public double getMinutes() {
        return this.duration / 60.0;
    }

    public double getHours() {
        return this.duration / 3600.0;
    }

    public double getDays() {
        return this.duration / 86400.0;
    }

    public double getWeeks() {
        return this.duration / 604800.0;
    }

    public double getYears() {
        return this.duration / 3.15576E7;
    }

    public String toString() {
        return "Duration{duration=" + this.duration + '}';
    }

    public String toSimpleString() {
        LocalDateTime g = LocalDateTime.ofEpochSecond((long)this.duration, 0, ZoneOffset.ofTotalSeconds(0));
        int minute = g.getMinute();
        int second = g.getSecond();
        double hourDouble = this.duration / 60.0 / 60.0;
        return this.format0(minute, second, hourDouble);
    }

    private String format0(int minute, int second, double hourDouble) {
        return minute + ":" + minute + ":" + second;
    }

    public int toInt() {
        return (int)this.duration;
    }

    public long toLong() {
        return (long)this.duration;
    }

    public double toDouble() {
        return this.duration;
    }

    public float toFloat() {
        return (float)this.duration;
    }

    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.duration);
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf((long)this.duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration1 = (Duration)o;
        return Double.compare(duration1.duration, this.duration) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }

    @Override
    public int compareTo(Duration o) {
        return Double.compare(this.toDouble(), o.toDouble());
    }
}

