/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0.util;

import com.ultreon.libs.commons.v0.UtilityClass;
import com.ultreon.libs.commons.v0.util.IllegalCallerException;

public final class ClassUtils
extends UtilityClass {
    public static String getCallerClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().equals(ClassUtils.class.getName()) || ste.getClassName().indexOf("java.lang.Thread") == 0) continue;
            return stElements[i + 1].getClassName();
        }
        return null;
    }

    public static Class<?> getCallerClass() {
        String className = ClassUtils.getCallerClassName();
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void checkCallerClassEquals(Class<?> clazz) {
        if (ClassUtils.getCallerClass() != clazz) {
            throw new IllegalCallerException("Called from illegal class, valid class: " + clazz.getSimpleName());
        }
    }

    public static void checkCallerClassExtends(Class<?> clazz) {
        if (ClassUtils.getCallerClass() == null || ClassUtils.getCallerClass().isAssignableFrom(clazz)) {
            throw new IllegalCallerException("Called from illegal class, valid (extendable) class: " + clazz.getSimpleName());
        }
    }
}

