/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

import com.ultreon.libs.commons.v0.VersionType;
import java.io.Serializable;
import java.util.Objects;

public final class Version
implements Serializable {
    private final int major;
    private final int minor;
    private final int build;
    private final VersionType type;
    private final int release;
    private static final long serialVersionUID = 0L;

    public Version(int major, int minor, int build, VersionType type, int release) {
        this.major = major;
        this.minor = minor;
        this.build = build;
        this.type = type;
        this.release = release;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int build() {
        return this.build;
    }

    public VersionType type() {
        return this.type;
    }

    public int release() {
        return this.release;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.build + "-" + this.type.getName() + this.release;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.release == version.release && this.type == version.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.major, this.minor, this.type, this.release});
    }
}

