/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

public class ValueAnimator {
    private final double valueStart;
    private final double valueEnd;
    private final double duration;
    private boolean active;
    private double timeStart;
    private double timeEnd;

    public ValueAnimator(double start, double end, double duration) {
        this.valueStart = start;
        this.valueEnd = end;
        this.duration = duration;
    }

    public void start() {
        this.active = true;
        this.timeStart = (double)System.nanoTime() / 1.0E9;
        this.timeEnd = this.timeStart + this.duration;
    }

    public double animate() {
        if (this.active) {
            double currentTime = (double)System.nanoTime() / 1.0E9;
            double now = this.timeEnd - this.timeStart != 0.0 ? ((currentTime - this.timeEnd) / (this.timeEnd - this.timeStart) + 1.0) / 2.0 : 1.0;
            if (now >= 1.0) {
                now = 1.0;
            } else if (now <= 0.0) {
                now = 0.0;
            }
            return now * (this.valueEnd - this.valueStart) + this.valueStart;
        }
        return 0.0;
    }

    public boolean isEnded() {
        double currentTime = (double)System.nanoTime() / 1.0E9;
        double now = ((currentTime - this.timeEnd) / (this.timeEnd - this.timeStart) + 1.0) / 2.0;
        return now >= 1.0;
    }
}

