/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.commons.v0;

import com.ultreon.libs.commons.v0.exceptions.SyntaxException;
import com.ultreon.libs.commons.v0.tuple.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

public final class Identifier {
    @NotNull
    private final String location;
    @NotNull
    private final String path;
    private static String defaultNamespace = "default";
    private static boolean defaultSet = false;

    public static synchronized void setDefaultNamespace(String defaultNamespace) {
        if (defaultSet) {
            throw new IllegalStateException("Default namespace already set.");
        }
        defaultSet = true;
        Identifier.defaultNamespace = defaultNamespace;
    }

    public static String getDefaultNamespace() {
        return defaultNamespace;
    }

    public Identifier(@NotNull String location, @NotNull String path) {
        Identifier.testLocation(location);
        Identifier.testPath(path);
        this.location = location;
        this.path = path;
    }

    public Identifier(@NotNull String name) {
        String[] split = name.split(":", 2);
        if (split.length == 2) {
            this.location = Identifier.testLocation(split[0]);
            this.path = Identifier.testPath(split[1]);
        } else {
            this.location = defaultNamespace;
            this.path = Identifier.testPath(name);
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    public static Identifier parse(@NotNull String name) {
        return new Identifier(name);
    }

    @Nullable
    @Contract(value="null -> null")
    public static Identifier tryParse(@Nullable String name) {
        if (name == null) {
            return null;
        }
        try {
            return new Identifier(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Contract(value="_ -> param1")
    public static String testLocation(String location) {
        if (!Pattern.matches("([a-z\\d_]+)([.\\-][a-z\\-\\d_]+)*", location)) {
            throw new SyntaxException("Location is invalid: " + location);
        }
        return location;
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static String testPath(String path) {
        if (!Pattern.matches("([a-z_.\\d]+)(/[a-z_.\\d]+)*", path)) {
            throw new SyntaxException("Path is invalid: " + path);
        }
        return path;
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return this.location.equals(that.location) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.path);
    }

    @NotNull
    @Contract(pure=true)
    public String toString() {
        return this.location + ":" + this.path;
    }

    @NotNull
    @Contract(pure=true)
    public String location() {
        return this.location;
    }

    @NotNull
    @Contract(pure=true)
    public String path() {
        return this.path;
    }

    @Contract(value="_ -> new")
    public Identifier withLocation(String location) {
        return new Identifier(location, this.path);
    }

    @Contract(value="_ -> new")
    public Identifier withPath(String path) {
        return new Identifier(this.location, path);
    }

    @Contract(value="_ -> new")
    public Identifier mapLocation(Function<String, String> location) {
        return new Identifier(location.apply(this.location), this.path);
    }

    @Contract(value="_ -> new")
    public Identifier mapPath(Function<String, String> path) {
        return new Identifier(this.location, path.apply(this.path));
    }

    @Contract(value="_, _ -> new")
    public Identifier map(Function<String, String> path, Function<String, String> location) {
        return new Identifier(location.apply(this.location), path.apply(this.path));
    }

    public <T> T reduce(BiFunction<String, String, T> func) {
        return func.apply(this.location, this.path);
    }

    @NotNull
    @Contract(value="-> new", pure=true)
    public @Unmodifiable List<String> toList() {
        return Arrays.asList(this.location, this.path);
    }

    @NotNull
    @Contract(value=" -> new")
    public ArrayList<String> toArrayList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.location);
        list.add(this.path);
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public @UnmodifiableView Collection<String> toCollection() {
        return this.toList();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public Pair<String, String> toPair() {
        return new Pair<String, String>(this.location, this.path);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public String[] toArray() {
        return new String[]{this.location, this.path};
    }
}

