/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.data.types;

import com.ultreon.data.Types;
import com.ultreon.data.types.IType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class FloatArrayType
implements IType<float[]> {
    private float[] obj;

    public FloatArrayType(float[] obj) {
        this.obj = obj;
    }

    @Override
    public float[] getValue() {
        return this.obj;
    }

    @Override
    public void setValue(float[] obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Value can't be set to null");
        }
        this.obj = obj;
    }

    @Override
    public int id() {
        return Types.FLOAT_ARRAY;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        stream.writeInt(this.obj.length);
        for (float i : this.obj) {
            stream.writeFloat(i);
        }
    }

    public static FloatArrayType read(DataInputStream stream) throws IOException {
        int len = stream.readInt();
        float[] arr = new float[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = stream.readFloat();
        }
        return new FloatArrayType(arr);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FloatArrayType)) {
            return false;
        }
        FloatArrayType that = (FloatArrayType)other;
        return Arrays.equals(this.obj, that.obj);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.obj);
    }
}

