/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.libs.events.v1;

import com.google.common.reflect.AbstractInvocationHandler;
import com.ultreon.libs.events.v1.EventResult;
import com.ultreon.libs.events.v1.ValueEventResult;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Event<T> {
    private final Factory<T> factory;
    private final List<T> listeners = new ArrayList<T>();

    public Event(Factory<T> factory) {
        this.factory = factory;
    }

    public void listen(T t) {
        this.listeners.add(t);
    }

    public T factory() {
        return this.factory.create(this.listeners);
    }

    @SafeVarargs
    public static <T> Event<T> create(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("The array shouldn't contain anything!");
        }
        return Event.of(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<T> of(Class<T> clazz) {
        return new Event<Object>(listeners -> Proxy.newProxyInstance(Event.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Object listener : listeners) {
                    Event.invokeMethod(listener, method, args);
                }
                return null;
            }
        }));
    }

    @SafeVarargs
    public static <T> Event<T> withResult(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("The array shouldn't contain anything!");
        }
        return Event.withResult(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<T> withResult(Class<T> clazz) {
        return new Event<Object>(listeners -> Proxy.newProxyInstance(Event.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Object listener : listeners) {
                    EventResult result = (EventResult)Objects.requireNonNull(Event.invokeMethod(listener, method, args));
                    if (!result.isInterrupted()) continue;
                    return result;
                }
                return EventResult.pass();
            }
        }));
    }

    @SafeVarargs
    public static <T> Event<T> withValue(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("The array shouldn't contain anything!");
        }
        return Event.withValue(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<T> withValue(Class<T> clazz) {
        return new Event<Object>(listeners -> Proxy.newProxyInstance(Event.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Object listener : listeners) {
                    ValueEventResult result = (ValueEventResult)Objects.requireNonNull(Event.invokeMethod(listener, method, args));
                    if (!result.isInterrupted()) continue;
                    return result;
                }
                return ValueEventResult.pass();
            }
        }));
    }

    @SafeVarargs
    public static <T> Event<T> cancelable(T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("The array shouldn't contain anything!");
        }
        return Event.cancelable(typeGetter.getClass().getComponentType());
    }

    public static <T> Event<T> cancelable(Class<T> clazz) {
        return new Event<Object>(listeners -> Proxy.newProxyInstance(Event.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(@NotNull Object proxy, @NotNull Method method, Object @NotNull [] args) throws Throwable {
                for (Object listener : listeners) {
                    boolean result = (Boolean)Objects.requireNonNull(Event.invokeMethod(listener, method, args));
                    if (!result) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    private static <T, R> R invokeMethod(T listener, Method method, Object[] args) throws Throwable {
        return (R)MethodHandles.lookup().unreflect(method).bindTo(listener).invokeWithArguments(args);
    }

    public static interface Factory<T> {
        public T create(List<T> var1);
    }
}

