/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Perlin {
    private static final Random SEED_GENERATOR = new Random();
    private static final Map<Long, int[]> P_CACHE = new HashMap<Long, int[]>();
    public int repeat;
    private int[] p = new int[512];

    public Perlin(long seed, int repeat) {
        this.repeat = repeat;
        this.setSeed(seed);
    }

    public Perlin() {
        this.repeat = -1;
        this.setSeed(SEED_GENERATOR.nextLong());
    }

    public Perlin(long seed) {
        this.repeat = -1;
        this.setSeed(seed);
    }

    public void setSeed(long seed) {
        Random random = new Random(seed);
        for (int x = 0; x < 256; ++x) {
            int n;
            this.p[x] = n = random.nextInt(256);
            this.p[x + 256] = n;
        }
        P_CACHE.put(seed, this.p);
    }

    public double octavePerlin(double x, double y, double z, int octaves, double persistence) {
        double total = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        double maxValue = 0.0;
        for (int i = 0; i < octaves; ++i) {
            total += this.perlin(x * frequency, y * frequency, z * frequency) * amplitude;
            maxValue += amplitude;
            amplitude *= persistence;
            frequency *= 2.0;
        }
        return total / maxValue;
    }

    public double perlin(double x, double y, double z) {
        if (this.repeat > 0) {
            x %= (double)this.repeat;
            y %= (double)this.repeat;
            z %= (double)this.repeat;
        }
        int xi = (int)x & 0xFF;
        int yi = (int)y & 0xFF;
        int zi = (int)z & 0xFF;
        int aaa = this.p[this.p[this.p[xi] + yi] + zi];
        int aba = this.p[this.p[this.p[xi] + this.inc(yi)] + zi];
        int aab = this.p[this.p[this.p[xi] + yi] + this.inc(zi)];
        int abb = this.p[this.p[this.p[xi] + this.inc(yi)] + this.inc(zi)];
        int baa = this.p[this.p[this.p[this.inc(xi)] + yi] + zi];
        int bba = this.p[this.p[this.p[this.inc(xi)] + this.inc(yi)] + zi];
        int bab = this.p[this.p[this.p[this.inc(xi)] + yi] + this.inc(zi)];
        int bbb = this.p[this.p[this.p[this.inc(xi)] + this.inc(yi)] + this.inc(zi)];
        double xf = x - (double)((int)x);
        double yf = y - (double)((int)y);
        double zf = z - (double)((int)z);
        double u = Perlin.fade(xf);
        double v = Perlin.fade(yf);
        double w = Perlin.fade(zf);
        double x1 = Perlin.lerp(Perlin.grad(aaa, xf, yf, zf), Perlin.grad(baa, xf - 1.0, yf, zf), u);
        double x2 = Perlin.lerp(Perlin.grad(aba, xf, yf - 1.0, zf), Perlin.grad(bba, xf - 1.0, yf - 1.0, zf), u);
        double y1 = Perlin.lerp(x1, x2, v);
        x1 = Perlin.lerp(Perlin.grad(aab, xf, yf, zf - 1.0), Perlin.grad(bab, xf - 1.0, yf, zf - 1.0), u);
        x2 = Perlin.lerp(Perlin.grad(abb, xf, yf - 1.0, zf - 1.0), Perlin.grad(bbb, xf - 1.0, yf - 1.0, zf - 1.0), u);
        double y2 = Perlin.lerp(x1, x2, v);
        return Perlin.lerp(y1, y2, w);
    }

    public double octavePerlinHalf(double x, double y, double z, int octaves, double persistence) {
        double total = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        double maxValue = 0.0;
        for (int i = 0; i < octaves; ++i) {
            total += this.perlinHalf(x * frequency, y * frequency, z * frequency) * amplitude;
            maxValue += amplitude;
            amplitude *= persistence;
            frequency *= 2.0;
        }
        return total / maxValue;
    }

    public double perlinHalf(double x, double y, double z) {
        if (this.repeat > 0) {
            x %= (double)this.repeat;
            y %= (double)this.repeat;
            z %= (double)this.repeat;
        }
        int xi = (int)x & 0xFF;
        int yi = (int)y & 0xFF;
        int zi = (int)z & 0xFF;
        int aaa = this.p[this.p[this.p[xi] + yi] + zi];
        int aba = this.p[this.p[this.p[xi] + this.inc(yi)] + zi];
        int aab = this.p[this.p[this.p[xi] + yi] + this.inc(zi)];
        int abb = this.p[this.p[this.p[xi] + this.inc(yi)] + this.inc(zi)];
        int baa = this.p[this.p[this.p[this.inc(xi)] + yi] + zi];
        int bba = this.p[this.p[this.p[this.inc(xi)] + this.inc(yi)] + zi];
        int bab = this.p[this.p[this.p[this.inc(xi)] + yi] + this.inc(zi)];
        int bbb = this.p[this.p[this.p[this.inc(xi)] + this.inc(yi)] + this.inc(zi)];
        double xf = x - (double)((int)x);
        double yf = y - (double)((int)y);
        double zf = z - (double)((int)z);
        double u = Perlin.fade(xf);
        double v = Perlin.fade(yf);
        double w = Perlin.fade(zf);
        double x1 = Perlin.lerp(Perlin.grad(aaa, xf, yf, zf), Perlin.grad(baa, xf - 1.0, yf, zf), u);
        double x2 = Perlin.lerp(Perlin.grad(aba, xf, yf - 1.0, zf), Perlin.grad(bba, xf - 1.0, yf - 1.0, zf), u);
        double y1 = Perlin.lerp(x1, x2, v);
        x1 = Perlin.lerp(Perlin.grad(aab, xf, yf, zf - 1.0), Perlin.grad(bab, xf - 1.0, yf, zf - 1.0), u);
        x2 = Perlin.lerp(Perlin.grad(abb, xf, yf - 1.0, zf - 1.0), Perlin.grad(bbb, xf - 1.0, yf - 1.0, zf - 1.0), u);
        double y2 = Perlin.lerp(x1, x2, v);
        return (Perlin.lerp(y1, y2, w) + 1.0) / 2.0;
    }

    public int inc(int num) {
        ++num;
        if (this.repeat > 0) {
            num %= this.repeat;
        }
        return num;
    }

    public static double grad(int hash, double x, double y, double z) {
        switch (hash & 0xF) {
            case 0: {
                return x + y;
            }
            case 1: {
                return -x + y;
            }
            case 2: {
                return x - y;
            }
            case 3: {
                return -x - y;
            }
            case 4: {
                return x + z;
            }
            case 5: {
                return -x + z;
            }
            case 6: {
                return x - z;
            }
            case 7: {
                return -x - z;
            }
            case 8: {
                return y + z;
            }
            case 9: {
                return -y + z;
            }
            case 10: {
                return y - z;
            }
            case 11: {
                return -y - z;
            }
            case 12: {
                return y + x;
            }
            case 13: {
                return -y + z;
            }
            case 14: {
                return y - x;
            }
            case 15: {
                return -y - z;
            }
        }
        return 0.0;
    }

    public static double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    public static double lerp(double a, double b, double x) {
        return a + x * (b - a);
    }
}

