/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import shblock.interactivecorporea.ModConfig;
import shblock.interactivecorporea.common.corporea.CorporeaUtil;
import shblock.interactivecorporea.common.item.HaloModule;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;
import shblock.interactivecorporea.common.network.ModPacketHandler;
import shblock.interactivecorporea.common.network.SPacketPlayQuantizationEffect;
import shblock.interactivecorporea.common.requestinghalo.HaloAttractServerHandler;
import shblock.interactivecorporea.common.tile.ModTiles;
import shblock.interactivecorporea.common.util.CISlotPointer;
import shblock.interactivecorporea.common.util.NBTTagHelper;
import shblock.interactivecorporea.common.util.StackHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.impl.corporea.CorporeaItemStackMatcher;

public class TileItemQuantizationDevice
extends TileCorporeaBase
implements ITickableTileEntity,
IManaReceiver {
    private int mana;
    private final List<Sender> senders = new ArrayList<Sender>();

    public TileItemQuantizationDevice() {
        super(ModTiles.itemQuantizationDevice);
    }

    public int getManaCost(int itemAmount) {
        return itemAmount * (Integer)ModConfig.COMMON.quantizationConsumption.get();
    }

    public int requestItem(ItemStack stack, Vector3 requestPos, Vector3 normal, ServerPlayerEntity player, ItemStack halo) {
        if (this.field_145850_b == null) {
            return 0;
        }
        if (this.getManaCost(stack.func_190916_E()) > this.mana) {
            return 0;
        }
        ICorporeaResult result = CorporeaUtil.requestItemNoIntercept((ICorporeaRequestMatcher)new CorporeaItemStackMatcher(stack, true), stack.func_190916_E(), this.getSpark(), true);
        List stacks = result.getStacks();
        if (stacks.isEmpty()) {
            return 0;
        }
        ItemStack resultStack = (ItemStack)stacks.get(0);
        for (int i = 1; i < stacks.size(); ++i) {
            if (StackHelper.equalItemAndTag(resultStack, (ItemStack)stacks.get(i))) {
                resultStack.func_190917_f(((ItemStack)stacks.get(i)).func_190916_E());
                continue;
            }
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (ItemStack)stacks.get(i)));
        }
        Vector3 fromPos = new Vector3((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        this.senders.add(new Sender(resultStack, this.field_145850_b, fromPos, requestPos, normal, (PlayerEntity)player, ItemRequestingHalo.isModuleInstalled(halo, HaloModule.MAGNATE)));
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
        this.consumeMana(this.getManaCost(resultStack.func_190916_E()));
        return resultStack.func_190916_E();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean dirty = false;
            for (int i = this.senders.size() - 1; i >= 0; --i) {
                if (this.senders.get(i).tick()) {
                    this.senders.remove(i);
                }
                dirty = true;
                this.func_70296_d();
            }
            if (dirty) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
            }
        }
    }

    public void readPacketNBT(CompoundNBT cmp) {
        this.mana = cmp.func_74764_b("mana") ? cmp.func_74762_e("mana") : 0;
        this.senders.clear();
        if (cmp.func_74764_b("senders")) {
            ListNBT listNBT = cmp.func_150295_c("senders", 10);
            for (INBT nbt : listNBT) {
                Sender sender = new Sender();
                sender.deserializeNBT((CompoundNBT)nbt);
                this.senders.add(sender);
            }
        }
    }

    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a("mana", this.mana);
        ListNBT listNBT = new ListNBT();
        for (Sender sender : this.senders) {
            listNBT.add((Object)sender.serializeNBT());
        }
        cmp.func_218657_a("senders", (INBT)listNBT);
    }

    public double getLightRelayRenderScale() {
        double scale = 0.0;
        for (Sender sender : this.senders) {
            double s = sender.getLightRelayRenderScale();
            if (!(scale < s)) continue;
            scale = s;
        }
        return scale;
    }

    public boolean isFull() {
        return this.mana >= this.getManaCapacity();
    }

    public void receiveMana(int receive) {
        this.mana += receive;
        if (this.mana >= this.getManaCapacity()) {
            this.mana = this.getManaCapacity();
        }
        this.func_70296_d();
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public int getManaCapacity() {
        return (Integer)ModConfig.COMMON.quantizationDeviceManaCapacity.get();
    }

    public int getComparatorLevel() {
        return TilePool.calculateComparatorLevel((int)this.mana, (int)this.getManaCapacity());
    }

    public boolean consumeMana(int consume) {
        if (consume <= this.mana) {
            this.mana -= consume;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private static class Sender
    implements INBTSerializable<CompoundNBT> {
        private int type;
        private ItemStack stack;
        private World world;
        private Vector3 fromPos;
        private Vector3 pos;
        private Vector3 normal;
        private int time;
        private PlayerEntity player;
        private boolean shouldAttract;
        private CISlotPointer haloSlot;
        private int slot;

        public Sender() {
            this.time = (Integer)ModConfig.COMMON.quantizationAnimationSpeed.get() * 3;
        }

        public Sender(ItemStack stack, World world, Vector3 fromPos, Vector3 pos, Vector3 normal, @Nullable PlayerEntity player, boolean shouldAttract) {
            this.time = (Integer)ModConfig.COMMON.quantizationAnimationSpeed.get() * 3;
            this.stack = stack.func_77946_l();
            this.world = world;
            this.fromPos = fromPos;
            this.pos = pos;
            this.normal = normal;
            this.player = player;
            this.shouldAttract = shouldAttract;
        }

        public boolean tick() {
            int spd = (Integer)ModConfig.COMMON.quantizationAnimationSpeed.get();
            if (!this.world.field_72995_K) {
                if (this.time == spd * 3) {
                    ModPacketHandler.sendToPlayersInWorld((ServerWorld)this.world, new SPacketPlayQuantizationEffect(this.stack, spd * 2, this.fromPos, 1.0));
                } else if (this.time == spd * 2) {
                    ModPacketHandler.sendToPlayersInWorld((ServerWorld)this.world, new SPacketPlayQuantizationEffect(this.stack, spd * 2, this.pos, this.normal, 1.0));
                } else if (this.time == 0) {
                    this.onComplete();
                }
                --this.time;
            }
            return this.time < 0;
        }

        private double getLightRelayRenderScale() {
            return 1.0 - (Math.cos(Math.max((double)this.time - 10.0 - (double)ClientTickHandler.partialTicks, 0.0) / 10.0 * Math.PI) + 1.0) / 2.0;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("type", this.type);
            nbt.func_218657_a("stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
            NBTTagHelper.putWorld(nbt, "world", this.world);
            nbt.func_218657_a("fromPos", (INBT)NBTTagHelper.putVector3(this.fromPos));
            nbt.func_218657_a("pos", (INBT)NBTTagHelper.putVector3(this.pos));
            nbt.func_218657_a("normal", (INBT)NBTTagHelper.putVector3(this.normal));
            nbt.func_74768_a("time", this.time);
            if (this.player != null) {
                nbt.func_186854_a("player", this.player.func_110124_au());
            }
            if (this.type == 1) {
                nbt.func_218657_a("haloSlot", (INBT)NBTTagHelper.putCISlot(this.haloSlot));
                nbt.func_74768_a("craftingSlot", this.slot);
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.type = nbt.func_74762_e("type");
            this.stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack"));
            this.world = NBTTagHelper.getWorld(nbt, "world");
            this.fromPos = NBTTagHelper.getVector3(nbt.func_74775_l("fromPos"));
            this.pos = NBTTagHelper.getVector3(nbt.func_74775_l("pos"));
            this.normal = NBTTagHelper.getVector3(nbt.func_74775_l("normal"));
            this.time = nbt.func_74762_e("time");
            if (nbt.func_74764_b("player")) {
                this.player = this.world.func_217371_b(nbt.func_186857_a("player"));
            }
            if (this.type == 1) {
                this.haloSlot = NBTTagHelper.getCISlot(nbt.func_74775_l("haloSlot"));
                this.slot = nbt.func_74762_e("craftingSlot");
            }
        }

        private void onComplete() {
            this.summonItemEntity();
        }

        private void summonItemEntity() {
            while (this.stack.func_190916_E() > 0) {
                int cnt = Math.min(this.stack.func_190916_E(), this.stack.func_77976_d());
                ItemStack spawnStack = this.stack.func_77946_l();
                spawnStack.func_190920_e(cnt);
                this.stack.func_190918_g(cnt);
                ItemEntity entity = new ItemEntity(this.world, this.pos.x, this.pos.y, this.pos.z, spawnStack);
                entity.func_213293_j(0.0, 0.0, 0.0);
                this.world.func_217376_c((Entity)entity);
                if (!this.shouldAttract || this.player == null) continue;
                HaloAttractServerHandler.addToAttractedItems(this.player, entity);
            }
        }
    }
}

