/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import shblock.interactivecorporea.IC;
import shblock.interactivecorporea.client.requestinghalo.RequestingHaloInterfaceHandler;
import shblock.interactivecorporea.common.util.NetworkHelper;

public class SPacketUpdateItemList {
    private final List<ItemStack> itemList;

    public SPacketUpdateItemList(List<ItemStack> itemList) {
        this.itemList = itemList;
    }

    public static SPacketUpdateItemList decode(PacketBuffer buf) {
        int len = buf.func_150792_a();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < len; ++i) {
            itemList.add(NetworkHelper.readBigStack(buf));
        }
        return new SPacketUpdateItemList(itemList);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.itemList.size());
        for (ItemStack stack : this.itemList) {
            NetworkHelper.writeBigStack(buf, stack, false);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IC.debug("Update packet received");
            RequestingHaloInterfaceHandler.handleUpdatePacket(this.itemList);
        });
        ctx.get().setPacketHandled(true);
    }
}

