/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.network;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import shblock.interactivecorporea.IC;
import shblock.interactivecorporea.common.corporea.CorporeaUtil;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;
import shblock.interactivecorporea.common.network.ModPacketHandler;
import shblock.interactivecorporea.common.network.SPacketUpdateItemList;
import shblock.interactivecorporea.common.util.CISlotPointer;
import shblock.interactivecorporea.common.util.NetworkHelper;
import shblock.interactivecorporea.common.util.WorldHelper;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaSpark;

public class CPacketRequestItemListUpdate {
    private final CISlotPointer slot;

    public CPacketRequestItemListUpdate(CISlotPointer slot) {
        this.slot = slot;
    }

    public static CPacketRequestItemListUpdate decode(PacketBuffer buf) {
        return new CPacketRequestItemListUpdate(NetworkHelper.readCISlotPointer(buf));
    }

    public void encode(PacketBuffer buf) {
        NetworkHelper.writeCISlotPointer(buf, this.slot);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = this.slot.getStack((PlayerEntity)player);
            if (!(stack.func_77973_b() instanceof ItemRequestingHalo)) {
                return;
            }
            GlobalPos pos = ItemRequestingHalo.getBoundIndexPosition(stack);
            if (pos == null) {
                return;
            }
            ICorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(WorldHelper.getWorldFromName((RegistryKey<World>)pos.func_239646_a_()), pos.func_218180_b());
            if (spark == null) {
                return;
            }
            List<ItemStack> result = CorporeaUtil.getAllItemsCompacted(spark);
            ModPacketHandler.sendToPlayer(player, new SPacketUpdateItemList(result));
            IC.debug("Update item list packet sent to player: " + player.func_146103_bH().getName());
        });
        ctx.get().setPacketHandled(true);
    }
}

