/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;
import shblock.interactivecorporea.common.network.ModPacketHandler;
import shblock.interactivecorporea.common.network.SPacketRequestResult;
import shblock.interactivecorporea.common.tile.TileItemQuantizationDevice;
import shblock.interactivecorporea.common.util.CISlotPointer;
import shblock.interactivecorporea.common.util.NetworkHelper;
import shblock.interactivecorporea.common.util.WorldHelper;
import vazkii.botania.common.core.helper.Vector3;

public class CPacketRequestItem {
    private final CISlotPointer slot;
    private final ItemStack stack;
    private final Vector3 requestPos;
    private final Vector3 normal;
    private final int requestId;

    public CPacketRequestItem(CISlotPointer slot, ItemStack stack, Vector3 requestPos, Vector3 normal, int requestId) {
        this.slot = slot;
        this.stack = stack;
        this.requestPos = requestPos;
        this.normal = normal;
        this.requestId = requestId;
    }

    public static CPacketRequestItem decode(PacketBuffer buf) {
        return new CPacketRequestItem(NetworkHelper.readCISlotPointer(buf), NetworkHelper.readBigStack(buf), NetworkHelper.readVector3(buf), NetworkHelper.readVector3(buf), buf.readInt());
    }

    public void encode(PacketBuffer buf) {
        NetworkHelper.writeCISlotPointer(buf, this.slot);
        NetworkHelper.writeBigStack(buf, this.stack, false);
        NetworkHelper.writeVector3(buf, this.requestPos);
        NetworkHelper.writeVector3(buf, this.normal);
        buf.writeInt(this.requestId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack halo = this.slot.getStack((PlayerEntity)player);
            if (!(halo.func_77973_b() instanceof ItemRequestingHalo)) {
                return;
            }
            GlobalPos pos = ItemRequestingHalo.getBoundSenderPosition(halo);
            if (pos == null) {
                return;
            }
            World world = WorldHelper.getWorldFromName((RegistryKey<World>)pos.func_239646_a_());
            if (world == null) {
                return;
            }
            TileEntity te = world.func_175625_s(pos.func_218180_b());
            if (!(te instanceof TileItemQuantizationDevice)) {
                return;
            }
            TileItemQuantizationDevice qd = (TileItemQuantizationDevice)te;
            ItemStack reqStack = this.stack.func_77946_l();
            int successAmount = qd.requestItem(reqStack, this.requestPos, this.normal, player, halo);
            ModPacketHandler.sendToPlayer(player, new SPacketRequestResult(this.requestId, successAmount));
        });
    }
}

