/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.network;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;
import shblock.interactivecorporea.common.requestinghalo.HaloAttractServerHandler;
import shblock.interactivecorporea.common.util.CISlotPointer;
import shblock.interactivecorporea.common.util.NetworkHelper;
import vazkii.botania.common.core.helper.Vector3;

public class CPacketChangeStackInHaloCraftingSlot {
    private final CISlotPointer haloSlot;
    private final int slot;
    private final boolean isPut;
    private final Vector3 clickPos;

    public CPacketChangeStackInHaloCraftingSlot(CISlotPointer haloSlot, int slot, boolean isPut, Vector3 clickPos) {
        this.haloSlot = haloSlot;
        this.slot = slot;
        this.isPut = isPut;
        this.clickPos = clickPos;
    }

    public static CPacketChangeStackInHaloCraftingSlot decode(PacketBuffer buf) {
        return new CPacketChangeStackInHaloCraftingSlot(NetworkHelper.readCISlotPointer(buf), buf.readInt(), buf.readBoolean(), new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
    }

    public void encode(PacketBuffer buf) {
        NetworkHelper.writeCISlotPointer(buf, this.haloSlot);
        buf.writeInt(this.slot);
        buf.writeBoolean(this.isPut);
        buf.writeDouble(this.clickPos.x);
        buf.writeDouble(this.clickPos.y);
        buf.writeDouble(this.clickPos.z);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack halo = this.haloSlot.getStack((PlayerEntity)player);
            if (!(halo.func_77973_b() instanceof ItemRequestingHalo)) {
                return;
            }
            ItemStack putStack = player.func_184614_ca();
            if (this.isPut) {
                player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                ItemRequestingHalo.tryPutStackInCraftingSlot(halo, this.slot, putStack, replacedStack -> {
                    ItemEntity ie = new ItemEntity(player.field_70170_p, this.clickPos.x, this.clickPos.y, this.clickPos.z, replacedStack);
                    ie.func_213293_j(0.0, 0.0, 0.0);
                    HaloAttractServerHandler.attractIfHasModule((PlayerEntity)player, ie, halo);
                    player.field_70170_p.func_217376_c((Entity)ie);
                }, newAddStack -> player.func_184611_a(Hand.MAIN_HAND, newAddStack));
            } else {
                ItemStack removedStack = ItemRequestingHalo.setStackInCraftingSlot(halo, this.slot, ItemStack.field_190927_a);
                if (!removedStack.func_190926_b()) {
                    ItemEntity ie = new ItemEntity(player.field_70170_p, this.clickPos.x, this.clickPos.y, this.clickPos.z, removedStack);
                    ie.func_213293_j(0.0, 0.0, 0.0);
                    HaloAttractServerHandler.attractIfHasModule((PlayerEntity)player, ie, halo);
                    player.field_70170_p.func_217376_c((Entity)ie);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

