/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.item;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import shblock.interactivecorporea.IC;
import shblock.interactivecorporea.client.renderer.item.ISTERRequestingHalo;
import shblock.interactivecorporea.client.requestinghalo.RequestingHaloInterface;
import shblock.interactivecorporea.client.requestinghalo.RequestingHaloInterfaceHandler;
import shblock.interactivecorporea.client.util.KeyboardHelper;
import shblock.interactivecorporea.common.block.BlockItemQuantizationDevice;
import shblock.interactivecorporea.common.item.HaloModule;
import shblock.interactivecorporea.common.util.CISlotPointer;
import shblock.interactivecorporea.common.util.NBTTagHelper;
import shblock.interactivecorporea.common.util.StackHelper;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.common.block.corporea.BlockCorporeaIndex;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemRequestingHalo
extends Item
implements IManaUsingItem {
    private static final String PREFIX_INDEX_POS = "bound_position";
    private static final String PREFIX_SENDER_POS = "sender_position";
    private static final String PREFIX_MODULES = "modules";
    private static final String PREFIX_CRAFTING_SLOT_ITEMS = "crafting_slot_items";

    public ItemRequestingHalo() {
        super(new Item.Properties().func_200916_a(IC.ITEM_GROUP).func_200917_a(1).setISTER(() -> ISTERRequestingHalo::new));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, slot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K && hand == Hand.MAIN_HAND) {
            if (RequestingHaloInterfaceHandler.isInterfaceOpened()) {
                RequestingHaloInterfaceHandler.closeInterface();
            } else {
                RequestingHaloInterfaceHandler.openInterface(new RequestingHaloInterface(new CISlotPointer(player.field_71071_by.field_70461_c)));
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Nullable
    public static GlobalPos getBoundIndexPosition(ItemStack stack) {
        return NBTTagHelper.getGlobalPos(ItemNBTHelper.get((ItemStack)stack, (String)PREFIX_INDEX_POS));
    }

    @Nullable
    public static GlobalPos getBoundSenderPosition(ItemStack stack) {
        return NBTTagHelper.getGlobalPos(ItemNBTHelper.get((ItemStack)stack, (String)PREFIX_SENDER_POS));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (context.func_195999_j() == null) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            if (context.func_195999_j().func_225608_bj_()) {
                String prefix;
                if (block instanceof BlockCorporeaIndex) {
                    prefix = PREFIX_INDEX_POS;
                } else if (block instanceof BlockItemQuantizationDevice) {
                    prefix = PREFIX_SENDER_POS;
                } else {
                    return ActionResultType.CONSUME;
                }
                RegistryKey worldKey = world.func_234923_W_();
                GlobalPos globalPos = GlobalPos.func_239648_a_((RegistryKey)worldKey, (BlockPos)pos);
                ItemNBTHelper.set((ItemStack)context.func_195996_i(), (String)prefix, (INBT)NBTTagHelper.putGlobalPos(globalPos));
                return ActionResultType.SUCCESS;
            }
        } else if (context.func_195999_j().func_225608_bj_()) {
            if (block instanceof BlockCorporeaIndex || block instanceof BlockItemQuantizationDevice) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public static boolean installModule(ItemStack stack, HaloModule module) {
        int mask = ItemNBTHelper.getInt((ItemStack)stack, (String)PREFIX_MODULES, (int)0);
        if (module.containsThis(mask)) {
            return false;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)PREFIX_MODULES, (int)(mask | module.bitMask));
        return true;
    }

    public static boolean uninstallModule(ItemStack stack, HaloModule module) {
        int mask = ItemNBTHelper.getInt((ItemStack)stack, (String)PREFIX_MODULES, (int)0);
        if (module.containsThis(mask)) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)PREFIX_MODULES, (int)(mask - module.bitMask));
            return true;
        }
        return false;
    }

    public static boolean isModuleInstalled(ItemStack stack, HaloModule module) {
        int mask = ItemNBTHelper.getInt((ItemStack)stack, (String)PREFIX_MODULES, (int)0);
        return module.containsThis(mask);
    }

    public static boolean isAnyModuleInstalled(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)PREFIX_MODULES, (int)0) != 0;
    }

    public static ListNBT getOrCreateCraftingSlotNBTList(ItemStack halo) {
        boolean didChange = false;
        ListNBT nbt = ItemNBTHelper.getList((ItemStack)halo, (String)PREFIX_CRAFTING_SLOT_ITEMS, (int)10, (boolean)true);
        if (nbt == null) {
            nbt = new ListNBT();
            didChange = true;
        }
        for (int i = nbt.size(); i < 9; ++i) {
            nbt.add((Object)new CompoundNBT());
        }
        if (didChange) {
            ItemNBTHelper.setList((ItemStack)halo, (String)PREFIX_CRAFTING_SLOT_ITEMS, (ListNBT)nbt);
        }
        return nbt;
    }

    public static boolean tryPutStackInCraftingSlot(ItemStack halo, int slot, ItemStack orgAddStack, Consumer<ItemStack> replaceHandler, Consumer<ItemStack> addStackHandler) {
        if (slot > 8 || slot < 0 || orgAddStack.func_190926_b()) {
            return false;
        }
        ItemStack addStack = orgAddStack.func_77946_l();
        ItemStack orgStack = ItemRequestingHalo.getStackInCraftingSlot(halo, slot);
        Pair<Boolean, ItemStack> addResult = StackHelper.addToAnotherStack(addStack, orgStack);
        orgStack = (ItemStack)addResult.getSecond();
        ListNBT list = ItemRequestingHalo.getOrCreateCraftingSlotNBTList(halo);
        if (((Boolean)addResult.getFirst()).booleanValue()) {
            addStackHandler.accept(addStack);
            list.set(slot, (INBT)orgStack.func_77955_b(new CompoundNBT()));
        } else {
            replaceHandler.accept(orgStack);
            addStackHandler.accept(ItemStack.field_190927_a);
            list.set(slot, (INBT)addStack.func_77955_b(new CompoundNBT()));
        }
        return true;
    }

    public static ItemStack getStackInCraftingSlot(ItemStack halo, int slot) {
        ListNBT list = ItemRequestingHalo.getOrCreateCraftingSlotNBTList(halo);
        return ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(slot));
    }

    public static ItemStack setStackInCraftingSlot(ItemStack halo, int slot, ItemStack newStack) {
        ListNBT list = ItemRequestingHalo.getOrCreateCraftingSlotNBTList(halo);
        ItemStack oldStack = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(slot));
        list.set(slot, (INBT)(newStack.func_190926_b() ? new CompoundNBT() : newStack.func_77955_b(new CompoundNBT())));
        return oldStack;
    }

    private String globalPosToString(GlobalPos pos) {
        return pos.func_239646_a_().func_240901_a_() + " (" + pos.func_218180_b().func_229422_x_() + ")";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GlobalPos indexPos = ItemRequestingHalo.getBoundIndexPosition(stack);
        GlobalPos senderPos = ItemRequestingHalo.getBoundSenderPosition(stack);
        if (KeyboardHelper.hasShiftDown()) {
            String temp = indexPos == null ? I18n.func_135052_a((String)"interactive_corporea.requesting_halo.tooltip.null", (Object[])new Object[0]) : "\n    " + this.globalPosToString(indexPos);
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"interactive_corporea.requesting_halo.tooltip.index_pos", (Object[])new Object[0]) + temp));
            temp = senderPos == null ? I18n.func_135052_a((String)"interactive_corporea.requesting_halo.tooltip.null", (Object[])new Object[0]) : "\n    " + this.globalPosToString(senderPos);
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"interactive_corporea.requesting_halo.tooltip.sender_pos", (Object[])new Object[0]) + temp));
            if (ItemRequestingHalo.isAnyModuleInstalled(stack)) {
                StringBuilder builder = new StringBuilder(I18n.func_135052_a((String)"interactive_corporea.requesting_halo.tooltip.modules_prefix", (Object[])new Object[0]));
                builder.append("\u00a7r| ");
                for (HaloModule module : HaloModule.values()) {
                    boolean installed = ItemRequestingHalo.isModuleInstalled(stack, module);
                    builder.append(installed ? "\u00a76" : "\u00a78");
                    builder.append(I18n.func_135052_a((String)module.translationKey, (Object[])new Object[0]));
                    builder.append("\u00a7r | ");
                }
                tooltip.add((ITextComponent)new StringTextComponent(builder.toString()));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"interactive_corporea.requesting_halo.tooltip.modules_prefix", (Object[])new Object[0]) + I18n.func_135052_a((String)"interactive_corporea.requesting_halo.tooltip.null", (Object[])new Object[0])));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("interactive_corporea.tooltip.shift_for_more"));
        }
    }

    public boolean func_195938_a(BlockState bs, World world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public boolean usesMana(ItemStack stack) {
        return true;
    }

    public boolean func_77651_p() {
        return super.func_77651_p();
    }
}

