/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.crafting;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import shblock.interactivecorporea.common.item.HaloModule;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RequestingHaloRemoveModuleRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<RequestingHaloRemoveModuleRecipe> SERIALIZER = new SpecialRecipeSerializer(RequestingHaloRemoveModuleRecipe::new);

    public RequestingHaloRemoveModuleRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World world) {
        boolean foundHalo = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemRequestingHalo) {
                if (!ItemRequestingHalo.isAnyModuleInstalled(stack)) {
                    return false;
                }
                if (foundHalo) {
                    return false;
                }
                foundHalo = true;
                continue;
            }
            return false;
        }
        return foundHalo;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack halo = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemRequestingHalo) {
                if (!ItemRequestingHalo.isAnyModuleInstalled(stack)) {
                    return ItemStack.field_190927_a;
                }
                if (halo != null) {
                    return ItemStack.field_190927_a;
                }
                halo = stack;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (halo == null) {
            return ItemStack.field_190927_a;
        }
        for (HaloModule module : HaloModule.values()) {
            if (!ItemRequestingHalo.isModuleInstalled(halo, module)) continue;
            return new ItemStack((IItemProvider)module.getItem());
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return RecipeUtils.getRemainingItemsSub((IInventory)inv, s -> {
            if (s.func_77973_b() instanceof ItemRequestingHalo) {
                ItemStack hs = s.func_77946_l();
                for (HaloModule module : HaloModule.values()) {
                    if (!ItemRequestingHalo.uninstallModule(hs, module)) continue;
                    return hs;
                }
            }
            return null;
        });
    }

    public boolean func_194133_a(int width, int height) {
        return width + height > 0;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

