/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.common.crafting;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import shblock.interactivecorporea.common.item.HaloModule;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;

public class RequestingHaloAddModuleRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<RequestingHaloAddModuleRecipe> SERIALIZER = new SpecialRecipeSerializer(RequestingHaloAddModuleRecipe::new);

    public RequestingHaloAddModuleRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World world) {
        boolean foundHalo = false;
        boolean foundModule = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemRequestingHalo) {
                if (foundHalo) {
                    return false;
                }
                foundHalo = true;
                continue;
            }
            if (HaloModule.fromItem(stack.func_77973_b().getRegistryName()) != null) {
                if (foundModule) {
                    return false;
                }
                foundModule = true;
                continue;
            }
            return false;
        }
        return foundHalo && foundModule;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack halo = null;
        HaloModule module = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemRequestingHalo) {
                if (halo != null) {
                    return ItemStack.field_190927_a;
                }
                halo = stack.func_77946_l();
                continue;
            }
            HaloModule m = HaloModule.fromItem(stack.func_77973_b().getRegistryName());
            if (m != null) {
                if (module != null) {
                    return ItemStack.field_190927_a;
                }
                module = m;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (halo == null || module == null) {
            return ItemStack.field_190927_a;
        }
        if (!ItemRequestingHalo.installModule(halo, module)) {
            return ItemStack.field_190927_a;
        }
        return halo;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

