/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.wormhole;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL44;
import shblock.interactivecorporea.IC;
import shblock.interactivecorporea.client.render.RenderUtil;
import shblock.interactivecorporea.client.wormhole.Wormhole;
import shblock.interactivecorporea.common.util.Vec2d;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.helper.Vector3;

public class WormholeRenderer {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final int MAX_AMOUNT = 64;
    private static final int DATA_LENGTH = 7;
    private static final Framebuffer swapBuffer = new Framebuffer(WormholeRenderer.mc.func_147110_a().field_147621_c, WormholeRenderer.mc.func_147110_a().field_147618_d, false, Minecraft.field_142025_a);
    private static final Framebuffer depthBuffer = new Framebuffer(WormholeRenderer.mc.func_147110_a().field_147621_c, WormholeRenderer.mc.func_147110_a().field_147618_d, true, Minecraft.field_142025_a);
    private static boolean didCopyDepth;
    private static int postFragShader;
    private static int postProgram;
    private static int dataTbo;
    private static int dataTex;
    private static boolean enableShader;
    private static boolean initialed;

    private static void init() throws IOException {
        WormholeRenderer.loadShader();
        dataTbo = GL44.glGenBuffers();
        GL44.glBindBuffer((int)35882, (int)dataTbo);
        GL44.glBufferData((int)35882, (long)1792L, (int)35048);
        GL44.glBindBuffer((int)35882, (int)0);
        dataTex = GL44.glGenTextures();
        GL44.glActiveTexture((int)34015);
        GL44.glBindTexture((int)35882, (int)dataTex);
        GL44.glTexBuffer((int)35882, (int)33326, (int)dataTbo);
        GL44.glBindTexture((int)35882, (int)0);
        GL44.glActiveTexture((int)33984);
        IC.debug("Wormhole renderer init complete");
    }

    public static void loadShader() throws IOException {
        postFragShader = GL44.glCreateShader((int)35632);
        GL44.glShaderSource((int)postFragShader, (CharSequence)TextureUtil.func_225687_b_((InputStream)mc.func_195551_G().func_199002_a(new ResourceLocation("interactive_corporea", "shaders/wormhole/wormhole.frag")).func_199027_b()));
        GL44.glCompileShader((int)postFragShader);
        if (GL44.glGetShaderi((int)postFragShader, (int)35713) == 0) {
            throw new IOException("Wormhole fragment shader compile failed:\n" + GL44.glGetShaderInfoLog((int)postFragShader));
        }
        postProgram = GL44.glCreateProgram();
        GL44.glAttachShader((int)postProgram, (int)postFragShader);
        GL44.glLinkProgram((int)postProgram);
        if (GL44.glGetProgrami((int)postProgram, (int)35714) == 0) {
            throw new IOException("Wormhole shader linking failed:\n" + GL44.glGetProgramInfoLog((int)postProgram));
        }
        Uniforms.initUniformLocations(WormholeRenderer.postProgram);
        IC.debug("Wormhole shaders load complete");
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!didCopyDepth) {
            WormholeRenderer.copyDepth();
        }
        didCopyDepth = false;
    }

    public static void copyDepth() {
        if (enableShader) {
            Framebuffer mainFrameBuffer = mc.func_147110_a();
            depthBuffer.func_216491_a(mainFrameBuffer.field_147621_c, mainFrameBuffer.field_147618_d, Minecraft.field_142025_a);
            depthBuffer.func_216493_b(Minecraft.field_142025_a);
            depthBuffer.func_237506_a_(mainFrameBuffer);
            didCopyDepth = true;
        }
    }

    private static float[] generateData() {
        Wormhole hole = new Wormhole(new Vector3(153.0, 7.0, -298.0), new Vector3(1.0, 0.0, 0.0), 0.5);
        hole.radius = 1.0;
        Vector3 localPos = RenderUtil.worldPosToLocalPos(hole.pos);
        Vec2d midTexCoord = RenderUtil.texCoordFromNDC(RenderUtil.calcNDC(hole.pos));
        return new float[]{(float)localPos.x, (float)localPos.y, (float)localPos.z, (float)hole.normal.x, (float)hole.normal.y, (float)hole.normal.z, (float)hole.radius, (float)midTexCoord.x, (float)midTexCoord.y};
    }

    public static void postProcess() {
        block4: {
            if (!enableShader) {
                return;
            }
            if (!initialed) {
                try {
                    WormholeRenderer.init();
                    initialed = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)e);
                }
            }
        }
        Framebuffer mainFrameBuffer = mc.func_147110_a();
        swapBuffer.func_216491_a(mainFrameBuffer.field_147621_c, mainFrameBuffer.field_147618_d, Minecraft.field_142025_a);
        mainFrameBuffer.func_147609_e();
        int width = WormholeRenderer.swapBuffer.field_147622_a;
        int height = WormholeRenderer.swapBuffer.field_147620_b;
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        RenderSystem.enableBlend();
        RenderSystem.blendEquation((int)32774);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        ShaderLinkHelper.func_227804_a_((int)postProgram);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)mainFrameBuffer.func_242996_f());
        GL44.glTexParameteri((int)3553, (int)10242, (int)33648);
        GL44.glTexParameteri((int)3553, (int)10243, (int)33648);
        RenderSystem.glUniform1i((int)Uniforms.MAIN_SAMPLER, (int)0);
        RenderSystem.activeTexture((int)33985);
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)depthBuffer.func_242997_g());
        RenderSystem.glUniform1i((int)Uniforms.MAIN_DEPTH_SAMPLER, (int)1);
        GL44.glActiveTexture((int)34015);
        GL44.glBindBuffer((int)35882, (int)dataTbo);
        GL44.glBufferSubData((int)35882, (long)0L, (float[])WormholeRenderer.generateData());
        GL44.glBindTexture((int)35882, (int)dataTex);
        GL44.glTexBuffer((int)35882, (int)33326, (int)dataTbo);
        RenderSystem.glUniform1i((int)Uniforms.DATA, (int)31);
        GL44.glUniform2f((int)Uniforms.SCREEN_SIZE, (float)width, (float)height);
        GL44.glUniform1f((int)Uniforms.TIME, (float)ClientTickHandler.total);
        WormholeRenderer.applyShaderProjectionData();
        swapBuffer.func_216493_b(Minecraft.field_142025_a);
        swapBuffer.func_147610_a(false);
        RenderSystem.depthFunc((int)519);
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_225582_a_(0.0, 0.0, 500.0).func_181675_d();
        bufferBuilder.func_225582_a_(0.0, (double)height, 500.0).func_181675_d();
        bufferBuilder.func_225582_a_((double)width, (double)height, 500.0).func_181675_d();
        bufferBuilder.func_225582_a_((double)width, 0.0, 500.0).func_181675_d();
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        GlStateManager.func_227727_h_((int)36008, (int)WormholeRenderer.swapBuffer.field_147616_f);
        GlStateManager.func_227727_h_((int)36009, (int)mainFrameBuffer.field_147616_f);
        GlStateManager.func_237510_a_((int)0, (int)0, (int)WormholeRenderer.swapBuffer.field_147621_c, (int)WormholeRenderer.swapBuffer.field_147618_d, (int)0, (int)0, (int)mainFrameBuffer.field_147621_c, (int)mainFrameBuffer.field_147618_d, (int)16384, (int)9728);
        GlStateManager.func_227727_h_((int)36160, (int)0);
        RenderSystem.depthFunc((int)515);
        ShaderLinkHelper.func_227804_a_((int)0);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.disableTexture();
        RenderSystem.bindTexture((int)0);
        RenderSystem.activeTexture((int)33985);
        RenderSystem.disableTexture();
        RenderSystem.bindTexture((int)0);
        swapBuffer.func_147609_e();
        mainFrameBuffer.func_147606_d();
    }

    private static void applyShaderProjectionData() {
        ActiveRenderInfo info = WormholeRenderer.mc.field_71460_t.func_215316_n();
        double aspectRatio = (double)mc.func_228018_at_().func_198109_k() / (double)mc.func_228018_at_().func_198091_l();
        double fov = WormholeRenderer.mc.field_71460_t.func_215311_a(info, ClientTickHandler.partialTicks, true);
        fov = Math.toRadians(fov) / 2.0;
        Vector3d dir = Vector3d.func_189986_a((float)(info.func_216777_e() * 0.9999f), (float)(info.func_216778_f() * 0.9999f));
        Vector3 dir1 = new Vector3(dir);
        Vector3 perpendicularX = dir1.yCrossProduct().normalize();
        Vector3 perpendicularY = dir1.crossProduct(perpendicularX).normalize();
        GL44.glUniform1f((int)Uniforms.ASPECT_RATIO, (float)((float)aspectRatio));
        GL44.glUniform3f((int)Uniforms.MID_DIRECTION, (float)((float)dir.field_72450_a), (float)((float)dir.field_72448_b), (float)((float)dir.field_72449_c));
        GL44.glUniform1f((int)Uniforms.FOV, (float)((float)fov));
        GL44.glUniform3f((int)Uniforms.PERPENDICULAR_X, (float)((float)perpendicularX.x), (float)((float)perpendicularX.y), (float)((float)perpendicularX.z));
        GL44.glUniform3f((int)Uniforms.PERPENDICULAR_Y, (float)((float)perpendicularY.x), (float)((float)perpendicularY.y), (float)((float)perpendicularY.z));
        GL44.glUniform1f((int)Uniforms.FAR_PLANE, (float)WormholeRenderer.mc.field_71460_t.func_205001_m());
    }

    public static boolean isShaderEnabled() {
        return enableShader;
    }

    public static void setShaderEnabled(boolean enable) {
        enableShader = enable;
    }

    private static class Uniforms {
        private static int MAIN_SAMPLER;
        private static int MAIN_DEPTH_SAMPLER;
        private static int DATA;
        private static int SCREEN_SIZE;
        private static int TIME;
        private static int ASPECT_RATIO;
        private static int MID_DIRECTION;
        private static int FOV;
        private static int PERPENDICULAR_X;
        private static int PERPENDICULAR_Y;
        private static int FAR_PLANE;

        private Uniforms() {
        }

        private static void initUniformLocations(int program) {
            MAIN_SAMPLER = GL44.glGetUniformLocation((int)program, (CharSequence)"mainSampler");
            MAIN_DEPTH_SAMPLER = GL44.glGetUniformLocation((int)program, (CharSequence)"mainDepthSampler");
            DATA = GL44.glGetUniformLocation((int)program, (CharSequence)"data");
            SCREEN_SIZE = GL44.glGetUniformLocation((int)program, (CharSequence)"screenSize");
            TIME = GL44.glGetUniformLocation((int)program, (CharSequence)"time");
            ASPECT_RATIO = GL44.glGetUniformLocation((int)program, (CharSequence)"aspectRatio");
            MID_DIRECTION = GL44.glGetUniformLocation((int)program, (CharSequence)"midDirection");
            FOV = GL44.glGetUniformLocation((int)program, (CharSequence)"fov");
            PERPENDICULAR_X = GL44.glGetUniformLocation((int)program, (CharSequence)"perpendicularX");
            PERPENDICULAR_Y = GL44.glGetUniformLocation((int)program, (CharSequence)"perpendicularY");
            FAR_PLANE = GL44.glGetUniformLocation((int)program, (CharSequence)"farPlane");
        }
    }
}

