/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.ModList;

public class SearchHelper {
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static boolean matchItem(ItemStack stack, String[] segments) {
        block7: for (String seg : segments) {
            if (seg.length() == 0) continue;
            String subSeg = seg.substring(1);
            Item item = stack.func_77973_b();
            switch (seg.charAt(0)) {
                case '@': {
                    String modid = item.getCreatorModId(stack);
                    String modName = ModList.get().getModContainerById(modid).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(modid);
                    if (SearchHelper.matchString(modName, subSeg)) continue block7;
                    return false;
                }
                case '#': {
                    List textComponents = stack.func_82840_a((PlayerEntity)SearchHelper.mc.field_71439_g, (ITooltipFlag)(SearchHelper.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                    boolean anyTooltipMatch = false;
                    for (ITextComponent textComponent : textComponents) {
                        if (!SearchHelper.matchString(textComponent.getString(), subSeg)) continue;
                        anyTooltipMatch = true;
                        break;
                    }
                    if (anyTooltipMatch) continue block7;
                    return false;
                }
                case '$': {
                    HashSet tags = new HashSet(item.getTags());
                    if (item instanceof BlockItem) {
                        Block block = ((BlockItem)item).func_179223_d();
                        tags.addAll(block.getTags());
                    }
                    boolean anyTagMatch = false;
                    for (ResourceLocation tag : tags) {
                        if (!SearchHelper.matchString(tag.toString(), subSeg)) continue;
                        anyTagMatch = true;
                        break;
                    }
                    if (anyTagMatch) continue block7;
                    return false;
                }
                case '%': {
                    Collection groups = item.getCreativeTabs();
                    boolean anyTabMatch = false;
                    for (ItemGroup group : groups) {
                        if (!SearchHelper.matchString(group.func_242392_c().getString(), subSeg)) continue;
                        anyTabMatch = true;
                    }
                    if (anyTabMatch) continue block7;
                    return false;
                }
                case '&': {
                    ResourceLocation rid = item.getRegistryName();
                    if (SearchHelper.matchString(rid.toString(), subSeg)) continue block7;
                    return false;
                }
                default: {
                    if (SearchHelper.matchString(item.func_200295_i(stack).getString(), subSeg)) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean matchString(@Nullable String text, @Nullable String filter) {
        if (text == null || filter == null) {
            return true;
        }
        return text.toLowerCase().contains(filter.toLowerCase());
    }
}

