/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.requestinghalo.crafting;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL43;
import shblock.interactivecorporea.client.jei.DummyTransferringGui;
import shblock.interactivecorporea.client.render.ModRenderTypes;
import shblock.interactivecorporea.client.render.RenderUtil;
import shblock.interactivecorporea.client.render.shader.SimpleShaderProgram;
import shblock.interactivecorporea.client.requestinghalo.HaloPickedItem;
import shblock.interactivecorporea.client.requestinghalo.crafting.CraftingInterfaceSlot;
import shblock.interactivecorporea.common.network.CPacketChangeStackInHaloCraftingSlot;
import shblock.interactivecorporea.common.network.ModPacketHandler;
import shblock.interactivecorporea.common.util.CISlotPointer;
import shblock.interactivecorporea.common.util.MathUtil;
import shblock.interactivecorporea.common.util.StackHelper;
import shblock.interactivecorporea.common.util.Vec2d;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;

public class HaloCraftingInterface {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final SimpleShaderProgram bgShader = new SimpleShaderProgram("common_120_world", "halo_crafting_bg", x$0 -> Uniforms.access$400(x$0));
    public final CISlotPointer haloItemSlot;
    public ItemStack haloStack;
    private double rotation = 0.0;
    private double targetRotation = 0.0;
    private double rotationSpd = 0.0;
    private double pos = 0.0;
    private double size = 1.0;
    private Vec2d pointingLocalPos = new Vec2d();
    private double mouseOverAnimation = 0.0;
    private double edgeFlowingTime = 0.0;
    private final CraftingInterfaceSlot[] slots = new CraftingInterfaceSlot[9];
    private ICraftingRecipe currentRecipe = null;
    private ItemStack currentOutput = ItemStack.field_190927_a;
    private NonNullList<ItemStack> currentRemainingItems = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private double craftingOutputAnimation = 0.0;
    private final Map<ItemStack, Double> fadingCraftingOutputs = new HashMap<ItemStack, Double>();

    public HaloCraftingInterface(CISlotPointer haloItemSlot, ItemStack haloStack) {
        this.haloItemSlot = haloItemSlot;
        this.haloStack = haloStack;
        ListNBT shadowNBTList = this.getOrCreateListNBTForShadow();
        for (int i = 0; i < 9; ++i) {
            this.slots[i] = new CraftingInterfaceSlot(this, i, ItemStack.func_199557_a((CompoundNBT)shadowNBTList.func_150305_b(i)));
        }
    }

    public void render(MatrixStack ms, double openCloseAnimation) {
        this.rotation += this.rotationSpd * (double)ClientTickHandler.delta;
        this.mouseOverAnimation = this.isPointingAtInterface() ? (this.mouseOverAnimation += (double)(ClientTickHandler.delta / 10.0f)) : (this.mouseOverAnimation -= (double)(ClientTickHandler.delta / 10.0f));
        this.mouseOverAnimation = MathHelper.func_151237_a((double)this.mouseOverAnimation, (double)0.0, (double)1.0);
        if (!this.currentOutput.func_190926_b()) {
            this.craftingOutputAnimation += (double)(ClientTickHandler.delta / 8.0f);
            if (this.craftingOutputAnimation > 1.0) {
                this.craftingOutputAnimation = 1.0;
            }
        } else {
            this.craftingOutputAnimation = 0.0;
        }
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-this.rotation)));
        ms.func_227861_a_(0.0, 0.0, this.pos);
        float scale = (float)(this.size * openCloseAnimation);
        ms.func_227862_a_(scale, scale, scale);
        bgShader.use();
        GL43.glUniform1f((int)Uniforms.TIME, (float)(ClientTickHandler.total / 20.0f));
        double mouseOverFactor = (1.0 - Math.cos(this.mouseOverAnimation * Math.PI)) / 2.0;
        GL43.glUniform1f((int)Uniforms.MOUSE_OVER_ANIMATION, (float)((float)this.mouseOverAnimation));
        this.edgeFlowingTime += (double)ClientTickHandler.delta * (this.mouseOverAnimation * 1.5 + 0.5);
        GL43.glUniform1f((int)Uniforms.EDGE_FLOWING_TIME, (float)((float)this.edgeFlowingTime));
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffers.getBuffer(ModRenderTypes.craftingBg);
        Matrix4f matrix = ms.func_227866_c_().func_227870_a_();
        float r = 0.0f;
        float g = 0.5f;
        float b = 1.0f;
        float a = 0.6f;
        float s = (float)(1.0 + mouseOverFactor * 0.3);
        GL43.glUniform1f((int)Uniforms.BG_SIZE, (float)s);
        builder.func_227888_a_(matrix, s, 0.0f, s).func_227885_a_(r, g, b, a).func_225583_a_(s, s).func_181675_d();
        builder.func_227888_a_(matrix, s, 0.0f, -s).func_227885_a_(r, g, b, a).func_225583_a_(s, -s).func_181675_d();
        builder.func_227888_a_(matrix, -s, 0.0f, -s).func_227885_a_(r, g, b, a).func_225583_a_(-s, -s).func_181675_d();
        builder.func_227888_a_(matrix, -s, 0.0f, s).func_227885_a_(r, g, b, a).func_225583_a_(-s, s).func_181675_d();
        buffers.func_228462_a_(ModRenderTypes.craftingBg);
        bgShader.release();
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.01, 0.0);
        for (CraftingInterfaceSlot slot : this.slots) {
            slot.render(ms, this.pointingLocalPos);
        }
        ms.func_227865_b_();
        if (!this.currentOutput.func_190926_b()) {
            this.renderOutputItem(ms, this.currentOutput, this.craftingOutputAnimation, 1.0);
        }
        this.fadingCraftingOutputs.replaceAll((tmpS, t) -> t - (double)(ClientTickHandler.delta / 8.0f));
        ArrayList<ItemStack> toRemoveList = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Double> entry : this.fadingCraftingOutputs.entrySet()) {
            double progress = entry.getValue();
            if (progress < 0.0) {
                toRemoveList.add(entry.getKey());
                continue;
            }
            this.renderOutputItem(ms, entry.getKey(), 1.0, progress);
        }
        toRemoveList.forEach(this.fadingCraftingOutputs::remove);
        ms.func_227865_b_();
    }

    private void renderOutputItem(MatrixStack ms, ItemStack stack, double normalizedScale, double alpha) {
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        RenderUtil.applyStippling(16, () -> {
            RenderSystem.pushLightingAttributes();
            ms.func_227860_a_();
            float scale = (float)(3.0 * (1.0 - Math.cos(normalizedScale * Math.PI)) / 2.0);
            ms.func_227862_a_(scale, scale, scale);
            ms.func_227861_a_(0.0, 0.2, 0.0);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(ClientTickHandler.total / 15.0f));
            ItemRenderer itemRenderer = mc.func_175599_af();
            IBakedModel model = itemRenderer.func_184393_a(stack, (World)HaloCraftingInterface.mc.field_71441_e, null);
            RenderHelper.func_227783_c_();
            RenderUtil.applyStippling(alpha * (Math.sin(ClientTickHandler.total / 5.0f) * 0.2 + 0.75), () -> {
                itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GROUND, false, ms, (IRenderTypeBuffer)buffers, 0xF000F0, OverlayTexture.field_229196_a_, model);
                mc.func_228019_au_().func_228487_b_().func_228461_a_();
            });
            ms.func_227865_b_();
            RenderSystem.popAttributes();
        });
    }

    public void tick(@Nullable Vec2d worldPos2d) {
        this.rotationSpd = MathUtil.smoothMovingSpeed(this.rotation, this.targetRotation, this.rotationSpd, 0.1, 0.8, 0.01);
        if (worldPos2d != null) {
            this.pointingLocalPos = this.toLocalPos(worldPos2d);
        }
    }

    public boolean tryOpenJei() {
        if (this.isPointingAtInterface()) {
            mc.func_147108_a((Screen)new DummyTransferringGui());
            return true;
        }
        return false;
    }

    private ListNBT getOrCreateListNBTForShadow() {
        ListNBT list = ItemNBTHelper.getList((ItemStack)this.haloStack, (String)"crafting_slot_shadow_items", (int)10, (boolean)false);
        for (int i = list.size(); i < 9; ++i) {
            list.add((Object)new CompoundNBT());
        }
        return list;
    }

    private void saveShadowItemToNBT(int slot, ItemStack shadow) {
        ListNBT list = this.getOrCreateListNBTForShadow();
        list.set(slot, (INBT)shadow.func_77955_b(new CompoundNBT()));
    }

    public boolean tryPlaceShadowItem(int slot, ItemStack stack) {
        if (this.slots[slot].setShadowStack(stack)) {
            this.saveShadowItemToNBT(slot, stack);
            return true;
        }
        return false;
    }

    public boolean handleSlotInteraction(boolean isPut, @Nullable Vector3 clickWorldPos, @Nullable HaloPickedItem pickedItem) {
        if (HaloCraftingInterface.mc.field_71439_g == null || HaloCraftingInterface.mc.field_71441_e == null) {
            return false;
        }
        if (clickWorldPos == null) {
            return false;
        }
        CraftingInterfaceSlot slot = this.getPointingSlot();
        if (slot == null) {
            return false;
        }
        ItemStack newStack = HaloCraftingInterface.mc.field_71439_g.func_184614_ca();
        ItemStack shadowStack = slot.getShadowStack();
        ItemStack realStack = slot.getRealStack();
        if (isPut) {
            if (newStack.func_190926_b()) {
                if (pickedItem == null) {
                    return false;
                }
                ItemStack pickedStack = pickedItem.getStack();
                if (this.tryPlaceShadowItem(slot.getSlotIndex(), pickedStack)) {
                    this.updateRecipe();
                    return true;
                }
            }
            if (realStack.func_190926_b() && (StackHelper.equalItemAndTag(newStack, shadowStack) || this.tryPlaceShadowItem(slot.getSlotIndex(), newStack))) {
                this.updateRecipe();
                ModPacketHandler.sendToServer(new CPacketChangeStackInHaloCraftingSlot(this.haloItemSlot, slot.getSlotIndex(), true, clickWorldPos));
                return true;
            }
            if (realStack.func_190916_E() < realStack.func_77976_d() && StackHelper.equalItemAndTag(newStack, realStack)) {
                ModPacketHandler.sendToServer(new CPacketChangeStackInHaloCraftingSlot(this.haloItemSlot, slot.getSlotIndex(), true, clickWorldPos));
                return true;
            }
            if (this.tryPlaceShadowItem(slot.getSlotIndex(), newStack)) {
                this.updateRecipe();
                ModPacketHandler.sendToServer(new CPacketChangeStackInHaloCraftingSlot(this.haloItemSlot, slot.getSlotIndex(), true, clickWorldPos));
                return true;
            }
        } else {
            if (!realStack.func_190926_b()) {
                ModPacketHandler.sendToServer(new CPacketChangeStackInHaloCraftingSlot(this.haloItemSlot, slot.getSlotIndex(), false, clickWorldPos));
                return true;
            }
            if (!shadowStack.func_190926_b() && this.tryPlaceShadowItem(slot.getSlotIndex(), ItemStack.field_190927_a)) {
                this.updateRecipe();
                return true;
            }
        }
        return false;
    }

    public void updateRecipe() {
        if (HaloCraftingInterface.mc.field_71441_e == null || HaloCraftingInterface.mc.field_71439_g == null) {
            return;
        }
        RecipeManager manager = HaloCraftingInterface.mc.field_71441_e.func_199532_z();
        CraftingInventory craftingInv = new CraftingInventory(new Container(ContainerType.field_221518_l, -1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.slots[i].getShadowStack();
            if (stack.func_190926_b()) continue;
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            craftingInv.func_70299_a(i, stack);
        }
        Optional recipe = manager.func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInv, (World)HaloCraftingInterface.mc.field_71441_e);
        this.currentRecipe = recipe.orElse(null);
        ItemStack oldOutput = this.currentOutput.func_77946_l();
        if (this.currentRecipe != null) {
            this.currentOutput = this.currentRecipe.func_77572_b((IInventory)craftingInv);
            this.currentRemainingItems = this.currentRecipe.func_179532_b((IInventory)craftingInv);
        } else {
            this.currentOutput = ItemStack.field_190927_a;
            this.currentRemainingItems = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        }
        if (!oldOutput.func_190926_b() && !ItemStack.func_77989_b((ItemStack)oldOutput, (ItemStack)this.currentOutput)) {
            this.fadingCraftingOutputs.put(oldOutput, 1.0);
            this.craftingOutputAnimation = 0.0;
        }
    }

    public boolean doCraft() {
        return this.currentRecipe != null;
    }

    @Nullable
    public ICraftingRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public ItemStack getCurrentOutput() {
        return this.currentOutput;
    }

    public ItemStack getRemainingItem(int slot) {
        if (this.currentRemainingItems == null) {
            return null;
        }
        return (ItemStack)this.currentRemainingItems.get(slot);
    }

    public boolean isPointingAtInterface() {
        return Math.abs(this.pointingLocalPos.x) < 1.0 && Math.abs(this.pointingLocalPos.y) < 1.0;
    }

    @Nullable
    public CraftingInterfaceSlot getPointingSlot() {
        for (CraftingInterfaceSlot slot : this.slots) {
            if (!slot.isPointIn(this.pointingLocalPos)) continue;
            return slot;
        }
        return null;
    }

    public void setTargetRotation(double rotation) {
        this.targetRotation = rotation;
    }

    public void setPos(double pos) {
        this.pos = pos;
    }

    public void setSize(double size) {
        this.size = size;
    }

    private Vec2d toLocalPos(Vec2d worldPos2d) {
        Vector3 yAxis = new Vector3(new Vector3d(0.0, 0.0, 1.0).func_178785_b((float)(-this.rotation - Math.PI)));
        Vector3 xAxis = yAxis.yCrossProduct();
        Vector3 worldPos = worldPos2d.toVector3();
        double xDist = MathUtil.pointToOrgLineDistance(yAxis, worldPos);
        double yDist = MathUtil.pointToOrgLineDistance(xAxis, worldPos);
        return new Vec2d(xDist * Math.signum(worldPos.dotProduct(xAxis)) / this.size, (yDist * -Math.signum(worldPos.dotProduct(yAxis)) - (this.pos - this.size)) / this.size - 1.0);
    }

    private static class Uniforms {
        private static int TIME;
        private static int MOUSE_OVER_ANIMATION;
        private static int BG_SIZE;
        private static int EDGE_FLOWING_TIME;

        private Uniforms() {
        }

        private static void init(SimpleShaderProgram shader) {
            TIME = shader.getUniformLocation("time");
            MOUSE_OVER_ANIMATION = shader.getUniformLocation("mouseOverAnimation");
            BG_SIZE = shader.getUniformLocation("bgSize");
            EDGE_FLOWING_TIME = shader.getUniformLocation("edgeFlowingTime");
        }
    }
}

