/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.requestinghalo.crafting;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import shblock.interactivecorporea.client.render.ModRenderTypes;
import shblock.interactivecorporea.client.render.RenderUtil;
import shblock.interactivecorporea.client.requestinghalo.crafting.HaloCraftingInterface;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;
import shblock.interactivecorporea.common.util.Vec2d;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class CraftingInterfaceSlot {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final HaloCraftingInterface craftingInterface;
    private final int slot;
    private final Vec2d localPos;
    private static final double SPACING = 0.6;
    private static final double SIZE = 0.25;
    private double mouseOverAnimation = 0.0;
    private ItemStack shadowStack = ItemStack.field_190927_a;
    private ItemStack oldShadowStack = ItemStack.field_190927_a;
    private double changeShadowStackAnimation = 0.0;

    public CraftingInterfaceSlot(HaloCraftingInterface craftingInterface, int slot) {
        this.craftingInterface = craftingInterface;
        this.slot = slot;
        int x = -(slot % 3 - 1);
        int y = -(slot / 3 - 1);
        this.localPos = new Vec2d((double)x * 0.6, (double)y * 0.6);
    }

    public CraftingInterfaceSlot(HaloCraftingInterface craftingInterface, int slot, ItemStack initialShadowStack) {
        this(craftingInterface, slot);
        this.shadowStack = initialShadowStack;
    }

    public void render(MatrixStack ms, Vec2d pointingLocalPos) {
        boolean shouldRenderOldStack = true;
        this.changeShadowStackAnimation += (double)(ClientTickHandler.delta / 5.0f);
        if (this.changeShadowStackAnimation > 1.0) {
            this.changeShadowStackAnimation = 1.0;
            shouldRenderOldStack = false;
        }
        if (this.isPointIn(pointingLocalPos)) {
            this.mouseOverAnimation = 1.0;
        } else {
            this.mouseOverAnimation -= (double)(ClientTickHandler.delta / 3.0f);
            if (this.mouseOverAnimation < 0.0) {
                this.mouseOverAnimation = 0.0;
            }
        }
        ms.func_227860_a_();
        ms.func_227861_a_(this.localPos.x, 0.0, this.localPos.y);
        double mouseOverFactor = (1.0 - Math.cos(this.mouseOverAnimation * Math.PI)) / 2.0;
        float size = (float)(mouseOverFactor * 0.05 + 0.25);
        ms.func_227862_a_(size, size, size);
        float r = 0.97f;
        float g = 0.0f;
        float b = 0.98f;
        float a = (float)(mouseOverFactor * 0.3 + 0.6);
        this.renderBg(ms, r, g, b, a);
        ms.func_227861_a_(0.0, 0.01, 0.0);
        float sineFactor = (float)((1.0 - Math.cos(this.changeShadowStackAnimation * Math.PI)) / 2.0);
        float newSize = 0.0f;
        float oldSize = 0.0f;
        if (!this.shadowStack.func_190926_b() && !this.oldShadowStack.func_190926_b()) {
            newSize = Math.max(0.0f, sineFactor - 0.5f) * 2.0f;
            oldSize = Math.max(0.0f, 1.0f - sineFactor - 0.5f) * 2.0f;
        } else if (!this.shadowStack.func_190926_b()) {
            newSize = sineFactor;
            oldSize = 0.0f;
        } else if (!this.oldShadowStack.func_190926_b()) {
            newSize = 0.0f;
            oldSize = 1.0f - sineFactor;
        }
        newSize *= 2.0f;
        oldSize *= 2.0f;
        if (!this.shadowStack.func_190926_b()) {
            ms.func_227860_a_();
            ms.func_227862_a_(newSize, 1.0f, newSize);
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            RenderUtil.applyStippling(11, () -> RenderUtil.renderFlatItem(ms, this.shadowStack));
            ms.func_227865_b_();
        }
        if (!this.oldShadowStack.func_190926_b() && shouldRenderOldStack) {
            ms.func_227860_a_();
            ms.func_227862_a_(oldSize, 1.0f, oldSize);
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            RenderUtil.applyStippling(11, () -> RenderUtil.renderFlatItem(ms, this.oldShadowStack));
            ms.func_227865_b_();
        }
        this.renderRealItem(ms);
        ms.func_227865_b_();
    }

    private void renderBg(MatrixStack ms, float r, float g, float b, float a) {
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffers.getBuffer(ModRenderTypes.craftingSlotBg);
        Matrix4f matrix = ms.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(matrix, 1.0f, 0.0f, 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, 1.0f, 0.0f, -1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, -1.0f, 0.0f, -1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, -1.0f, 0.0f, 1.0f).func_227885_a_(r, g, b, a).func_181675_d();
        buffers.func_228462_a_(ModRenderTypes.craftingSlotBg);
    }

    private void renderRealItem(MatrixStack ms) {
        ItemStack stack = ItemRequestingHalo.getStackInCraftingSlot(this.craftingInterface.haloStack, this.slot);
        if (stack.func_190926_b()) {
            return;
        }
        ms.func_227860_a_();
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        ms.func_227862_a_(5.0f, 5.0f, 5.0f);
        ms.func_227861_a_(0.0, 0.1, 0.0);
        mc.func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, 0xF000F0, OverlayTexture.field_229196_a_, ms, (IRenderTypeBuffer)buffers);
        buffers.func_228461_a_();
        ms.func_227865_b_();
    }

    public boolean setShadowStack(ItemStack newStack) {
        if (this.changeShadowStackAnimation < 0.99) {
            return false;
        }
        if (newStack.func_190926_b() && this.shadowStack.func_190926_b()) {
            return false;
        }
        if (!newStack.func_190926_b() && !this.shadowStack.func_190926_b() && ItemStack.func_77989_b((ItemStack)newStack, (ItemStack)this.shadowStack)) {
            return false;
        }
        this.oldShadowStack = this.shadowStack;
        this.shadowStack = newStack.func_77946_l();
        this.changeShadowStackAnimation = 0.0;
        return true;
    }

    public boolean isPointIn(Vec2d localPoint) {
        Vec2d diff = localPoint.copy().sub(this.localPos);
        return Math.abs(diff.x) < 0.25 && Math.abs(diff.y) < 0.25;
    }

    public ItemStack getShadowStack() {
        return this.shadowStack;
    }

    public int getSlotIndex() {
        return this.slot;
    }

    public ItemStack getRealStack() {
        return ItemRequestingHalo.getStackInCraftingSlot(this.craftingInterface.haloStack, this.slot);
    }
}

