/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.requestinghalo;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import shblock.interactivecorporea.ModConfig;
import shblock.interactivecorporea.ModSounds;
import shblock.interactivecorporea.client.render.RenderUtil;
import shblock.interactivecorporea.client.requestinghalo.AnimatedCorporeaItemList;
import shblock.interactivecorporea.client.requestinghalo.AnimatedItemSelectionBox;
import shblock.interactivecorporea.client.requestinghalo.AnimatedItemStack;
import shblock.interactivecorporea.client.requestinghalo.HaloPickedItem;
import shblock.interactivecorporea.client.requestinghalo.HaloSearchBar;
import shblock.interactivecorporea.client.requestinghalo.RequestingHaloInterfaceHandler;
import shblock.interactivecorporea.client.requestinghalo.SortMode;
import shblock.interactivecorporea.client.requestinghalo.crafting.CraftingInterfaceSlot;
import shblock.interactivecorporea.client.requestinghalo.crafting.HaloCraftingInterface;
import shblock.interactivecorporea.client.util.KeyboardHelper;
import shblock.interactivecorporea.common.item.HaloModule;
import shblock.interactivecorporea.common.item.ItemRequestingHalo;
import shblock.interactivecorporea.common.network.CPacketRequestItem;
import shblock.interactivecorporea.common.network.CPacketRequestItemListUpdate;
import shblock.interactivecorporea.common.network.ModPacketHandler;
import shblock.interactivecorporea.common.util.CISlotPointer;
import shblock.interactivecorporea.common.util.MathUtil;
import shblock.interactivecorporea.common.util.Ray3;
import shblock.interactivecorporea.common.util.Vec2d;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;

public class RequestingHaloInterface {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final IRenderTypeBuffer.Impl TEXT_BUFFERS = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(64));
    public static final KeyBinding KEY_SEARCH = new KeyBinding("key.interactive_corporea.requesting_halo.search", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM.func_197944_a(258), "key.interactive_corporea.category");
    public static final KeyBinding KEY_REQUEST_UPDATE = new KeyBinding("key.interactive_corporea.requesting_halo.request_update", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM.func_197944_a(85), "key.interactive_corporea.category");
    private final CISlotPointer slot;
    private ItemStack haloItem;
    private boolean opening = true;
    private boolean closing = false;
    private double openCloseProgress = 0.0;
    private boolean isNormalClose = false;
    private int tick = 0;
    private static final double INITIAL_ROTATION = 36.0;
    private double rotationOffset;
    private double relativeRotation = 36.0;
    private double lastRelativeRotation = 36.0;
    private double radius = 2.0;
    private double height = 1.0;
    private final HaloSearchBar searchBar = new HaloSearchBar();
    private final HaloCraftingInterface craftingInterface;
    private final AnimatedCorporeaItemList itemList;
    private final AnimatedItemSelectionBox selectionBox = new AnimatedItemSelectionBox(() -> this.playSound(ModSounds.haloSelect, 0.25f, 1.0f));
    private HaloPickedItem pickedItem = null;
    private boolean shouldPickedItemFadeWhenLookUp = false;
    private final List<HaloPickedItem> fadingPickedItems = new ArrayList<HaloPickedItem>();
    private double itemSpacing;
    private double itemRotSpacing;
    private double itemZOffset;
    private Vector3 bottomIntersect = new Vector3(0.0, 0.0, 0.0);
    private static final String PREFIX_LIST_HEIGHT = "settings_item_list_height";
    private static final String PREFIX_SEARCH_STRING = "settings_search_string";
    private double prevPlayerRot;
    private double rotationToAdd;
    private double rotationAddingSpeed;
    private boolean lastLimitRotation;
    private float particleSpawnTimer;
    private static final Int2IntFunction craftingSlotKeyMap = key -> {
        switch (key) {
            case 327: {
                return 0;
            }
            case 328: {
                return 1;
            }
            case 329: {
                return 2;
            }
            case 324: {
                return 3;
            }
            case 325: {
                return 4;
            }
            case 326: {
                return 5;
            }
            case 321: {
                return 6;
            }
            case 322: {
                return 7;
            }
            case 323: {
                return 8;
            }
        }
        return -1;
    };
    private int lastRequestTick;

    public RequestingHaloInterface(CISlotPointer slot) {
        this.prevPlayerRot = RequestingHaloInterface.mc.field_71439_g.field_70177_z;
        this.rotationToAdd = 0.0;
        this.rotationAddingSpeed = 0.0;
        this.lastLimitRotation = false;
        this.particleSpawnTimer = 0.0f;
        this.lastRequestTick = 0;
        this.slot = slot;
        this.haloItem = slot.getStack((PlayerEntity)RequestingHaloInterface.mc.field_71439_g);
        this.rotationOffset = (double)RequestingHaloInterface.mc.field_71439_g.field_70177_z - 36.0;
        this.searchBar.setUpdateCallback(this::updateSearch);
        this.itemList = new AnimatedCorporeaItemList(ItemNBTHelper.getInt((ItemStack)this.haloItem, (String)PREFIX_LIST_HEIGHT, (int)5));
        this.searchBar.setSearchString(ItemNBTHelper.getString((ItemStack)this.haloItem, (String)PREFIX_SEARCH_STRING, (String)""));
        this.searchBar.moveToEnd();
        if (this.isModuleInstalled(HaloModule.AMOUNT_SORT)) {
            this.itemList.setSortMode(SortMode.AMOUNT);
        }
        this.craftingInterface = new HaloCraftingInterface(slot, this.haloItem);
        this.craftingInterface.setTargetRotation(Math.toRadians(36.0));
    }

    public CISlotPointer getSlot() {
        return this.slot;
    }

    public ItemStack getHaloItem() {
        return this.haloItem;
    }

    public void updateHaloItem(ItemStack haloItem) {
        this.haloItem = haloItem;
        this.craftingInterface.haloStack = haloItem;
    }

    public boolean isModuleInstalled(HaloModule module) {
        return ItemRequestingHalo.isModuleInstalled(this.haloItem, module);
    }

    public boolean render(MatrixStack ms, double pt) {
        if (!this.updateOpenClose()) {
            this.close();
            return false;
        }
        this.handleRotation();
        ActiveRenderInfo info = RequestingHaloInterface.mc.func_175598_ae().field_217783_c;
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        double renderPosX = info.func_216785_c().func_82615_a();
        double renderPosY = info.func_216785_c().func_82617_b();
        double renderPosZ = info.func_216785_c().func_82616_c();
        ms.func_227860_a_();
        ClientPlayerEntity player = RequestingHaloInterface.mc.field_71439_g;
        Vector3d eyePos = player.func_174824_e((float)pt);
        ms.func_227861_a_(eyePos.field_72450_a - renderPosX, eyePos.field_72448_b - renderPosY, eyePos.field_72449_c - renderPosZ);
        ms.func_227860_a_();
        ms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, (float)(-this.rotationOffset - this.relativeRotation), true));
        double progress = Math.sin(1.5707963267948966 * this.openCloseProgress);
        double fadeWidth = 0.3;
        double width = progress * 0.7853981633974483;
        RenderUtil.renderPartialHalo(ms, this.radius, width - fadeWidth, this.height * progress + 0.05, fadeWidth, 0.0f, 0.7f, 1.0f, (float)(progress * (double)0.6f));
        ms.func_227865_b_();
        double fadeDegrees = Math.toDegrees(fadeWidth);
        double widthDegrees = Math.toDegrees(width);
        this.itemList.update(ClientTickHandler.delta);
        ms.func_227860_a_();
        ms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, (float)(-this.rotationOffset), true));
        double scale = 1.0 / (double)this.itemList.getHeight() * this.height * 2.0;
        this.itemSpacing = 1.0 / (double)this.itemList.getHeight() * 2.0 * this.height;
        this.itemRotSpacing = MathUtil.calcRadiansFromChord(this.radius, this.itemSpacing);
        this.itemZOffset = MathUtil.calcChordCenterDistance(this.radius, this.itemSpacing);
        Vec2d lookingPos = this.calcLookingPos(this.radius, this.itemSpacing, this.itemRotSpacing);
        boolean haveSelectedItem = false;
        for (AnimatedItemStack aniStack : this.itemList.getAnimatedList()) {
            if (this.updateSelectionBox(aniStack, lookingPos)) {
                haveSelectedItem = true;
            }
            Vec2d pos = aniStack.getPos();
            float rot = (float)(pos.x * this.itemRotSpacing);
            double degreeDiff = Math.abs(this.relativeRotation - Math.toDegrees(rot));
            if (degreeDiff >= widthDegrees) continue;
            float currentScale = (float)(scale * Math.sin(MathHelper.func_151237_a((double)(widthDegrees - degreeDiff), (double)0.0, (double)fadeDegrees) / fadeDegrees * Math.PI * 0.5));
            ms.func_227860_a_();
            ms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, -rot, false));
            ms.func_227861_a_(0.0, -(pos.y - ((double)this.itemList.getHeight() - 1.0) / 2.0) * this.itemSpacing, this.itemZOffset);
            ms.func_227862_a_(currentScale, currentScale, currentScale);
            double pp = (double)ClientTickHandler.total * 0.025;
            double mp = (double)(1.0f / currentScale) * 0.0375;
            ms.func_227861_a_(aniStack.noise.perlin(pp, 0.0, 0.0) * mp, aniStack.noise.perlin(0.0, pp, 0.0) * mp, 0.0);
            aniStack.renderItem(ms);
            ms.func_227860_a_();
            float ts = 0.041666668f;
            ms.func_227862_a_(ts, ts, ts);
            ms.func_227861_a_(-this.itemSpacing - 10.0, -this.itemSpacing - 4.0, -0.02);
            aniStack.renderAmount(ms, -1, TEXT_BUFFERS);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ts = 0.055555556f;
            ms.func_227862_a_(ts, ts, ts);
            ms.func_227861_a_(0.0, 0.0, -0.05);
            aniStack.renderRequestResultAnimations(ms, buffers);
            ms.func_227865_b_();
            ms.func_227865_b_();
        }
        if (!haveSelectedItem || this.closing) {
            this.selectionBox.setTarget(null);
        }
        ms.func_227865_b_();
        TEXT_BUFFERS.func_228461_a_();
        this.selectionBox.update();
        ms.func_227860_a_();
        ms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, (float)(-this.rotationOffset), true));
        Vec2d selPos = this.selectionBox.getPos();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-selPos.x * this.itemRotSpacing)));
        ms.func_227861_a_(0.0, -(selPos.y - (double)((float)(this.itemList.getHeight() - 1) / 2.0f)) * this.itemSpacing, this.itemZOffset);
        float s = (float)scale;
        ms.func_227862_a_(s, s, s);
        this.selectionBox.render(ms);
        ms.func_227865_b_();
        if (this.isModuleInstalled(HaloModule.SEARCH)) {
            this.renderSearchBar(ms, pt);
        }
        this.renderPickedItem(ms);
        if (this.isModuleInstalled(HaloModule.CRAFTING)) {
            this.renderCrafting(ms, pt);
        }
        ms.func_227865_b_();
        return true;
    }

    public void renderSearchBar(MatrixStack ms, double pt) {
        ms.func_227860_a_();
        ms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, (float)(-this.rotationOffset - this.relativeRotation), true));
        ms.func_227861_a_(0.0, 0.0, this.radius);
        ms.func_227862_a_((float)Math.sin(this.openCloseProgress * Math.PI * 0.5), 1.0f, (float)Math.max(Math.sin((this.openCloseProgress - 0.5) * Math.PI), 0.01));
        ms.func_227861_a_(0.0, 0.0, -this.radius);
        this.searchBar.render(ms, this.radius, this.height);
        ms.func_227865_b_();
    }

    public void renderCrafting(MatrixStack ms, double pt) {
        double size = 0.5;
        this.craftingInterface.setSize(size);
        this.craftingInterface.setPos(MathUtil.calcChordCenterDistance(this.radius, size * 2.0) - size - 0.1);
        double lockingRotation = 90.0;
        double relPlus = this.relativeRotation - 36.0;
        double lastRelPlus = this.lastRelativeRotation - 36.0;
        if (Math.floor(relPlus / lockingRotation) != Math.floor(lastRelPlus / lockingRotation)) {
            double relRot = Math.max(relPlus, lastRelPlus);
            double rotDegrees = Math.floor(relRot / lockingRotation) * lockingRotation + 36.0;
            this.craftingInterface.setTargetRotation(Math.toRadians(rotDegrees));
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, -this.height, 0.0);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-this.rotationOffset)));
        this.craftingInterface.render(ms, Math.sin(this.openCloseProgress * Math.PI / 2.0));
        ms.func_227865_b_();
    }

    public void renderPickedItem(MatrixStack ms) {
        if (this.pickedItem != null && this.pickedItem.render(ms)) {
            this.pickedItem = null;
        }
        for (int i = this.fadingPickedItems.size() - 1; i >= 0; --i) {
            if (!this.fadingPickedItems.get(i).render(ms)) continue;
            this.fadingPickedItems.remove(i);
        }
    }

    public void renderHud(MatrixStack ms, float pt, MainWindow window) {
        if (this.isModuleInstalled(HaloModule.HUD)) {
            ms.func_227860_a_();
            AnimatedItemStack aniStack = this.selectionBox.getTarget();
            if (aniStack != null) {
                aniStack.renderHud(ms, pt, window);
            }
            ms.func_227865_b_();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block8: {
            this.drainManaOrClose((Integer)ModConfig.COMMON.requestingHaloStaticConsumption.get());
            this.itemList.tick();
            if (this.tick == 0) {
                this.requestItemListUpdate();
            } else if (this.tick % 20 == 0 && this.isModuleInstalled(HaloModule.UPDATE)) {
                this.requestItemListUpdate();
            }
            lookDir = new Vector3(Vector3d.func_189986_a((float)RequestingHaloInterface.mc.field_71439_g.field_70125_A, (float)RequestingHaloInterface.mc.field_71439_g.field_70177_z));
            this.bottomIntersect = MathUtil.rayPlaneIntersection(new Ray3(new Vector3(0.0, 0.0, 0.0), lookDir), new Ray3(new Vector3(0.0, -this.height, 0.0), new Vector3(0.0, 1.0, 0.0)));
            if (this.pickedItem == null) break block8;
            if (this.bottomIntersect != null) {
                v0 = new Vector3(this.bottomIntersect.x, 0.0, this.bottomIntersect.z);
                if (v0.mag() < this.radius * 0.94) {
                    this.shouldPickedItemFadeWhenLookUp = true;
                }
            }
            if (this.shouldPickedItemFadeWhenLookUp && Math.tan(Math.toRadians(RequestingHaloInterface.mc.field_71439_g.field_70125_A)) * this.radius < this.height - 0.05) {
                this.pickedItem.fadeOut();
                this.shouldPickedItemFadeWhenLookUp = false;
            }
            if (this.bottomIntersect == null) ** GOTO lbl-1000
            v1 = new Vector3(this.bottomIntersect.x, 0.0, this.bottomIntersect.z);
            if (v1.mag() < this.radius) {
                this.pickedItem.setTargetPosition(this.bottomIntersect.add(0.0, 0.05, 0.0));
                this.pickedItem.setTargetRotationDegrees(-90.0, -RequestingHaloInterface.mc.field_71439_g.field_70177_z + 180.0f);
            } else lbl-1000:
            // 2 sources

            {
                this.pickedItem.setTargetPosition(lookDir.multiply(this.radius * 0.8));
                this.pickedItem.setTargetRotationDegrees(-RequestingHaloInterface.mc.field_71439_g.field_70125_A, -RequestingHaloInterface.mc.field_71439_g.field_70177_z + 180.0f);
            }
            this.pickedItem.tick();
        }
        this.fadingPickedItems.forEach((Consumer<HaloPickedItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, tick(), (Lshblock/interactivecorporea/client/requestinghalo/HaloPickedItem;)V)());
        this.craftingInterface.tick(this.bottomIntersect != null ? new Vec2d(this.bottomIntersect.rotate(Math.toRadians(this.rotationOffset), new Vector3(0.0, 1.0, 0.0))) : null);
        ++this.tick;
    }

    private double getItemListDisplayWidth() {
        int itemCnt = this.itemList.getAnimatedList().size();
        int cols = itemCnt / this.itemList.getHeight();
        if (itemCnt % this.itemList.getHeight() != 0) {
            ++cols;
        }
        return (double)(cols - 1) * this.itemRotSpacing;
    }

    public void handleRotation() {
        this.lastRelativeRotation = this.relativeRotation;
        double rot = RequestingHaloInterface.mc.field_71439_g.field_70177_z;
        double ra = rot - this.prevPlayerRot;
        double rb = rot - this.prevPlayerRot;
        this.relativeRotation = Math.abs(ra) < Math.abs(rb) ? (this.relativeRotation += ra) : (this.relativeRotation += rb);
        this.prevPlayerRot = rot;
        double dt = ClientTickHandler.delta;
        this.rotationAddingSpeed = MathUtil.smoothMovingSpeed(this.rotationToAdd, 0.0, this.rotationAddingSpeed, 0.3, 0.7, 0.01);
        this.rotationToAdd += this.rotationAddingSpeed * dt;
        this.rotationOffset += this.rotationAddingSpeed * dt;
        this.relativeRotation -= this.rotationAddingSpeed * dt;
        this.limitPlayerRotation();
    }

    private void limitPlayerRotation() {
        double end;
        double distToEnd;
        if (this.isOpenClose()) {
            return;
        }
        if (this.itemList.getAnimatedList().size() == 0) {
            this.lastLimitRotation = false;
            return;
        }
        if (Math.abs(Math.toRadians(RequestingHaloInterface.mc.field_71439_g.field_70125_A)) > Math.atan(this.height / this.radius)) {
            this.lastLimitRotation = false;
            return;
        }
        double excessSpacing = 3.0;
        double correctionSpd = 0.1;
        double minSpd = 0.1;
        double degreeItemRotSpacing = Math.toDegrees(this.itemRotSpacing);
        boolean limited = false;
        double start = -degreeItemRotSpacing / 2.0 - excessSpacing;
        double distToStart = this.relativeRotation - start;
        if (distToStart < 0.0) {
            RequestingHaloInterface.mc.field_71439_g.field_70177_z = (float)((double)RequestingHaloInterface.mc.field_71439_g.field_70177_z - (distToStart * correctionSpd - minSpd) * (double)ClientTickHandler.delta);
            this.spawnParticleLineOnHalo(start);
            limited = true;
        }
        if ((distToEnd = this.relativeRotation - (end = Math.toDegrees(this.getItemListDisplayWidth()) + degreeItemRotSpacing / 2.0 + excessSpacing)) > 0.0) {
            RequestingHaloInterface.mc.field_71439_g.field_70177_z = (float)((double)RequestingHaloInterface.mc.field_71439_g.field_70177_z - (distToEnd * correctionSpd + minSpd) * (double)ClientTickHandler.delta);
            this.spawnParticleLineOnHalo(end);
            limited = true;
        }
        if (!limited || !this.lastLimitRotation) {
            // empty if block
        }
        this.lastLimitRotation = limited;
    }

    private void spawnParticleLineOnHalo(double relativeRot) {
        Vector3d mid = new Vector3d(this.radius * 0.95, 0.0, 0.0);
        mid = mid.func_178785_b((float)Math.toRadians(-this.rotationOffset - 90.0 - relativeRot));
        mid = mid.func_178787_e(RequestingHaloInterface.mc.field_71439_g.func_174824_e(ClientTickHandler.partialTicks));
        this.particleSpawnTimer += ClientTickHandler.delta;
        Random random = new Random();
        int cnt = 0;
        for (int i = 0; i < (int)((double)this.particleSpawnTimer / 0.1); ++i) {
            Vector3d pos = mid.func_72441_c(0.0, (random.nextDouble() * 2.0 - 1.0) * this.height, 0.0);
            RequestingHaloInterface.mc.field_71441_e.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, 1.0f), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
            ++cnt;
        }
        this.particleSpawnTimer = (float)((double)this.particleSpawnTimer - (double)cnt * 0.1);
    }

    private Vec2d calcLookingPos(double radius, double spacing, double rotSpacing) {
        return new Vec2d(Math.toRadians(this.relativeRotation) / rotSpacing, Math.tan(Math.toRadians(RequestingHaloInterface.mc.field_71439_g.field_70125_A)) * radius / spacing + (double)((float)(this.itemList.getHeight() - 1) / 2.0f));
    }

    private boolean isLookingAtItem(Vec2d itemPos, Vec2d lookingPos) {
        return Math.abs(lookingPos.x - itemPos.x) < 0.5 && Math.abs(lookingPos.y - itemPos.y) < 0.5;
    }

    private boolean updateSelectionBox(AnimatedItemStack stack, Vec2d lookingPos) {
        if (stack.isRemoved()) {
            return false;
        }
        Vec2d itemPos = stack.getPos();
        if (this.isLookingAtItem(itemPos, lookingPos)) {
            this.selectionBox.setTarget(stack);
            return true;
        }
        return false;
    }

    private boolean updateOpenClose() {
        double animationSpeed = 10.0;
        if (this.opening) {
            this.openCloseProgress += (double)ClientTickHandler.delta / animationSpeed;
            if (this.openCloseProgress >= 1.0) {
                this.openCloseProgress = 1.0;
                this.opening = false;
            }
        } else if (this.closing) {
            this.openCloseProgress -= (double)ClientTickHandler.delta / animationSpeed;
            if (this.openCloseProgress <= 0.0) {
                this.openCloseProgress = 0.0;
                this.closing = false;
                return false;
            }
        }
        return true;
    }

    public void close() {
        if (!this.isNormalClose) {
            RequestingHaloInterfaceHandler.resetKeyboardListener();
            this.playSound(ModSounds.haloClose, 1.0f);
        }
        this.itemList.removeAll();
    }

    public void startClose() {
        if (this.closing) {
            return;
        }
        if (!this.opening) {
            RequestingHaloInterfaceHandler.resetKeyboardListener();
            this.closing = true;
            this.isNormalClose = true;
            this.playSound(ModSounds.haloClose, 1.0f);
            if (this.pickedItem != null) {
                this.pickedItem.fadeOut();
                this.fadingPickedItems.add(this.pickedItem);
                this.pickedItem = null;
            }
        }
    }

    private static void playSwingAnimation() {
        RequestingHaloInterface.mc.field_71439_g.field_110158_av = -1;
        RequestingHaloInterface.mc.field_71439_g.field_82175_bq = true;
        RequestingHaloInterface.mc.field_71439_g.field_184622_au = Hand.MAIN_HAND;
    }

    public boolean requestItem() {
        if (this.isOpenClose()) {
            return false;
        }
        if (!this.isModuleInstalled(HaloModule.RECEIVE)) {
            return false;
        }
        AnimatedItemStack aniStack = this.selectionBox.getTarget();
        if (aniStack == null || aniStack.isRemoved()) {
            return false;
        }
        ItemStack stack = aniStack.getStack();
        int requestCnt = 1;
        if (KeyboardHelper.hasShiftDown() && KeyboardHelper.hasControlDown()) {
            requestCnt = stack.func_77976_d() / 4;
        } else if (KeyboardHelper.hasControlDown()) {
            requestCnt = stack.func_77976_d() / 2;
        } else if (KeyboardHelper.hasShiftDown()) {
            requestCnt = stack.func_77976_d();
        }
        ItemStack reqStack = stack.func_77946_l();
        reqStack.func_190920_e(requestCnt);
        ClientPlayerEntity player = RequestingHaloInterface.mc.field_71439_g;
        double rot = Math.toRadians(-this.rotationOffset - this.relativeRotation);
        Vector3 normal = new Vector3(Math.sin(rot) * this.itemZOffset * 0.9, 0.0, Math.cos(rot) * this.itemZOffset * 0.9);
        Vector3 pos = normal.add(player.func_226277_ct_(), player.func_226280_cw_() - Math.tan(Math.toRadians(RequestingHaloInterface.mc.field_71439_g.field_70125_A)) * this.radius, player.func_226281_cx_());
        ModPacketHandler.sendToServer(new CPacketRequestItem(this.slot, reqStack, pos, normal, this.itemList.onRequest(aniStack)));
        RequestingHaloInterface.playSwingAnimation();
        this.selectionBox.playRequestAnimation();
        this.playSound(pos.x, pos.y, pos.z, ModSounds.haloRequest, 1.0f);
        return true;
    }

    private boolean drainManaOrClose(int amount) {
        if (this.isOpenClose()) {
            return true;
        }
        ManaItemHandler manaItemHandler = ManaItemHandler.instance();
        if (!manaItemHandler.requestManaExactForTool(this.haloItem, (PlayerEntity)RequestingHaloInterface.mc.field_71439_g, amount, true)) {
            this.startClose();
            return false;
        }
        return true;
    }

    private void updateSearch() {
        this.itemList.setFilter(this.searchBar.getSearchString());
        this.itemList.arrange();
        ItemNBTHelper.setString((ItemStack)this.haloItem, (String)PREFIX_SEARCH_STRING, (String)this.searchBar.getSearchString());
    }

    private boolean pickItem(boolean unpick) {
        if (unpick) {
            if (this.pickedItem == null) {
                return false;
            }
            this.pickedItem.fadeOut();
            this.fadingPickedItems.add(this.pickedItem);
            this.pickedItem = null;
        } else {
            HaloPickedItem newPickedItem = null;
            if (RequestingHaloInterface.mc.field_71462_r == null) {
                if (this.selectionBox.getTarget() != null) {
                    double rot = Math.toRadians(-this.rotationOffset - this.relativeRotation);
                    double pitch = Math.toRadians(RequestingHaloInterface.mc.field_71439_g.field_70125_A);
                    Vector3 pos = new Vector3(Math.sin(rot) * this.itemZOffset, -Math.tan(pitch) * this.radius, Math.cos(rot) * this.itemZOffset);
                    newPickedItem = new HaloPickedItem(this.selectionBox.getTarget().getStack(), pos, 0.0, rot + Math.PI);
                    RequestingHaloInterface.playSwingAnimation();
                } else {
                    CraftingInterfaceSlot slot = this.craftingInterface.getPointingSlot();
                    if (slot != null && !slot.getShadowStack().func_190926_b() && this.bottomIntersect != null) {
                        newPickedItem = new HaloPickedItem(slot.getShadowStack(), this.bottomIntersect.add(0.0, 0.05, 0.0), -0.7853981633974483, Math.toRadians(-RequestingHaloInterface.mc.field_71439_g.field_70177_z + 180.0f));
                    }
                }
            } else {
                ItemStack stackUnderMouse = RequestingHaloInterfaceHandler.getUnderMouseItemStack();
                if (!stackUnderMouse.func_190926_b()) {
                    newPickedItem = new HaloPickedItem(stackUnderMouse, new Vector3(0.0, 0.0, 0.0), Math.toRadians(-RequestingHaloInterface.mc.field_71439_g.field_70125_A), Math.toRadians(-RequestingHaloInterface.mc.field_71439_g.field_70177_z + 180.0f));
                }
            }
            if (newPickedItem == null) {
                return false;
            }
            if (this.pickedItem != null) {
                this.pickedItem.fadeOut();
                this.fadingPickedItems.add(this.pickedItem);
            }
            this.pickedItem = newPickedItem;
        }
        return true;
    }

    public boolean onMouseInput(int button, int action, int mods) {
        if (this.isOpenClose()) {
            return false;
        }
        Vector3 intersectWorldPos = null;
        if (this.bottomIntersect != null) {
            intersectWorldPos = this.bottomIntersect.add(new Vector3(RequestingHaloInterface.mc.field_71439_g.func_174824_e(ClientTickHandler.partialTicks)));
        }
        if (action == 1) {
            switch (button) {
                case 0: {
                    if (RequestingHaloInterface.mc.field_71462_r != null) {
                        return false;
                    }
                    if (this.requestItem()) {
                        return true;
                    }
                    if (this.craftingInterface == null || !this.craftingInterface.handleSlotInteraction(false, intersectWorldPos, this.pickedItem)) break;
                    RequestingHaloInterface.playSwingAnimation();
                    return true;
                }
                case 1: {
                    if (RequestingHaloInterface.mc.field_71462_r != null) {
                        return false;
                    }
                    if (this.craftingInterface == null || !this.craftingInterface.handleSlotInteraction(true, intersectWorldPos, this.pickedItem)) break;
                    RequestingHaloInterface.playSwingAnimation();
                    return true;
                }
                case 2: {
                    if (!this.pickItem(KeyboardHelper.hasShiftDown())) break;
                    return true;
                }
            }
        } else {
            return false;
        }
        return this.craftingInterface.isPointingAtInterface();
    }

    public boolean onMouseScroll(double delta, boolean rightDown, boolean midDown, boolean leftDown) {
        if (this.isOpenClose()) {
            return false;
        }
        if (KeyboardHelper.hasControlDown()) {
            this.itemList.changeHeight((int)(-delta));
            ItemNBTHelper.setInt((ItemStack)this.haloItem, (String)PREFIX_LIST_HEIGHT, (int)this.itemList.getHeight());
            this.itemList.arrange();
            return true;
        }
        if (KeyboardHelper.hasAltDown()) {
            this.rotationToAdd += delta * Math.toDegrees(this.itemRotSpacing);
            return true;
        }
        return false;
    }

    public void preKeyEvent(int key, int scanCode, int action, int modifiers) {
        if (this.isOpenClose()) {
            return;
        }
        if (action == 1 || action == 2) {
            if (Screen.func_231169_i_((int)key)) {
                this.searchBar.copy();
            } else if (Screen.func_231168_h_((int)key)) {
                this.searchBar.paste();
            } else if (Screen.func_231166_g_((int)key)) {
                this.searchBar.cut();
            } else if (Screen.func_231170_j_((int)key)) {
                this.searchBar.selectAll();
            }
        }
    }

    public void onKeyEvent(int key, int scanCode, int action, int modifiers) {
        ItemStack stackUnderMouse;
        int slot;
        if (this.isOpenClose()) {
            return;
        }
        if (this.isModuleInstalled(HaloModule.SEARCH) && KEY_SEARCH.func_151468_f()) {
            if (KeyboardHelper.hasShiftDown()) {
                if (this.craftingInterface != null) {
                    this.craftingInterface.tryOpenJei();
                    return;
                }
            } else {
                this.searchBar.setSearching(!this.searchBar.isSearching());
                return;
            }
        }
        if (!this.isModuleInstalled(HaloModule.UPDATE) && KEY_REQUEST_UPDATE.func_151468_f()) {
            this.requestItemListUpdate();
            return;
        }
        if (action == 1 && (slot = craftingSlotKeyMap.applyAsInt(key)) != -1 && !(stackUnderMouse = RequestingHaloInterfaceHandler.getUnderMouseItemStack()).func_190926_b()) {
            this.craftingInterface.getPointingSlot().setShadowStack(stackUnderMouse);
            return;
        }
        if (action == 1 || action == 2) {
            if (this.searchBar.isSearching()) {
                switch (key) {
                    case 259: {
                        this.searchBar.backspace();
                        break;
                    }
                    case 261: {
                        this.searchBar.delete();
                        break;
                    }
                    case 263: {
                        this.searchBar.moveSelectionPos(-1, !KeyboardHelper.hasShiftDown());
                        break;
                    }
                    case 262: {
                        this.searchBar.moveSelectionPos(1, !KeyboardHelper.hasShiftDown());
                        break;
                    }
                    case 268: {
                        this.searchBar.moveToStart();
                        break;
                    }
                    case 269: {
                        this.searchBar.moveToEnd();
                    }
                }
            }
            this.craftingInterface.doCraft();
        }
    }

    public boolean shouldCancelKeyEvent(int key, int scanCode) {
        if (this.isOpenClose()) {
            return false;
        }
        if (!this.searchBar.isSearching() && RequestingHaloInterfaceHandler.KEY_BINDING.func_197976_a(key, scanCode)) {
            return false;
        }
        if (KEY_SEARCH.func_197976_a(key, scanCode)) {
            return false;
        }
        switch (key) {
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 268: 
            case 269: 
            case 340: 
            case 344: {
                return false;
            }
        }
        return this.searchBar.isSearching();
    }

    public void onCharEvent(int codePoint, int modifiers) {
        if (this.isOpenClose()) {
            return;
        }
        this.searchBar.typeChar(codePoint, modifiers);
    }

    public void handleUpdatePacket(List<ItemStack> newList) {
        if (this.drainManaOrClose((Integer)ModConfig.COMMON.requestingHaloUpdateConsumption.get())) {
            this.itemList.handleUpdatePacket(newList);
            if (!this.isOpenClose() && !ItemRequestingHalo.isModuleInstalled(this.haloItem, HaloModule.UPDATE)) {
                this.playSound(ModSounds.haloListUpdate, 1.0f);
            }
        }
    }

    public void handleRequestResultPacket(int requestId, int successAmount) {
        this.itemList.handleRequestResultPacket(requestId, successAmount);
    }

    public void requestItemListUpdate() {
        if (this.tick - this.lastRequestTick >= 5 || this.tick == 0) {
            ModPacketHandler.sendToServer(new CPacketRequestItemListUpdate(this.slot));
            this.lastRequestTick = this.tick;
        }
    }

    public boolean isOpenClose() {
        return this.opening || this.closing;
    }

    public void playSound(double x, double y, double z, SoundEvent sound, float volume, float pitch) {
        if (RequestingHaloInterface.mc.field_71441_e != null) {
            ClientWorld world = RequestingHaloInterface.mc.field_71441_e;
            world.func_184134_a(x, y, z, sound, SoundCategory.PLAYERS, volume, pitch, false);
        }
    }

    public void playSound(double x, double y, double z, SoundEvent sound, float pitch) {
        this.playSound(x, y, z, sound, 1.0f, pitch);
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        this.playSound(RequestingHaloInterface.mc.field_71439_g.func_226277_ct_(), RequestingHaloInterface.mc.field_71439_g.func_226278_cu_(), RequestingHaloInterface.mc.field_71439_g.func_226281_cx_(), sound, volume, pitch);
    }

    public void playSound(SoundEvent sound, float pitch) {
        this.playSound(sound, 1.0f, pitch);
    }

    public HaloCraftingInterface getCraftingInterface() {
        return this.craftingInterface;
    }
}

