/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.requestinghalo;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.util.math.MathHelper;
import shblock.interactivecorporea.client.render.RenderUtil;
import shblock.interactivecorporea.common.util.MathUtil;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class HaloSearchBar {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private boolean searching;
    private String searchString = "";
    private int selectionStart;
    private int selectionEnd;
    private Runnable updateCallback;

    public void render(MatrixStack ms, double radius, double haloHeight) {
        ms.func_227860_a_();
        float textScale = 0.02f;
        HaloSearchBar.mc.field_71466_p.getClass();
        double barHeight = (double)(9.0f * textScale / 2.0f) + 0.025;
        ms.func_227861_a_(0.0, haloHeight + barHeight + 0.1, 0.0);
        float alpha = 0.6f;
        float[] color = this.searching ? MathUtil.hsvaToRGBA(ClientTickHandler.total / 400.0f % 1.0f, 1.0f, 1.0f, alpha) : new float[]{0.5f, 0.5f, 0.5f, alpha};
        float[] revCol = MathUtil.revertColor(color);
        double rot = RenderUtil.renderTextOnHaloCentered(ms, HaloSearchBar.mc.field_71466_p, this.searchString, radius - 0.01, textScale, -1, i -> {
            if (this.searching && i >= Math.min(this.selectionStart, this.selectionEnd) && i < Math.max(this.selectionStart, this.selectionEnd)) {
                return MathUtil.colorToInt(revCol[0], revCol[1], revCol[2], alpha);
            }
            return 0;
        }, i -> {
            if (this.searching && i == this.selectionEnd && (double)(ClientTickHandler.total / 20.0f % 1.0f) < 0.5) {
                return i == this.searchString.length() ? (char)'_' : (char)'|';
            }
            return '\u0000';
        });
        RenderUtil.renderPartialHalo(ms, radius, Math.max(rot / 2.0, (double)0.1f), barHeight, 0.1, color[0], color[1], color[2], color[3]);
        ms.func_227865_b_();
    }

    private void fixSelection() {
        if (this.selectionStart < 0) {
            this.selectionStart = 0;
        }
        if (this.selectionEnd < 0) {
            this.selectionEnd = 0;
        }
        if (this.selectionStart > this.searchString.length()) {
            this.selectionStart = this.searchString.length();
        }
        if (this.selectionEnd > this.searchString.length()) {
            this.selectionEnd = this.searchString.length();
        }
    }

    public void backspace() {
        if (!this.isSearching()) {
            return;
        }
        if (this.selectionEnd <= this.searchString.length() && !this.searchString.isEmpty()) {
            if (this.selectionStart == this.selectionEnd) {
                this.searchString = this.searchString.substring(0, this.selectionEnd - 1) + this.searchString.substring(this.selectionEnd);
                --this.selectionEnd;
                --this.selectionStart;
                this.fixSelection();
                this.updateSearch();
            } else if (this.deleteSelectedRegion()) {
                this.updateSearch();
            }
        }
    }

    private boolean deleteRegion(int start, int end) {
        if (start == end) {
            return false;
        }
        int a = Math.min(start, end);
        int b = Math.max(start, end);
        if (this.searchString.isEmpty()) {
            return false;
        }
        if (a >= 0 && b <= this.searchString.length()) {
            this.searchString = this.searchString.substring(0, a) + this.searchString.substring(b);
            return true;
        }
        return false;
    }

    private boolean deleteSelectedRegion() {
        boolean did = this.deleteRegion(this.selectionStart, this.selectionEnd);
        if (did) {
            this.selectionEnd = this.selectionStart = Math.min(this.selectionStart, this.selectionEnd);
            this.fixSelection();
            return true;
        }
        return false;
    }

    public void delete() {
        if (!this.isSearching()) {
            return;
        }
        if (this.selectionStart == this.selectionEnd) {
            if (this.selectionStart < this.searchString.length()) {
                this.searchString = this.searchString.substring(0, this.selectionEnd) + this.searchString.substring(this.selectionEnd + 1);
                this.updateSearch();
            }
        } else if (this.deleteSelectedRegion()) {
            this.updateSearch();
        }
    }

    private void insertString(int pos, String insert) {
        this.searchString = this.searchString.substring(0, pos) + insert + this.searchString.substring(pos);
    }

    private void insertStringToSelectionPos(String insert) {
        this.insertString(this.selectionEnd, insert);
        this.selectionEnd += insert.length();
        this.selectionStart = this.selectionEnd;
        this.fixSelection();
    }

    public void inputString(String addString) {
        if (addString.isEmpty()) {
            return;
        }
        if (!this.isSearching()) {
            return;
        }
        if (this.selectionStart != this.selectionEnd) {
            this.deleteSelectedRegion();
        }
        this.insertStringToSelectionPos(addString);
        this.updateSearch();
    }

    public void typeChar(int codePoint, int modifiers) {
        if (!this.isSearching()) {
            return;
        }
        String addString = "";
        for (char c : Character.toChars(codePoint)) {
            addString = addString + c;
        }
        this.inputString(addString);
    }

    public void moveSelectionPos(int move, boolean moveStartPos) {
        this.selectionEnd += move;
        this.selectionEnd = MathHelper.func_76125_a((int)this.selectionEnd, (int)0, (int)this.searchString.length());
        if (moveStartPos) {
            this.selectionStart = this.selectionEnd;
        }
        this.fixSelection();
    }

    public void moveToStart() {
        this.selectionEnd = this.selectionStart = 0;
    }

    public void moveToEnd() {
        this.selectionEnd = this.selectionStart = this.searchString.length();
    }

    public void selectAll() {
        this.selectionStart = 0;
        this.selectionEnd = this.searchString.length();
    }

    private void updateSearch() {
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            TextInputUtil.func_238571_a_((Minecraft)mc, (String)this.searchString.substring(Math.min(this.selectionStart, this.selectionEnd), Math.max(this.selectionStart, this.selectionEnd)));
        }
    }

    public void paste() {
        this.inputString(TextInputUtil.func_238576_b_((Minecraft)mc));
    }

    public void cut() {
        this.copy();
        this.deleteSelectedRegion();
        this.updateSearch();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String str) {
        this.searchString = str;
        this.fixSelection();
    }

    public void setSearching(boolean searching) {
        this.searching = searching;
    }

    public boolean isSearching() {
        return this.searching;
    }

    public void setUpdateCallback(Runnable callback) {
        this.updateCallback = callback;
    }
}

