/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.requestinghalo;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.gui.GuiUtils;
import shblock.interactivecorporea.client.render.RenderUtil;
import shblock.interactivecorporea.client.requestinghalo.RequestResultAnimation;
import shblock.interactivecorporea.client.util.KeyboardHelper;
import shblock.interactivecorporea.common.util.ItemRenderHelper;
import shblock.interactivecorporea.common.util.MathUtil;
import shblock.interactivecorporea.common.util.Perlin;
import shblock.interactivecorporea.common.util.TextHelper;
import shblock.interactivecorporea.common.util.Vec2d;
import shblock.interactivecorporea.common.util.Vec2i;
import vazkii.botania.client.core.handler.ClientTickHandler;

@MethodsReturnNonnullByDefault
public class AnimatedItemStack {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public Perlin noise = new Perlin();
    private final ItemStack stack;
    private boolean removed = false;
    private boolean forceRemove = false;
    private final Vec2i posi = new Vec2i();
    private final Vec2d pos = new Vec2d();
    private final Vec2d moveSpd = new Vec2d();
    private double fade;
    private double aniAmount;
    private double stackAniSpd;
    private final List<RequestResultAnimation> requestResultAnimations = new ArrayList<RequestResultAnimation>();
    private boolean isNew = true;

    public AnimatedItemStack(ItemStack stack) {
        this.stack = stack;
        this.aniAmount = stack.func_190916_E();
    }

    public boolean update(double dt) {
        if (this.forceRemove) {
            return true;
        }
        if (this.removed && this.fade <= 0.01) {
            return true;
        }
        this.pos.add(this.moveSpd.copy().mul(dt));
        if (this.removed) {
            this.fade -= (Math.sin(this.fade * Math.PI / 2.0) + 1.0) * dt * 0.1;
            if (this.fade < 0.0) {
                this.fade = 0.0;
            }
        } else {
            this.fade += (Math.sin((1.0 - this.fade) * Math.PI / 2.0) + 1.0) * dt * 0.1;
            if (this.fade > 1.0) {
                this.fade = 1.0;
            }
        }
        this.aniAmount += this.stackAniSpd * dt;
        this.isNew = false;
        return false;
    }

    public void tick() {
        this.moveSpd.set(this.calcSpeed(this.pos.x, this.posi.x, this.moveSpd.x), this.calcSpeed(this.pos.y, this.posi.y, this.moveSpd.y));
        this.stackAniSpd = Math.min(Math.abs(((double)this.stack.func_190916_E() - this.aniAmount) * 0.5) + 0.01, Math.abs(this.stackAniSpd) + Math.abs(((double)this.stack.func_190916_E() - this.aniAmount) * 0.2)) * Math.signum((double)this.stack.func_190916_E() - this.aniAmount);
    }

    private double calcSpeed(double current, double dest, double prevSpd) {
        return MathUtil.smoothMovingSpeed(current, dest, prevSpd, 0.05, 0.5, 0.01);
    }

    public void renderItem(MatrixStack ms) {
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        if (!this.removed) {
            float s = (float)this.fade;
            ms.func_227862_a_(s, s, s);
            RenderUtil.renderFlatItem(ms, this.stack);
        } else {
            RenderUtil.applyStippling(this.fade, () -> RenderUtil.renderFlatItem(ms, this.stack));
        }
        ms.func_227865_b_();
    }

    public void renderAmount(MatrixStack ms, int color, IRenderTypeBuffer.Impl buffers) {
        ms.func_227860_a_();
        float scale = (float)this.fade;
        ms.func_227862_a_(scale, scale, scale);
        int orgAlpha = color >>> 24;
        int colorNoAlpha = color & 0xFFFFFF;
        double spacing = 9.0;
        int numA = MathHelper.func_76128_c((double)this.aniAmount);
        int numB = MathHelper.func_76143_f((double)this.aniAmount);
        double distA = (double)numA - this.aniAmount;
        double distB = (double)numB - this.aniAmount;
        String textA = TextHelper.formatBigNumber(numA, true);
        String textB = TextHelper.formatBigNumber(numB, true);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, distA * spacing, 0.0);
        int colA = colorNoAlpha | (int)((double)orgAlpha * (1.0 - Math.abs(distA))) << 24;
        AnimatedItemStack.renderAmountText(ms, textA, colA, buffers);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, distB * spacing, 0.0);
        int colB = colorNoAlpha | (int)((double)orgAlpha * (1.0 - Math.abs(distB))) << 24;
        AnimatedItemStack.renderAmountText(ms, textB, colB, buffers);
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    protected static void renderAmountText(MatrixStack ms, String text, int color, IRenderTypeBuffer.Impl buffers) {
        int alpha = color >>> 24;
        color = color & 0xFFFFFF | (int)MathHelper.func_219803_d((double)((double)alpha / 255.0), (double)5.0, (double)249.0) << 24;
        ms.func_227860_a_();
        FontRenderer font = AnimatedItemStack.mc.field_71466_p;
        ms.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
        ms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
        double w = font.func_238420_b_().func_238350_a_(text);
        ms.func_227861_a_(-w, 0.0, 0.0);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        RenderSystem.enableDepthTest();
        int shadeColor = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        font.func_228079_a_(text, 1.0f, 1.0f, shadeColor, false, mat, (IRenderTypeBuffer)buffers, true, 0, 0xF000F0);
        buffers.func_228461_a_();
        font.func_228079_a_(text, 0.0f, 0.0f, color, false, mat, (IRenderTypeBuffer)buffers, true, 0, 0xF000F0);
        buffers.func_228461_a_();
        ms.func_227865_b_();
    }

    public void renderRequestResultAnimations(MatrixStack ms, IRenderTypeBuffer.Impl buffers) {
        ms.func_227860_a_();
        for (int i = this.requestResultAnimations.size() - 1; i >= 0; --i) {
            RequestResultAnimation animation = this.requestResultAnimations.get(i);
            if (!animation.render(ms, buffers)) continue;
            this.requestResultAnimations.remove(i);
        }
        ms.func_227865_b_();
    }

    public void renderHud(MatrixStack ms, float pt, MainWindow window) {
        if (AnimatedItemStack.mc.field_71439_g == null) {
            return;
        }
        if (KeyboardHelper.hasAltDown()) {
            ms.func_227860_a_();
            List tooltip = this.stack.func_82840_a((PlayerEntity)AnimatedItemStack.mc.field_71439_g, (ITooltipFlag)(AnimatedItemStack.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            GuiUtils.preItemToolTip((ItemStack)this.stack);
            FontRenderer font = this.stack.func_77973_b().getFontRenderer(this.stack);
            if (font == null) {
                font = AnimatedItemStack.mc.field_71466_p;
            }
            int width = window.func_198107_o();
            int height = window.func_198087_p();
            int bgCol = MathHelper.func_181758_c((float)(ClientTickHandler.total % 200.0f / 200.0f), (float)1.0f, (float)1.0f);
            int borderColStart = MathHelper.func_181758_c((float)((ClientTickHandler.total + 66.66f) % 200.0f / 200.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            int borderColEnd = MathHelper.func_181758_c((float)((ClientTickHandler.total + 133.33f) % 200.0f / 200.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
            GuiUtils.drawHoveringText((ItemStack)this.stack, (MatrixStack)ms, (List)tooltip, (int)(width / 2), (int)(height / 2), (int)width, (int)height, (int)100, (int)(bgCol |= 0x96000000), (int)borderColStart, (int)borderColEnd, (FontRenderer)font);
            ms.func_227865_b_();
            MatrixStack itemMS = new MatrixStack();
            itemMS.func_227862_a_(3.0f, 3.0f, 3.0f);
            ItemRenderHelper.renderItemAndEffectIntoGUI(this.stack, width / 2 - 48, height / 2 - 8, itemMS);
        }
    }

    public void handleRequestResult(int successAmount) {
        this.requestResultAnimations.add(new RequestResultAnimation(successAmount));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void fadeIn() {
        this.removed = false;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void remove() {
        this.removed = true;
        this.forceRemove = true;
    }

    public void removeWithAnimation() {
        this.remove();
        this.forceRemove = false;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setPos(int x, int y) {
        this.posi.set(x, y);
        this.pos.set(x, y);
    }

    public void moveTo(int x, int y) {
        this.posi.set(x, y);
    }

    public Vec2d getPos() {
        return this.pos;
    }

    public void changeAmount(int amount, double animationLength) {
        this.stack.func_190920_e(amount);
    }
}

