/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.requestinghalo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import shblock.interactivecorporea.client.requestinghalo.AnimatedItemStack;
import shblock.interactivecorporea.client.requestinghalo.SortMode;
import shblock.interactivecorporea.client.util.SearchHelper;
import shblock.interactivecorporea.common.util.StackHelper;

public class AnimatedCorporeaItemList {
    private static double animationLength = 10.0;
    private int height = 5;
    private String filter = "";
    private SortMode sortMode = SortMode.DICT;
    private List<ItemStack> stackList;
    private final List<AnimatedItemStack> animatedList = new ArrayList<AnimatedItemStack>();
    private final Map<Integer, AnimatedItemStack> requestIdMap = new HashMap<Integer, AnimatedItemStack>();
    private boolean isFirstUpdate = true;
    private int nextRequestId = 0;

    public AnimatedCorporeaItemList(int height) {
        this.height = height;
    }

    public void update(double dt) {
        for (int i = this.animatedList.size() - 1; i >= 0; --i) {
            if (!this.animatedList.get(i).update(dt)) continue;
            this.animatedList.remove(i);
        }
    }

    public void tick() {
        for (int i = this.animatedList.size() - 1; i >= 0; --i) {
            this.animatedList.get(i).tick();
        }
    }

    public void handleUpdatePacket(List<ItemStack> itemList) {
        this.stackList = itemList;
        this.arrange();
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    private List<ItemStack> filter(List<ItemStack> list) {
        String[] segments = this.filter.split(" ");
        return list.stream().filter((? super T stack) -> SearchHelper.matchItem(stack, segments)).collect(Collectors.toList());
    }

    private void sort() {
        this.animatedList.sort((a, b) -> {
            if (a.isRemoved() && !b.isRemoved()) {
                return 1;
            }
            if (b.isRemoved() && !a.isRemoved()) {
                return -1;
            }
            if (a.isRemoved() && b.isRemoved()) {
                return 0;
            }
            return this.sortMode.getSorter().compare(a.getStack(), b.getStack());
        });
        int y = 0;
        int x = 0;
        for (AnimatedItemStack stack : this.animatedList) {
            if (stack.isRemoved()) break;
            if (!stack.isNew()) {
                stack.moveTo(x, y);
            } else {
                stack.setPos(x, y);
            }
            if (++y < this.height) continue;
            y = 0;
            ++x;
        }
    }

    public void arrange() {
        List<ItemStack> list = this.filter(this.stackList);
        for (AnimatedItemStack aniStack : this.animatedList) {
            ItemStack oldStack = aniStack.getStack();
            boolean found = false;
            for (int i = list.size() - 1; i >= 0; --i) {
                ItemStack stack = list.get(i);
                if (!StackHelper.equalItemAndTag(oldStack, stack)) continue;
                if (aniStack.isRemoved()) {
                    aniStack.fadeIn();
                }
                if (oldStack.func_190916_E() != stack.func_190916_E()) {
                    aniStack.changeAmount(stack.func_190916_E(), animationLength);
                }
                list.remove(i);
                found = true;
                break;
            }
            if (found) continue;
            aniStack.removeWithAnimation();
        }
        for (ItemStack stack : list) {
            AnimatedItemStack aniStack = new AnimatedItemStack(stack);
            if (!this.isFirstUpdate) {
                aniStack.fadeIn();
            }
            this.animatedList.add(aniStack);
        }
        this.sort();
        this.isFirstUpdate = false;
    }

    public void removeAll() {
        for (AnimatedItemStack stack : this.animatedList) {
            stack.remove();
        }
    }

    public int onRequest(AnimatedItemStack aniStack) {
        int id = this.nextRequestId++;
        this.requestIdMap.put(id, aniStack);
        return id;
    }

    public void handleRequestResultPacket(int requestId, int successAmount) {
        AnimatedItemStack aniStack = this.requestIdMap.get(requestId);
        if (aniStack != null && !aniStack.isRemoved()) {
            aniStack.handleRequestResult(successAmount);
        }
    }

    public List<AnimatedItemStack> getAnimatedList() {
        return this.animatedList;
    }

    public void changeHeight(int delta) {
        this.height += delta;
        if (this.height < 1) {
            this.height = 1;
        }
        if (this.height > 16) {
            this.height = 16;
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSortMode(SortMode mode) {
        this.sortMode = mode;
    }
}

