/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.render.shader;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.lwjgl.opengl.GL20;

public class SimpleShaderProgram
implements ISelectiveResourceReloadListener {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final String PREFIX = "shaders/";
    private final ResourceLocation vertexLocation;
    private final ResourceLocation fragmentLocation;
    private final boolean hasVert;
    private int vert = 0;
    private int frag = 0;
    private int program = 0;
    private final Consumer<SimpleShaderProgram> reloadCallback;

    public SimpleShaderProgram(@Nullable String vertLoc, String fragLoc, @Nullable Consumer<SimpleShaderProgram> reloadCallback) {
        if (vertLoc != null) {
            this.vertexLocation = new ResourceLocation("interactive_corporea", PREFIX + vertLoc + ".vert");
            this.hasVert = true;
        } else {
            this.vertexLocation = null;
            this.hasVert = false;
        }
        this.fragmentLocation = new ResourceLocation("interactive_corporea", PREFIX + fragLoc + ".frag");
        this.reloadCallback = reloadCallback;
        IResourceManager resourceManager = mc.func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)this);
        }
        try {
            this.load(mc.func_195551_G());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SimpleShaderProgram(String fragLoc, @Nullable Consumer<SimpleShaderProgram> reloadCallback) {
        this(null, fragLoc, reloadCallback);
    }

    private void load(IResourceManager resourceManager) throws IOException {
        if (this.hasVert) {
            this.vert = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)this.vert, (CharSequence)TextureUtil.func_225687_b_((InputStream)resourceManager.func_199002_a(this.vertexLocation).func_199027_b()));
            GL20.glCompileShader((int)this.vert);
            if (GL20.glGetShaderi((int)this.vert, (int)35713) == 0) {
                String info = GL20.glGetShaderInfoLog((int)this.vert);
                this.vert = 0;
                throw new IOException("Vertex shader " + this.vertexLocation + " compile failed:\n" + info);
            }
        }
        this.frag = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)this.frag, (CharSequence)TextureUtil.func_225687_b_((InputStream)resourceManager.func_199002_a(this.fragmentLocation).func_199027_b()));
        GL20.glCompileShader((int)this.frag);
        if (GL20.glGetShaderi((int)this.frag, (int)35713) == 0) {
            String info = GL20.glGetShaderInfoLog((int)this.frag);
            this.frag = 0;
            throw new IOException("Fragment shader " + this.fragmentLocation + " compile failed:\n" + info);
        }
        this.program = GL20.glCreateProgram();
        if (this.hasVert) {
            GL20.glAttachShader((int)this.program, (int)this.vert);
        }
        GL20.glAttachShader((int)this.program, (int)this.frag);
        GL20.glLinkProgram((int)this.program);
        if (GL20.glGetProgrami((int)this.program, (int)35714) == 0) {
            String info = GL20.glGetProgramInfoLog((int)this.program);
            this.program = 0;
            throw new IOException("Shader " + this.fragmentLocation + " linking failed:\n" + info);
        }
        this.reloadCallback.accept(this);
    }

    public int getUniformLocation(String name) {
        return GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
    }

    public void use() {
        GL20.glUseProgram((int)this.program);
    }

    public void release() {
        GL20.glUseProgram((int)0);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        try {
            this.load(resourceManager);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

