/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2CharFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL43;
import shblock.interactivecorporea.client.render.ModRenderTypes;
import shblock.interactivecorporea.client.render.shader.SimpleShaderProgram;
import shblock.interactivecorporea.common.util.MathUtil;
import shblock.interactivecorporea.common.util.Perlin;
import shblock.interactivecorporea.common.util.Vec2d;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.mixin.AccessorRenderState;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    private static final RenderType STAR = RenderType.func_228633_a_((String)"interactive_corporeastar", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(true)).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228726_a_(AccessorRenderState.getLightningTransparency()).func_228728_a_(false));
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Perlin starPerlin = new Perlin();
    private static final SimpleShaderProgram stipplingShader = new SimpleShaderProgram("stippling", shader -> {
        stipplingAlphaUniformLocation = shader.getUniformLocation("alpha");
    });
    private static int stipplingAlphaUniformLocation = 0;

    public static void renderPartialHalo(MatrixStack ms, double radius, double width, double height, double fadeWidth, float r, float g, float b, float alpha) {
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        IVertexBuilder buffer = buffers.getBuffer(ModRenderTypes.halo);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        double fullWidth = width + fadeWidth;
        for (double angle = -fullWidth; angle < fullWidth; angle += Math.PI / 360) {
            float xp = (float)(Math.sin(angle) * radius);
            float zp = (float)(Math.cos(angle) * radius);
            double minDistToEdge = Math.min(Math.abs(fullWidth - angle), Math.abs(-fullWidth - angle));
            float currentAlpha = alpha;
            if (minDistToEdge < fadeWidth) {
                currentAlpha = (float)((double)currentAlpha * Math.sin(minDistToEdge / fadeWidth * 1.5707963267948966));
            }
            buffer.func_227888_a_(mat, xp, (float)(-height), zp).func_227885_a_(r, g, b, currentAlpha).func_181675_d();
            buffer.func_227888_a_(mat, xp, (float)height, zp).func_227885_a_(r, g, b, currentAlpha).func_181675_d();
        }
        buffers.func_228461_a_();
    }

    private static double calcFullTextOnHaloRadians(FontRenderer font, String text, float textScale, double radius) {
        double result = 0.0;
        CharacterManager cm = font.func_238420_b_();
        for (char c : text.toCharArray()) {
            float width = cm.func_238350_a_(String.valueOf(c)) * textScale;
            result += MathUtil.calcRadiansFromChord(radius, width);
        }
        return result;
    }

    public static double renderTextOnHaloCentered(MatrixStack ms, FontRenderer font, String text, double radius, float textScale, int color, Int2IntFunction bgColorProvider, Int2CharFunction additionalCharProvider) {
        int shadeColor = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        font.getClass();
        double yOffset = (double)((float)(-9) * textScale) / 2.0;
        ms.func_227860_a_();
        double fullRot = RenderUtil.calcFullTextOnHaloRadians(font, text, textScale, radius);
        ms.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
        ms.func_227863_a_(Vector3f.field_229180_c_.func_229193_c_((float)(fullRot / 2.0 + Math.PI)));
        double rot = 0.0;
        CharacterManager cm = font.func_238420_b_();
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        char[] chrArray = text.toCharArray();
        for (int i = 0; i < chrArray.length + 1; ++i) {
            char additionalChr;
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)rot));
            String chr = "";
            if (i != chrArray.length) {
                chr = String.valueOf(chrArray[i]);
            }
            float width = cm.func_238350_a_(chr) * textScale;
            ms.func_227861_a_(0.0, yOffset, MathUtil.calcChordCenterDistance(radius, width));
            ms.func_227862_a_(textScale, textScale, textScale);
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            if (!chr.isEmpty()) {
                font.func_228079_a_(chr, 0.0f, 0.0f, color, false, mat, (IRenderTypeBuffer)buffers, false, bgColorProvider.applyAsInt(i), 0xF000F0);
                ms.func_227861_a_(0.0, 0.0, 0.001);
                font.func_228079_a_(chr, 1.0f, 1.0f, shadeColor, false, mat, (IRenderTypeBuffer)buffers, false, 0, 0xF000F0);
            }
            if ((additionalChr = ((Character)additionalCharProvider.apply((Object)i)).charValue()) != '\u0000') {
                String additionalChrStr = String.valueOf(additionalChr);
                ms.func_227861_a_(0.0, 0.0, 0.001);
                mat = ms.func_227866_c_().func_227870_a_();
                font.func_228079_a_(additionalChrStr, 0.0f, 0.0f, color, false, mat, (IRenderTypeBuffer)buffers, false, 0, 0xF000F0);
                ms.func_227861_a_(0.0, 0.0, 0.001);
                mat = ms.func_227866_c_().func_227870_a_();
                font.func_228079_a_(additionalChrStr, 1.0f, 1.0f, shadeColor, false, mat, (IRenderTypeBuffer)buffers, false, 0, 0xF000F0);
            }
            ms.func_227865_b_();
            rot += MathUtil.calcRadiansFromChord(radius, width);
        }
        ms.func_227865_b_();
        buffers.func_228461_a_();
        return fullRot;
    }

    public static double renderTextOnHaloCentered(MatrixStack ms, FontRenderer font, String text, double radius, float textScale, int color) {
        return RenderUtil.renderTextOnHaloCentered(ms, font, text, radius, textScale, color, i -> 0, i -> '\u0000');
    }

    public static Vector3 worldPosToLocalPos(Vector3 worldPos) {
        ActiveRenderInfo info = RenderUtil.mc.field_71460_t.func_215316_n();
        return new Vector3(info.func_216785_c()).subtract(worldPos);
    }

    public static Vec2d calcNDC(Vector3 worldCoord) {
        ActiveRenderInfo info = RenderUtil.mc.field_71460_t.func_215316_n();
        Vector3 pos = RenderUtil.worldPosToLocalPos(worldCoord);
        Vector3d pos3d = new Vector3d(pos.x, pos.y, pos.z).func_178785_b((float)Math.toRadians(info.func_216778_f() + 180.0f)).func_178789_a((float)Math.toRadians(-info.func_216777_e()));
        Matrix4f matrix = RenderUtil.mc.field_71460_t.func_228382_a_(info, ClientTickHandler.partialTicks, true);
        Vector4f vec4 = new Vector4f((float)pos3d.field_72450_a, (float)pos3d.field_72448_b, (float)pos3d.field_72449_c, 1.0f);
        vec4.func_229372_a_(matrix);
        vec4.func_229375_f_();
        return new Vec2d(vec4.func_195910_a(), vec4.func_195913_b());
    }

    public static Vec2d texCoordFromNDC(Vec2d ndc) {
        return ndc.copy().add(1.0, 1.0).mul(0.5);
    }

    public static void renderPerlinStar(MatrixStack ms, IRenderTypeBuffer buffers, int color, float xScale, float yScale, float zScale, double seed) {
        IVertexBuilder buffer = buffers.getBuffer(STAR);
        float f2 = 0.15f;
        ms.func_227860_a_();
        ms.func_227862_a_(xScale, yScale, zScale);
        double noisePos = (double)ClientTickHandler.total * 0.005;
        for (int i = 0; i < 256; ++i) {
            ms.func_227860_a_();
            double z = (double)i * 12.3456789 + seed;
            ms.func_227863_a_(new Quaternion((float)(starPerlin.perlin(noisePos, 0.0, z) * Math.PI * 2.0), (float)(starPerlin.perlin(noisePos, 10.0, z) * Math.PI * 2.0), (float)(starPerlin.perlin(noisePos, 20.0, z) * Math.PI * 2.0), false));
            float f3 = (float)(starPerlin.perlin(noisePos, 30.0, z) * 20.0 + 5.0 + (double)(f2 * 10.0f));
            float f4 = (float)(starPerlin.perlin(noisePos, 40.0, z) * 2.0 + 1.0 + (double)(f2 * 2.0f));
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            Runnable center = () -> buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            Runnable[] vertices = new Runnable[]{() -> buffer.func_227888_a_(mat, -0.866f * f4, f3, -0.5f * f4).func_225586_a_(0, 0, 0, 0).func_181675_d(), () -> buffer.func_227888_a_(mat, 0.866f * f4, f3, -0.5f * f4).func_225586_a_(0, 0, 0, 0).func_181675_d(), () -> buffer.func_227888_a_(mat, 0.0f, f3, f4).func_225586_a_(0, 0, 0, 0).func_181675_d(), () -> buffer.func_227888_a_(mat, -0.866f * f4, f3, -0.5f * f4).func_225586_a_(0, 0, 0, 0).func_181675_d()};
            RenderHelper.triangleFan((Runnable)center, (Runnable[])vertices);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    public static void renderFlatItem(MatrixStack ms, ItemStack stack) {
        RenderSystem.pushLightingAttributes();
        ms.func_227860_a_();
        ms.func_227862_a_(1.0f, 1.0f, 0.001f);
        IBakedModel ibakedmodel = mc.func_175599_af().func_184393_a(stack, (World)RenderUtil.mc.field_71441_e, (LivingEntity)RenderUtil.mc.field_71439_g);
        if (ibakedmodel.func_177556_c()) {
            net.minecraft.client.renderer.RenderHelper.func_227784_d_();
        } else {
            net.minecraft.client.renderer.RenderHelper.func_227783_c_();
        }
        ms.func_227866_c_().func_227872_b_().func_226114_a_(Matrix3f.func_226117_b_((float)1.0f, (float)-1.0f, (float)1.0f));
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        mc.func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, ms, (IRenderTypeBuffer)buffers, 0xF000F0, OverlayTexture.field_229196_a_, ibakedmodel);
        buffers.func_228461_a_();
        ms.func_227865_b_();
        net.minecraft.client.renderer.RenderHelper.func_227781_a_((Matrix4f)ms.func_227866_c_().func_227870_a_());
        RenderSystem.popAttributes();
    }

    public static void applyStippling(int alpha, Runnable renderer) {
        mc.func_147110_a().enableStencil();
        GL43.glEnable((int)2960);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)true);
        double width = RenderUtil.mc.func_147110_a().field_147621_c;
        double height = RenderUtil.mc.func_147110_a().field_147618_d;
        GlStateManager.func_227731_j_();
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_((double)0.0, (double)width, (double)height, (double)0.0, (double)-1.0, (double)1.0);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227714_e_((int)0, (int)0, (int)((int)width), (int)((int)height));
        GlStateManager.func_227619_H_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227700_d_();
        stipplingShader.use();
        GL43.glUniform1i((int)stipplingAlphaUniformLocation, (int)alpha);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_(0.0, height, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        builder.func_225582_a_(width, height, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        builder.func_225582_a_(width, 0.0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        builder.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        stipplingShader.release();
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227627_O_();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        renderer.run();
        GL43.glDisable((int)2960);
    }

    public static void applyStippling(double alpha, Runnable renderer) {
        RenderUtil.applyStippling((int)Math.round(alpha * 16.0), renderer);
    }
}

