/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea.client.render;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mezz.jei.util.MathUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class ColoredItemParticleHelper {
    private static final Map<Item, TextureAtlasSprite[]> CACHE = new HashMap<Item, TextureAtlasSprite[]>();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Random RAND = new Random();
    private static final Random MODEL_RAND = new Random();
    private static final ItemColors itemColors = mc.getItemColors();
    private static final BlockColors blockColors = mc.func_184125_al();
    private static final ItemModelMesher itemModelMesher = mc.func_175599_af().func_175037_a();
    private static final BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();

    public static int getRandomColor(TextureAtlasSprite[] sprites, int renderColor) {
        TextureAtlasSprite sprite = sprites.length != 0 ? sprites[RAND.nextInt(sprites.length)] : mc.func_209506_al().func_174951_a().getParticleTexture((IModelData)EmptyModelData.INSTANCE);
        int color = 255;
        for (int i = 0; i < 256; ++i) {
            color = sprite.getPixelRGBA(RAND.nextInt(sprite.func_110970_k()), RAND.nextInt(sprite.func_94211_a()), RAND.nextInt(sprite.func_94216_b()));
            if (NativeImage.func_227786_a_((int)color) <= 64) continue;
            int red = (int)((double)(color & 0xFE) * (double)(renderColor >> 16 & 0xFF) / 255.0);
            int green = (int)((double)(color >> 8 & 0xFE) * (double)(renderColor >> 8 & 0xFF) / 255.0);
            int blue = (int)((double)(color >> 16 & 0xFE) * (double)(renderColor & 0xFF) / 255.0);
            red = MathUtil.clamp((int)red, (int)0, (int)255);
            green = MathUtil.clamp((int)green, (int)0, (int)255);
            blue = MathUtil.clamp((int)blue, (int)0, (int)255);
            return 0xFF000000 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | red & 0xFF;
        }
        return color | 0xFF000000;
    }

    public static int getRandomColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        TextureAtlasSprite[] sprites = CACHE.get(item);
        if (sprites == null) {
            sprites = item instanceof BlockItem ? ColoredItemParticleHelper.getTextureAtlasSprites(((BlockItem)item).func_179223_d().func_176223_P()) : ColoredItemParticleHelper.getTextureAtlasSprites(item);
            CACHE.put(item, sprites);
        }
        int renderColor = item instanceof BlockItem ? blockColors.func_228054_a_(((BlockItem)item).func_179223_d().func_176223_P(), null, null, 0) : itemColors.func_186728_a(stack, 0);
        return ColoredItemParticleHelper.getRandomColor(sprites, renderColor);
    }

    public static float[] getRandomColordouble(ItemStack stack) {
        int color = ColoredItemParticleHelper.getRandomColor(stack);
        return new float[]{(float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, 1.0f};
    }

    private static TextureAtlasSprite[] getTextureAtlasSprites(Item item) {
        if (item instanceof BlockItem) {
            return ColoredItemParticleHelper.getTextureAtlasSprites(((BlockItem)item).func_179223_d().func_176223_P());
        }
        IBakedModel model = itemModelMesher.func_199312_b(item);
        if (model == null) {
            return new TextureAtlasSprite[0];
        }
        HashSet<TextureAtlasSprite> result = new HashSet<TextureAtlasSprite>();
        List quads = model.getQuads(null, null, MODEL_RAND, (IModelData)EmptyModelData.INSTANCE);
        for (BakedQuad quad : quads) {
            result.add(quad.func_187508_a());
        }
        return result.toArray(new TextureAtlasSprite[0]);
    }

    private static TextureAtlasSprite[] getTextureAtlasSprites(BlockState blockState) {
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(blockState);
        return new TextureAtlasSprite[]{textureAtlasSprite};
    }

    static {
        ((IReloadableResourceManager)mc.func_195551_G()).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
            if (resourcePredicate.test(VanillaResourceType.TEXTURES) || resourcePredicate.test(VanillaResourceType.MODELS)) {
                CACHE.clear();
            }
        }));
    }
}

