/*
 * Decompiled with CFR 0.152.
 */
package shblock.interactivecorporea;

import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shblock.interactivecorporea.IC;
import shblock.interactivecorporea.ModSounds;
import shblock.interactivecorporea.client.particle.QuantizationParticleType;
import shblock.interactivecorporea.client.renderer.item.ISTERBakedModel;
import shblock.interactivecorporea.client.renderer.tile.TERItemQuantizationDevice;
import shblock.interactivecorporea.client.requestinghalo.RequestingHaloInterface;
import shblock.interactivecorporea.client.requestinghalo.RequestingHaloInterfaceHandler;
import shblock.interactivecorporea.common.block.ModBlocks;
import shblock.interactivecorporea.common.crafting.RequestingHaloAddModuleRecipe;
import shblock.interactivecorporea.common.crafting.RequestingHaloRemoveModuleRecipe;
import shblock.interactivecorporea.common.item.ModItems;
import shblock.interactivecorporea.common.tile.ModTiles;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    private static <V extends IForgeRegistryEntry<V>> void register(IForgeRegistry<V> reg, String name, IForgeRegistryEntry<V> obj) {
        reg.register((IForgeRegistryEntry)obj.setRegistryName(new ResourceLocation("interactive_corporea", name)));
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
        IC.debug("Registering items...");
        IForgeRegistry reg = event.getRegistry();
        RegistryHandler.register(reg, "requesting_halo", ModItems.requestingHalo);
        RegistryHandler.register(reg, "item_quantization_device", ModItems.BlockItems.itemQuantizationDevice);
    }

    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
        IC.debug("Registering blocks...");
        IForgeRegistry reg = event.getRegistry();
        RegistryHandler.register(reg, "item_quantization_device", ModBlocks.itemQuantizationDevice);
    }

    private static void registerTile(IForgeRegistry<TileEntityType<?>> reg, Block block, TileEntityType<?> tile) {
        reg.register(tile.setRegistryName(Objects.requireNonNull(block.getRegistryName())));
    }

    @SubscribeEvent
    public static void onTileRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
        IC.debug("Registering tiles...");
        IForgeRegistry reg = event.getRegistry();
        RegistryHandler.registerTile(reg, ModBlocks.itemQuantizationDevice, ModTiles.itemQuantizationDevice);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)RequestingHaloInterfaceHandler.KEY_BINDING);
        ClientRegistry.registerKeyBinding((KeyBinding)RequestingHaloInterface.KEY_SEARCH);
        ClientRegistry.registerKeyBinding((KeyBinding)RequestingHaloInterface.KEY_REQUEST_UPDATE);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.itemQuantizationDevice, (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer(ModTiles.itemQuantizationDevice, TERItemQuantizationDevice::new);
    }

    @SubscribeEvent
    public static void onParticlesRegister(RegistryEvent.Register<ParticleType<?>> event) {
        IForgeRegistry reg = event.getRegistry();
        RegistryHandler.register(reg, "quantization", QuantizationParticleType.INSTANCE);
    }

    @SubscribeEvent
    public static void onParticleFactoryRegister(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)QuantizationParticleType.INSTANCE, QuantizationParticleType.Factory::new);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        IForgeRegistry reg = event.getRegistry();
        RegistryHandler.register(reg, "requesting_halo_add_module", RequestingHaloAddModuleRecipe.SERIALIZER);
        RegistryHandler.register(reg, "requesting_halo_remove_module", RequestingHaloRemoveModuleRecipe.SERIALIZER);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        IC.debug("Replacing baked models...");
        Map modelRegistry = event.getModelRegistry();
        new ISTERBakedModel(modelRegistry, ModItems.requestingHalo);
    }

    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        IC.debug("Registering sound events...");
        IForgeRegistry reg = event.getRegistry();
        reg.registerAll((IForgeRegistryEntry[])new SoundEvent[]{ModSounds.haloOpen, ModSounds.haloClose, ModSounds.haloListUpdate, ModSounds.haloSelect, ModSounds.haloRequest, ModSounds.haloReachEdge, ModSounds.quantumSend, ModSounds.quantumReceive});
    }
}

