/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.dubhe.curtain.CurtainRules;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class TranslationHelper {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final Map<String, Map<String, String>> TRANS_MAP = new HashMap<String, Map<String, String>>();

    @NotNull
    public static MutableComponent translate(String key, ChatFormatting formatting, Style style, Object ... args) {
        Map trans = TRANS_MAP.getOrDefault(CurtainRules.language, new HashMap());
        return Component.m_237113_((String)trans.getOrDefault(key, key).formatted(args));
    }

    @NotNull
    public static MutableComponent translate(String key, Object ... args) {
        Map trans = TRANS_MAP.getOrDefault(CurtainRules.language, new HashMap());
        return Component.m_264642_((String)key, (String)trans.getOrDefault(key, key).formatted(args), (Object[])args);
    }

    @NotNull
    public static Collection<String> getLanguages() {
        return TRANS_MAP.keySet();
    }

    public static void addTransMap(String lang, Map<String, String> transMap) {
        if (!TRANS_MAP.containsKey(lang)) {
            TRANS_MAP.put(lang, transMap);
        } else {
            TRANS_MAP.get(lang).putAll(transMap);
        }
    }

    public static Map<String, String> getTranslationFromResourcePath(InputStream stream) {
        String dataJSON;
        try {
            dataJSON = IOUtils.toString((InputStream)Objects.requireNonNull(stream), (Charset)StandardCharsets.UTF_8);
            stream.close();
        }
        catch (IOException | NullPointerException e) {
            return Map.of();
        }
        return (Map)GSON.fromJson(dataJSON, new TypeToken<Map<String, String>>(){}.getType());
    }

    static {
        TRANS_MAP.put("zh_cn", new HashMap());
    }
}

