/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.api.rules.CurtainRule;
import dev.dubhe.curtain.api.rules.RuleManager;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class MenuHelper {
    @NotNull
    public static Component main() {
        MutableComponent main = Component.m_237119_();
        MutableComponent title = TranslationHelper.translate("curtain.menu.title", new Object[0]).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        main.m_7220_((Component)title).m_130946_("\n");
        for (CurtainRule<?> rule : Curtain.rules.ruleMap.values()) {
            main.m_7220_(MenuHelper.rule(rule)).m_130946_("\n");
        }
        String v = ModList.get().getModFileById("curtain").versionString();
        MutableComponent version = TranslationHelper.translate("curtain.menu.version", v).m_130940_(ChatFormatting.GRAY);
        main.m_7220_((Component)version).m_130946_("\n");
        MutableComponent categories = TranslationHelper.translate("curtain.menu.categories", new Object[0]).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        main.m_7220_((Component)categories);
        for (String s : RuleManager.CATEGORIES_RULES.keySet()) {
            MutableComponent category = Component.m_237119_().m_130940_(ChatFormatting.AQUA);
            category.m_130946_("[");
            category.m_7220_((Component)TranslationHelper.translate("%s.categories.%s".formatted("curtain", s), new Object[0]));
            category.m_130946_("]");
            category.m_130946_(" ");
            category.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/curtain category %s".formatted(s))));
            main.m_7220_((Component)category);
        }
        return main;
    }

    @NotNull
    public static Component category(String name) {
        MutableComponent main = Component.m_237119_();
        MutableComponent display = Component.m_237113_((String)name);
        if (RuleManager.CATEGORIES_RULES.containsKey(name)) {
            display = TranslationHelper.translate("%s.categories.%s".formatted("curtain", name), new Object[0]);
        }
        main.m_7220_((Component)TranslationHelper.translate("curtain.menu.category", display.getString()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        for (String rule : (List)RuleManager.CATEGORIES_RULES.getOrDefault(name, new ArrayList())) {
            main.m_130946_("\n").m_7220_(MenuHelper.rule(RuleManager.RULES.get(rule)));
        }
        return main;
    }

    @NotNull
    public static Component rule(@NotNull CurtainRule<?> rule) {
        MutableComponent main = Component.m_237119_();
        MutableComponent name = Component.m_237119_();
        name.m_7220_((Component)rule.getNameComponent());
        name.m_7220_((Component)Component.m_237113_((String)"(%s): ".formatted(rule.getNormalName())));
        name.m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)rule.getDescComponent())));
        String value = String.valueOf(rule.getValue());
        Collection<String> suggestion = rule.getExamples();
        main.m_7220_((Component)name);
        MutableComponent v = Component.m_237113_((String)"[%s]".formatted(value)).m_130940_(rule.isDefault(value) ? ChatFormatting.DARK_GREEN : ChatFormatting.YELLOW).m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/curtain setValue %s %s".formatted(rule.getNormalName(), rule.getType() == String.class ? "\"%s\"".formatted(value) : value))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u5355\u51fb\u6765\u5feb\u901f\u586b\u5145"))));
        main.m_7220_((Component)v);
        for (String s : suggestion) {
            if (MenuHelper.replaceQuotation(s).equals(value)) continue;
            main.m_130946_(" ");
            MutableComponent x = Component.m_237113_((String)"[%s]".formatted(MenuHelper.replaceQuotation(s))).m_130940_(rule.isDefault(MenuHelper.replaceQuotation(s)) ? ChatFormatting.DARK_GREEN : ChatFormatting.YELLOW);
            x.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/curtain setValue %s %s".formatted(rule.getNormalName(), s))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u5355\u51fb\u6765\u5feb\u901f\u586b\u5145"))));
            main.m_7220_((Component)x);
        }
        return main;
    }

    private static String replaceQuotation(String s) {
        return s.replace("\"", "");
    }
}

