/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.player.fakes.IPistonBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockRotator {
    public static boolean flipBlockWithCactus(BlockState state, Level world, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(player.m_150110_().f_35938_ && CurtainRules.flippingCactus && BlockRotator.playerHoldsCactusMainhand(player))) {
            return false;
        }
        CurtainRules.impendingFillSkipUpdates.set(true);
        boolean retval = BlockRotator.flipBlock(state, world, player, hand, hit);
        CurtainRules.impendingFillSkipUpdates.set(false);
        return retval;
    }

    public static ItemStack dispenserRotate(BlockSource source, ItemStack stack) {
        Direction face;
        BlockPos blockpos;
        Direction sourceFace = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        ServerLevel world = source.m_7727_();
        BlockState blockstate = world.m_8055_(blockpos = source.m_7961_().m_121945_(sourceFace));
        Block block = blockstate.m_60734_();
        if (block instanceof DirectionalBlock || block instanceof DispenserBlock) {
            Direction face2 = (Direction)blockstate.m_61143_((Property)DirectionalBlock.f_52588_);
            if (block instanceof PistonBaseBlock && (((Boolean)blockstate.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue() || ((IPistonBlock)block).publicShouldExtend((Level)world, blockpos, face2) && new PistonStructureResolver((Level)world, blockpos, face2, true).m_60422_())) {
                return stack;
            }
            Direction rotatedFace = face2.m_175362_(sourceFace.m_122434_());
            if (sourceFace.m_122411_() % 2 == 0 || rotatedFace == face2) {
                rotatedFace = rotatedFace.m_122424_();
            }
            world.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)rotatedFace), 3);
        } else if (block instanceof HorizontalDirectionalBlock) {
            if (block instanceof BedBlock) {
                return stack;
            }
            Direction face3 = ((Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_175362_(Direction.Axis.Y);
            if (sourceFace == Direction.DOWN) {
                face3 = face3.m_122424_();
            }
            world.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)face3), 3);
        } else if (block == Blocks.f_50332_ && (face = (Direction)blockstate.m_61143_((Property)HopperBlock.f_54021_)) != Direction.DOWN) {
            face = face.m_175362_(Direction.Axis.Y);
            world.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)HopperBlock.f_54021_, (Comparable)face), 3);
        }
        world.m_46586_(blockpos, block, source.m_7961_());
        return stack;
    }

    public static boolean flipBlock(BlockState state, Level world, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block = state.m_60734_();
        BlockPos pos = hit.m_82425_();
        Vec3 hitVec = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        Direction facing = hit.m_82434_();
        BlockState newState = null;
        if ((block instanceof HorizontalDirectionalBlock || block instanceof BaseRailBlock) && !(block instanceof BedBlock)) {
            newState = state.m_60717_(Rotation.CLOCKWISE_90);
        } else if (block instanceof ObserverBlock || block instanceof EndRodBlock) {
            newState = (BlockState)state.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_());
        } else if (block instanceof DispenserBlock) {
            newState = (BlockState)state.m_61124_((Property)DispenserBlock.f_52659_, (Comparable)((Direction)state.m_61143_((Property)DispenserBlock.f_52659_)).m_122424_());
        } else if (block instanceof PistonBaseBlock) {
            if (!((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
                newState = (BlockState)state.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_());
            }
        } else if (block instanceof SlabBlock) {
            if (((SlabBlock)block).m_7923_(state)) {
                newState = (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)(state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP ? SlabType.BOTTOM : SlabType.TOP));
            }
        } else if (block instanceof HopperBlock) {
            if (state.m_61143_((Property)HopperBlock.f_54021_) != Direction.DOWN) {
                newState = (BlockState)state.m_61124_((Property)HopperBlock.f_54021_, (Comparable)((Direction)state.m_61143_((Property)HopperBlock.f_54021_)).m_122427_());
            }
        } else if (block instanceof StairBlock) {
            if (facing == Direction.UP && hitVec.f_82480_ == 1.0 || facing == Direction.DOWN && hitVec.f_82480_ == 0.0) {
                newState = (BlockState)state.m_61124_((Property)StairBlock.f_56842_, (Comparable)(state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP ? Half.BOTTOM : Half.TOP));
            } else {
                boolean turnCounterClockwise = switch (facing) {
                    case Direction.NORTH -> {
                        if (hitVec.f_82479_ <= 0.5) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if (!(hitVec.f_82479_ <= 0.5)) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.EAST -> {
                        if (hitVec.f_82481_ <= 0.5) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> {
                        if (!(hitVec.f_82481_ <= 0.5)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
                newState = state.m_60717_(turnCounterClockwise ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
            }
        } else if (block instanceof RotatedPillarBlock) {
            newState = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)(switch ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> Direction.Axis.Z;
                case Direction.Axis.Y -> Direction.Axis.X;
                case Direction.Axis.Z -> Direction.Axis.Y;
            }));
        }
        if (newState != null) {
            world.m_7731_(pos, newState, 1026);
            world.m_6550_(pos, state, newState);
            return true;
        }
        return false;
    }

    private static boolean playerHoldsCactusMainhand(Player playerIn) {
        return playerIn.m_21205_().m_41720_() == Items.f_41982_;
    }

    public static boolean flippinEligibility(Entity entity) {
        Player p;
        return CurtainRules.flippingCactus && entity instanceof Player && (p = (Player)entity).m_21206_().m_41720_() == Items.f_41982_;
    }

    public static class CactusDispenserBehaviour
    extends OptionalDispenseItemBehavior
    implements DispenseItemBehavior {
        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            if (CurtainRules.rotatorBlock) {
                return BlockRotator.dispenserRotate(source, stack);
            }
            return super.m_7498_(source, stack);
        }
    }
}

