/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins.rules.better_sign_interaction;

import dev.dubhe.curtain.CurtainRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SignBlock.class})
public abstract class SignBlockMixin {
    private final SignBlock self = (SignBlock)this;

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;)V")}, cancellable=true)
    public void use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (CurtainRules.betterSignInteraction && this.self instanceof WallSignBlock) {
            SignBlockEntity sign;
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof SignBlockEntity && !(sign = (SignBlockEntity)entity).m_277118_()) {
                return;
            }
            Direction direction = (Direction)state.m_61143_((Property)WallSignBlock.f_58064_);
            BlockPos blockPos = pos.m_5484_(direction, -1);
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60734_() instanceof WallSignBlock) {
                return;
            }
            BlockHitResult hitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)blockPos), direction, blockPos, false);
            blockState.m_60664_(level, player, hand, hitResult);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

