/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.player.patches;

import com.mojang.authlib.GameProfile;
import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.player.fakes.IServerPlayer;
import dev.dubhe.curtain.features.player.patches.FakeClientConnection;
import dev.dubhe.curtain.utils.Messenger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EntityPlayerMPFake
extends ServerPlayer {
    public boolean isAShadow;
    public Runnable fixStartingPosition = () -> {};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityPlayerMPFake createFakePlayer(String username, MinecraftServer server, double x, double y, double z, double yaw, double pitch, ResourceKey<Level> dimensionId, GameType gamemode, boolean isflying) {
        GameProfile gameProfile;
        ServerLevel worldIn = server.m_129880_(dimensionId);
        GameProfileCache.m_11004_((boolean)false);
        try {
            gameProfile = server.m_129927_().m_10996_(username).orElse(null);
        }
        catch (Throwable throwable) {
            GameProfileCache.m_11004_((server.m_6982_() && server.m_129797_() ? 1 : 0) != 0);
            throw throwable;
        }
        GameProfileCache.m_11004_((server.m_6982_() && server.m_129797_() ? 1 : 0) != 0);
        try {
            if (gameProfile == null) {
                if (!CurtainRules.allowSpawningOfflinePlayers) {
                    return null;
                }
                gameProfile = new GameProfile(UUIDUtil.m_235879_((String)username), username);
            }
            if (gameProfile.getProperties().containsKey((Object)"textures")) {
                AtomicReference result = new AtomicReference();
                SkullBlockEntity.m_155738_((GameProfile)gameProfile, result::set);
                gameProfile = (GameProfile)result.get();
            }
            EntityPlayerMPFake instance = new EntityPlayerMPFake(server, worldIn, gameProfile, false);
            instance.fixStartingPosition = () -> instance.m_7678_(x, y, z, (float)yaw, (float)pitch);
            server.m_6846_().m_11261_((Connection)new FakeClientConnection(PacketFlow.SERVERBOUND), (ServerPlayer)instance);
            instance.m_8999_(worldIn, x, y, z, (float)yaw, (float)pitch);
            instance.m_21153_(20.0f);
            instance.m_146912_();
            instance.m_274367_(0.6f);
            instance.f_8941_.m_143473_(gamemode);
            server.m_6846_().m_11270_((Packet)new ClientboundRotateHeadPacket((Entity)instance, (byte)(instance.f_20885_ * 256.0f / 360.0f)), dimensionId);
            server.m_6846_().m_11270_((Packet)new ClientboundTeleportEntityPacket((Entity)instance), dimensionId);
            instance.f_19804_.m_135381_(f_36089_, (Object)127);
            instance.m_150110_().f_35935_ = isflying;
            return instance;
        }
        catch (Exception exception) {
            Messenger.print_server_message(server, exception.getMessage());
            return null;
        }
    }

    public static EntityPlayerMPFake createShadow(MinecraftServer server, ServerPlayer player) {
        player.m_20194_().m_6846_().m_11286_(player);
        player.f_8906_.m_9942_((Component)Component.m_237115_((String)"multiplayer.disconnect.duplicate_login"));
        ServerLevel worldIn = (ServerLevel)player.m_9236_();
        GameProfile gameprofile = player.m_36316_();
        EntityPlayerMPFake playerShadow = new EntityPlayerMPFake(server, worldIn, gameprofile, true);
        server.m_6846_().m_11261_((Connection)new FakeClientConnection(PacketFlow.SERVERBOUND), (ServerPlayer)playerShadow);
        playerShadow.m_21153_(player.m_21223_());
        playerShadow.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        playerShadow.f_8941_.m_143473_(player.f_8941_.m_9290_());
        ((IServerPlayer)((Object)playerShadow)).getActionPack().copyFrom(((IServerPlayer)player).getActionPack());
        playerShadow.m_274367_(0.6f);
        playerShadow.f_19804_.m_135381_(f_36089_, (Object)((Byte)player.m_20088_().m_135370_(f_36089_)));
        server.m_6846_().m_11270_((Packet)new ClientboundRotateHeadPacket((Entity)playerShadow, (byte)(player.f_20885_ * 256.0f / 360.0f)), playerShadow.m_9236_().m_46472_());
        server.m_6846_().m_11268_((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)playerShadow));
        playerShadow.m_150110_().f_35935_ = player.m_150110_().f_35935_;
        return playerShadow;
    }

    private EntityPlayerMPFake(MinecraftServer minecraftServer, ServerLevel level, GameProfile gameProfile, boolean isShadow) {
        super(minecraftServer, level, gameProfile);
        this.isAShadow = isShadow;
    }

    public void m_238392_(EquipmentSlot p_238393_, ItemStack p_238394_, ItemStack p_238395_) {
        if (!this.m_6117_()) {
            super.m_238392_(p_238393_, p_238394_, p_238395_);
        }
    }

    public void m_6074_() {
        this.kill(Messenger.s("Killed"));
    }

    public void kill(Component reason) {
        this.shakeOff();
        this.f_8924_.m_6937_((Runnable)new TickTask(this.f_8924_.m_129921_(), () -> this.f_8906_.m_7026_(reason)));
    }

    public void m_8119_() {
        if (this.m_20194_().m_129921_() % 10 == 0) {
            this.f_8906_.m_9953_();
            ((ServerLevel)this.m_9236_()).m_7726_().m_8385_((ServerPlayer)this);
        }
        try {
            super.m_8119_();
            this.m_9240_();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void shakeOff() {
        if (this.m_20202_() instanceof Player) {
            this.m_8127_();
        }
        for (Entity passenger : this.m_146897_()) {
            if (!(passenger instanceof Player)) continue;
            passenger.m_8127_();
        }
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        this.shakeOff();
        super.m_6667_(damageSource);
        this.m_21153_(20.0f);
        this.f_36097_ = new FoodData();
        this.kill(this.m_21231_().m_19293_());
    }

    public String m_9239_() {
        return "127.0.0.1";
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        this.m_289599_(this.m_20185_(), y, this.m_20189_(), onGround);
    }

    public Entity m_5489_(@NotNull ServerLevel level) {
        super.m_5489_(level);
        if (this.f_8944_) {
            ServerboundClientCommandPacket packet = new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN);
            this.f_8906_.m_6272_(packet);
        }
        if (this.f_8906_.f_9743_.m_8958_()) {
            this.f_8906_.f_9743_.m_8959_();
        }
        return this.f_8906_.f_9743_;
    }
}

