/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.logging.builtin;

import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.features.logging.AbstractHudLogger;
import java.util.Arrays;
import java.util.OptionalDouble;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class TPSLogger
extends AbstractHudLogger {
    private static final double MAX_TPS = 20.0;

    public TPSLogger() {
        super("tps");
    }

    @Override
    public Component display(ServerPlayer player) {
        MinecraftServer server = Curtain.minecraftServer;
        OptionalDouble averageTPS = Arrays.stream(server.f_129748_).average();
        if (averageTPS.isEmpty()) {
            return Component.m_237113_((String)"No TPS data available").m_130938_(style -> style.m_131140_(ChatFormatting.RED));
        }
        double MSPT = Arrays.stream(server.f_129748_).average().getAsDouble() * 1.0E-6;
        double TPS = Math.min(1000.0 / MSPT, 20.0);
        ChatFormatting color = ChatFormatting.GREEN;
        if (MSPT >= 0.0) {
            color = ChatFormatting.DARK_GREEN;
        }
        if (MSPT >= 20.0) {
            color = ChatFormatting.GREEN;
        }
        if (MSPT >= 35.0) {
            color = ChatFormatting.YELLOW;
        }
        if (MSPT >= 45.0) {
            color = ChatFormatting.RED;
        }
        ChatFormatting finalColor = color;
        return Component.m_237113_((String)"TPS: ").m_130938_(style -> style.m_131140_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"%.1f".formatted(TPS)).m_130938_(style -> style.m_131140_(finalColor))).m_7220_((Component)Component.m_237113_((String)" MSPT: ").m_130938_(style -> style.m_131140_(ChatFormatting.GRAY))).m_7220_((Component)Component.m_237113_((String)"%.1f".formatted(MSPT)).m_130938_(style -> style.m_131140_(finalColor)));
    }
}

