/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.logging;

import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.features.logging.AbstractLogger;
import dev.dubhe.curtain.features.logging.DisplayType;
import dev.dubhe.curtain.features.logging.builtin.MemoryLogger;
import dev.dubhe.curtain.features.logging.builtin.MobcapsLogger;
import dev.dubhe.curtain.features.logging.builtin.TPSLogger;
import dev.dubhe.curtain.features.logging.helper.ExplosionLogHelper;
import dev.dubhe.curtain.features.logging.helper.TNTLogHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class LoggerManager {
    private static final Map<String, AbstractLogger> registeredLogger = new HashMap<String, AbstractLogger>();
    private static final Map<String, Set<String>> subscribedPlayer = new HashMap<String, Set<String>>();

    public static void ableSendToChat(String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return;
        }
        AbstractLogger logger = registeredLogger.get(loggerName);
        if (logger.getType() != DisplayType.CHAT) {
            Curtain.LOGGER.error("Logger {} not a chat logger", (Object)loggerName);
            return;
        }
        for (Map.Entry<String, Set<String>> entry : subscribedPlayer.entrySet()) {
            ServerPlayer player;
            if (!entry.getValue().contains(loggerName) || (player = Curtain.minecraftServer.m_6846_().m_11255_(entry.getKey())) == null) continue;
            Component msg = logger.display(player);
            player.m_213846_(msg);
        }
    }

    public static void updateHUD() {
        for (Map.Entry<String, Set<String>> entry : subscribedPlayer.entrySet()) {
            ServerPlayer player = Curtain.minecraftServer.m_6846_().m_11255_(entry.getKey());
            if (player == null) continue;
            MutableComponent msg = Component.m_237119_();
            Iterator<String> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                String loggerName = iterator.next();
                if (!registeredLogger.containsKey(loggerName) || registeredLogger.get(loggerName).getType() != DisplayType.HUD) continue;
                msg.m_7220_(registeredLogger.get(loggerName).display(player));
                if (!iterator.hasNext()) continue;
                msg.m_130946_("\n");
            }
            player.setTabListFooter((Component)msg);
        }
    }

    public static void registerLogger(AbstractLogger logger) {
        registeredLogger.put(logger.getName(), logger);
    }

    public static void subscribeLogger(String playerName, String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return;
        }
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        loggerSet.add(loggerName);
        subscribedPlayer.put(playerName, loggerSet);
        ServerPlayer player = Curtain.minecraftServer.m_6846_().m_11255_(playerName);
        if (player != null) {
            player.m_240418_((Component)Component.m_237113_((String)"%s subscribed logger %s".formatted(playerName, loggerName)).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY)), false);
        }
    }

    public static void subscribeLogger(String playerName, String[] loggers) {
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        loggerSet.addAll(Arrays.asList(loggers));
        subscribedPlayer.put(playerName, loggerSet);
    }

    public static void unsubscribeLogger(String playerName, String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return;
        }
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        loggerSet.remove(loggerName);
        subscribedPlayer.put(playerName, loggerSet);
        ServerPlayer player = Curtain.minecraftServer.m_6846_().m_11255_(playerName);
        if (player != null) {
            player.m_240418_((Component)Component.m_237113_((String)"%s unsubscribed logger %s".formatted(playerName, loggerName)).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY)), false);
        }
    }

    public static void unsubscribeAllLogger(String playerName) {
        subscribedPlayer.remove(playerName);
    }

    public static boolean isSubscribedLogger(String playerName, String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return false;
        }
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        return loggerSet.contains(loggerName);
    }

    public static boolean hasSubscribedLogger(String playerName) {
        return subscribedPlayer.containsKey(playerName);
    }

    public static void registryBuiltinLogger() {
        LoggerManager.registerLogger(new TPSLogger());
        LoggerManager.registerLogger(new MobcapsLogger());
        LoggerManager.registerLogger(new MemoryLogger());
        LoggerManager.registerLogger(new ExplosionLogHelper.ExplosionLogger());
        LoggerManager.registerLogger(new TNTLogHelper.TNTLogger());
    }

    public static Set<String> getLoggerSet() {
        return registeredLogger.keySet();
    }
}

