/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.events.utils;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.logging.LoggerManager;
import dev.dubhe.curtain.features.player.helpers.FakePlayerResident;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerEventHandler {
    private int timer = 0;

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (!event.getServer().m_129792_()) {
            FakePlayerResident.onServerStart(event.getServer());
        }
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        FakePlayerResident.onServerStop(event.getServer());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.timer <= 0) {
            this.timer = CurtainRules.HUDLoggerUpdateInterval;
            LoggerManager.updateHUD();
        }
        --this.timer;
    }

    @SubscribeEvent
    public void onPlayLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.m_20194_() != null && player2.m_20194_().m_129792_() && player2.m_20194_().m_7779_(player2.m_36316_())) {
                FakePlayerResident.onServerStart(event.getEntity().m_20194_());
            }
            String playerName = player2.m_7755_().getString();
            if (CurtainRules.defaultLoggers.contentEquals("none")) {
                return;
            }
            if (!LoggerManager.hasSubscribedLogger(playerName)) {
                String[] logs = CurtainRules.defaultLoggers.replace(" ", "").split(",");
                LoggerManager.subscribeLogger(playerName, logs);
            }
        }
    }

    @SubscribeEvent
    public void onPlayLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String playerName = player2.m_7755_().getString();
            LoggerManager.unsubscribeAllLogger(playerName);
        }
    }
}

