/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.api.rules.Categories;
import dev.dubhe.curtain.api.rules.CurtainRule;
import dev.dubhe.curtain.api.rules.RuleException;
import dev.dubhe.curtain.api.rules.RuleManager;
import dev.dubhe.curtain.utils.MenuHelper;
import dev.dubhe.curtain.utils.TranslationHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class RuleCommand {
    public static void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull RuleManager manager) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)manager.getId()).requires(stack -> stack.m_6761_(2))).executes(RuleCommand::showMenu)).then(Commands.m_82127_((String)"category").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(Categories.getCategories(), (SuggestionsBuilder)builder)).executes(RuleCommand::showCategory)))).then(RuleCommand.valueNode(false, Commands.m_82127_((String)"setValue")))).then(RuleCommand.valueNode(true, Commands.m_82127_((String)"setDefault"))));
    }

    private static int showMenu(@NotNull CommandContext<CommandSourceStack> context) {
        Component component = MenuHelper.main();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> component, false);
        return 1;
    }

    private static int showCategory(@NotNull CommandContext<CommandSourceStack> context) {
        Component component = MenuHelper.category((String)context.getArgument("name", String.class));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> component, false);
        return 1;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> valueNode(boolean setDefault, ArgumentBuilder<CommandSourceStack, ?> builder) {
        for (CurtainRule<?> rule : RuleManager.RULES.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)rule.getNormalName()).executes(context -> RuleCommand.getValue((CommandContext<CommandSourceStack>)context, rule))).then(Commands.m_82129_((String)"value", RuleCommand.getValue(rule.getType())).suggests((context, builder1) -> {
                for (String example : rule.getExamples()) {
                    if (!example.startsWith(builder1.getRemainingLowerCase())) continue;
                    builder1.suggest(example);
                }
                return builder1.buildFuture();
            }).executes(context -> RuleCommand.setValue(rule.getNormalName(), (CommandContext<CommandSourceStack>)context, setDefault))));
        }
        return builder;
    }

    private static ArgumentType<?> getValue(Class<?> type) {
        if (type == String.class) {
            return StringArgumentType.string();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return BoolArgumentType.bool();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Short.class || type == Short.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Long.class || type == Long.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Float.class || type == Float.TYPE) {
            return FloatArgumentType.floatArg();
        }
        if (type == Double.class || type == Double.TYPE) {
            return DoubleArgumentType.doubleArg();
        }
        throw RuleException.type();
    }

    private static int getValue(@NotNull CommandContext<CommandSourceStack> context, CurtainRule<?> rule) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> MenuHelper.rule(rule), false);
        return 1;
    }

    private static int setValue(String name, CommandContext<CommandSourceStack> context, boolean setDefault) {
        CurtainRule<?> rule = RuleManager.RULES.get(name);
        if (null == rule) {
            throw RuleException.nu11();
        }
        Object obj = context.getArgument("value", rule.getType());
        if (!rule.validate((CommandSourceStack)context.getSource(), String.valueOf(obj))) {
            throw RuleException.legal();
        }
        rule.setValue(obj, rule.getType());
        String ruleName = rule.getNameComponent().getString();
        if (!setDefault) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/curtain setDefault %s %s".formatted(name, obj)));
            MutableComponent component = TranslationHelper.translate("curtain.menu.change", ruleName, obj).m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)TranslationHelper.translate("curtain.menu.as_default", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN).m_130948_(style));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> RuleCommand.lambda$setValue$9((Component)component), false);
            return 0;
        }
        Curtain.rules.setDefault(rule.getNormalName());
        Curtain.rules.saveToFile();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> TranslationHelper.translate("curtain.menu.change.default", ruleName, obj).m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private static /* synthetic */ Component lambda$setValue$9(Component component) {
        return component;
    }
}

