/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.player.fakes.IServerPlayer;
import dev.dubhe.curtain.features.player.helpers.EntityPlayerActionPack;
import dev.dubhe.curtain.features.player.patches.EntityPlayerMPFake;
import dev.dubhe.curtain.utils.CommandHelper;
import dev.dubhe.curtain.utils.Messenger;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PlayerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        String[] gamemodeStrings = (String[])Arrays.stream(GameType.values()).map(GameType::m_46405_).toArray(String[]::new);
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"player").requires(player -> CommandHelper.canUseCommand(player, CurtainRules.commandPlayer))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(PlayerCommand.getPlayers((CommandSourceStack)c.getSource()), (SuggestionsBuilder)b)).then(Commands.m_82127_((String)"stop").executes(PlayerCommand::stop))).then(PlayerCommand.makeActionCommand("use", EntityPlayerActionPack.ActionType.USE))).then(PlayerCommand.makeActionCommand("jump", EntityPlayerActionPack.ActionType.JUMP))).then(PlayerCommand.makeActionCommand("attack", EntityPlayerActionPack.ActionType.ATTACK))).then(PlayerCommand.makeActionCommand("drop", EntityPlayerActionPack.ActionType.DROP_ITEM))).then(PlayerCommand.makeDropCommand("drop", false))).then(PlayerCommand.makeActionCommand("dropStack", EntityPlayerActionPack.ActionType.DROP_STACK))).then(PlayerCommand.makeDropCommand("dropStack", true))).then(PlayerCommand.makeActionCommand("swapHands", EntityPlayerActionPack.ActionType.SWAP_HANDS))).then(Commands.m_82127_((String)"hotbar").then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.setSlot(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"))))))).then(Commands.m_82127_((String)"kill").executes(PlayerCommand::kill))).then(Commands.m_82127_((String)"shadow").executes(PlayerCommand::shadow))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mount").executes(PlayerCommand.manipulation(ap -> ap.mount(true)))).then(Commands.m_82127_((String)"anything").executes(PlayerCommand.manipulation(ap -> ap.mount(false)))))).then(Commands.m_82127_((String)"dismount").executes(PlayerCommand.manipulation(EntityPlayerActionPack::dismount)))).then(Commands.m_82127_((String)"sneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(true))))).then(Commands.m_82127_((String)"unsneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(false))))).then(Commands.m_82127_((String)"sprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(true))))).then(Commands.m_82127_((String)"unsprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"look").then(Commands.m_82127_((String)"north").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.NORTH))))).then(Commands.m_82127_((String)"south").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.SOUTH))))).then(Commands.m_82127_((String)"east").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.EAST))))).then(Commands.m_82127_((String)"west").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.WEST))))).then(Commands.m_82127_((String)"up").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.UP))))).then(Commands.m_82127_((String)"down").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.DOWN))))).then(Commands.m_82127_((String)"at").then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).executes(PlayerCommand::lookAt)))).then(Commands.m_82129_((String)"direction", (ArgumentType)RotationArgument.m_120479_()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.look(RotationArgument.m_120482_((CommandContext)c, (String)"direction").m_6970_((CommandSourceStack)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"turn").then(Commands.m_82127_((String)"left").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.turn(-90.0f, 0.0f))))).then(Commands.m_82127_((String)"right").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.turn(90.0f, 0.0f))))).then(Commands.m_82127_((String)"back").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.turn(180.0f, 0.0f))))).then(Commands.m_82129_((String)"rotation", (ArgumentType)RotationArgument.m_120479_()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.turn(RotationArgument.m_120482_((CommandContext)c, (String)"rotation").m_6970_((CommandSourceStack)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"move").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, EntityPlayerActionPack::stopMovement))).then(Commands.m_82127_((String)"forward").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.setForward(1.0f))))).then(Commands.m_82127_((String)"backward").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.setForward(-1.0f))))).then(Commands.m_82127_((String)"left").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.setStrafing(1.0f))))).then(Commands.m_82127_((String)"right").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.setStrafing(-1.0f)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"in").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"gamemode", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])gamemodeStrings, (SuggestionsBuilder)b)).executes(PlayerCommand::spawn)))).then(Commands.m_82127_((String)"at").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).executes(PlayerCommand::spawn)).then(Commands.m_82127_((String)"facing").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"direction", (ArgumentType)RotationArgument.m_120479_()).executes(PlayerCommand::spawn)).then(Commands.m_82127_((String)"in").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"in").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"gamemode", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])gamemodeStrings, (SuggestionsBuilder)b)).executes(PlayerCommand::spawn)))))))))));
        dispatcher.register(literalargumentbuilder);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> makeActionCommand(String actionName, EntityPlayerActionPack.ActionType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)actionName).executes(c -> PlayerCommand.action((CommandContext<CommandSourceStack>)c, type, EntityPlayerActionPack.Action.once()))).then(Commands.m_82127_((String)"once").executes(c -> PlayerCommand.action((CommandContext<CommandSourceStack>)c, type, EntityPlayerActionPack.Action.once())))).then(Commands.m_82127_((String)"continuous").executes(c -> PlayerCommand.action((CommandContext<CommandSourceStack>)c, type, EntityPlayerActionPack.Action.continuous())))).then(Commands.m_82127_((String)"interval").then(Commands.m_82129_((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> PlayerCommand.action((CommandContext<CommandSourceStack>)c, type, EntityPlayerActionPack.Action.interval(IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> makeDropCommand(String actionName, boolean dropAll) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)actionName).then(Commands.m_82127_((String)"all").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.drop(-2, dropAll))))).then(Commands.m_82127_((String)"mainhand").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.drop(-1, dropAll))))).then(Commands.m_82127_((String)"offhand").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.drop(40, dropAll))))).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.drop(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"), dropAll))));
    }

    private static Collection<String> getPlayers(CommandSourceStack source) {
        LinkedHashSet<String> players = new LinkedHashSet<String>(List.of("Steve", "Alex"));
        players.addAll(source.m_5982_());
        return players;
    }

    private static ServerPlayer getPlayer(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        return server.m_6846_().m_11255_(playerName);
    }

    private static boolean cantManipulate(CommandContext<CommandSourceStack> context) {
        ServerPlayer sendingPlayer;
        ServerPlayer player = PlayerCommand.getPlayer(context);
        if (player == null) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Can only manipulate existing players");
            return true;
        }
        try {
            sendingPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        if (!((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11303_(sendingPlayer.m_36316_()) && sendingPlayer != player && !(player instanceof EntityPlayerMPFake)) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Non OP players can't control other real players");
            return true;
        }
        return false;
    }

    private static boolean cantReMove(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return true;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            return false;
        }
        Messenger.m((CommandSourceStack)context.getSource(), "r Only fake players can be moved or killed");
        return true;
    }

    private static boolean cantSpawn(CommandContext<CommandSourceStack> context) {
        Object playerName = StringArgumentType.getString(context, (String)"player");
        String prefix = "none".equals(CurtainRules.fakePlayerNamePrefix) || ((String)playerName).startsWith(CurtainRules.fakePlayerNamePrefix) ? "" : CurtainRules.fakePlayerNamePrefix;
        String suffix = "none".equals(CurtainRules.fakePlayerNameSuffix) || ((String)playerName).endsWith(CurtainRules.fakePlayerNameSuffix) ? "" : CurtainRules.fakePlayerNameSuffix;
        playerName = prefix + (String)playerName + suffix;
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        PlayerList manager = server.m_6846_();
        ServerPlayer player = manager.m_11255_((String)playerName);
        if (player != null) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Player ", "rb " + (String)playerName, "r  is already logged on");
            return true;
        }
        GameProfile profile = server.m_129927_().m_10996_((String)playerName).orElse(null);
        if (profile == null) {
            if (!CurtainRules.allowSpawningOfflinePlayers) {
                Messenger.m((CommandSourceStack)context.getSource(), "r Player " + (String)playerName + " is either banned by Mojang, or auth servers are down. Banned players can only be summoned in Singleplayer and in servers in off-line mode.");
                return true;
            }
            profile = new GameProfile(UUIDUtil.m_235879_((String)playerName), (String)playerName);
        }
        if (manager.m_11295_().m_11406_(profile)) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Player ", "rb " + (String)playerName, "r  is banned on this server");
            return true;
        }
        if (manager.m_11311_() && manager.m_5764_(profile) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Whitelisted players can only be spawned by operators");
            return true;
        }
        return false;
    }

    private static int kill(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantReMove(context)) {
            return 0;
        }
        PlayerCommand.getPlayer(context).m_6074_();
        return 1;
    }

    private static int lookAt(CommandContext<CommandSourceStack> context) {
        return PlayerCommand.manipulate(context, ap -> ap.lookAt(Vec3Argument.m_120844_((CommandContext)context, (String)"position")));
    }

    private static <T> T tryGetArg(SupplierWithCommandSyntaxException<T> a, SupplierWithCommandSyntaxException<T> b) throws CommandSyntaxException {
        try {
            return a.get();
        }
        catch (IllegalArgumentException e) {
            return b.get();
        }
    }

    private static int spawn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (PlayerCommand.cantSpawn(context)) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Vec3 pos = PlayerCommand.tryGetArg(() -> Vec3Argument.m_120844_((CommandContext)context, (String)"position"), () -> ((CommandSourceStack)source).m_81371_());
        Vec2 facing = PlayerCommand.tryGetArg(() -> RotationArgument.m_120482_((CommandContext)context, (String)"direction").m_6970_((CommandSourceStack)context.getSource()), () -> ((CommandSourceStack)source).m_81376_());
        ResourceKey dimType = PlayerCommand.tryGetArg(() -> DimensionArgument.m_88808_((CommandContext)context, (String)"dimension").m_46472_(), () -> source.m_81372_().m_46472_());
        GameType mode = GameType.CREATIVE;
        boolean flying = false;
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            mode = player.f_8941_.m_9290_();
            flying = player.m_150110_().f_35935_;
        }
        catch (CommandSyntaxException player) {
            // empty catch block
        }
        try {
            String opGameMode = StringArgumentType.getString(context, (String)"gamemode");
            mode = GameType.m_46402_((String)opGameMode, null);
            if (mode == null) {
                Messenger.m((CommandSourceStack)context.getSource(), "rb Invalid game mode: " + opGameMode + ".");
                return 0;
            }
        }
        catch (IllegalArgumentException opGameMode) {
            // empty catch block
        }
        if (mode == GameType.SPECTATOR) {
            flying = true;
        } else if (mode.m_46409_()) {
            flying = false;
        }
        Object playerName = StringArgumentType.getString(context, (String)"player");
        String prefix = "none".equals(CurtainRules.fakePlayerNamePrefix) || ((String)playerName).startsWith(CurtainRules.fakePlayerNamePrefix) ? "" : CurtainRules.fakePlayerNamePrefix;
        String suffix = "none".equals(CurtainRules.fakePlayerNameSuffix) || ((String)playerName).endsWith(CurtainRules.fakePlayerNameSuffix) ? "" : CurtainRules.fakePlayerNameSuffix;
        playerName = prefix + (String)playerName + suffix;
        if (((String)playerName).length() > PlayerCommand.maxPlayerLength(source.m_81377_())) {
            Messenger.m((CommandSourceStack)context.getSource(), "rb Player name: " + (String)playerName + " is too long");
            return 0;
        }
        MinecraftServer server = source.m_81377_();
        if (!Level.m_46741_((BlockPos)new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_))) {
            Messenger.m((CommandSourceStack)context.getSource(), "rb Player " + (String)playerName + " cannot be placed outside of the world");
            return 0;
        }
        EntityPlayerMPFake player = EntityPlayerMPFake.createFakePlayer((String)playerName, server, pos.f_82479_, pos.f_82480_, pos.f_82481_, facing.f_82471_, facing.f_82470_, (ResourceKey<Level>)dimType, mode, flying);
        if (player == null) {
            Messenger.m((CommandSourceStack)context.getSource(), "rb Player " + StringArgumentType.getString(context, (String)"player") + " doesn't exist and cannot spawn in online mode. Turn the server offline to spawn non-existing players");
            return 0;
        }
        return 1;
    }

    private static int maxPlayerLength(MinecraftServer server) {
        return server.m_7010_() >= 0 ? 16 : 40;
    }

    private static int stop(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        ((IServerPlayer)player).getActionPack().stopAll();
        return 1;
    }

    private static int manipulate(CommandContext<CommandSourceStack> context, Consumer<EntityPlayerActionPack> action) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        action.accept(((IServerPlayer)player).getActionPack());
        return 1;
    }

    private static Command<CommandSourceStack> manipulation(Consumer<EntityPlayerActionPack> action) {
        return c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, action);
    }

    private static int action(CommandContext<CommandSourceStack> context, EntityPlayerActionPack.ActionType type, EntityPlayerActionPack.Action action) {
        return PlayerCommand.manipulate(context, ap -> ap.start(type, action));
    }

    private static int shadow(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Cannot shadow fake players");
            return 0;
        }
        ServerPlayer sendingPlayer = null;
        try {
            sendingPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (sendingPlayer != player && PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        EntityPlayerMPFake.createShadow(player.f_8924_, player);
        return 1;
    }

    @FunctionalInterface
    static interface SupplierWithCommandSyntaxException<T> {
        public T get() throws CommandSyntaxException;
    }
}

