/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.api.rules;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dubhe.curtain.api.rules.CurtainRule;
import dev.dubhe.curtain.api.rules.IValidator;
import dev.dubhe.curtain.api.rules.Rule;
import dev.dubhe.curtain.api.rules.RuleException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

public class RuleManager {
    public static final List<Class<?>> LIMIT = new ArrayList();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<String, CurtainRule<?>> RULES = new HashMap();
    public static final Map<String, List<String>> CATEGORIES_RULES = new HashMap<String, List<String>>();
    public final Map<String, CurtainRule<?>> ruleMap = new HashMap();
    public final Map<String, CurtainRule<?>> defaultRuleMap = new HashMap();
    private final MinecraftServer server;
    private final String id;

    public RuleManager(MinecraftServer server, String id) {
        this.server = server;
        this.id = id;
        RULES.forEach((s, r) -> r.reset());
        this.loadFromFile();
    }

    public static void addRules(@NotNull Class<?> rules) {
        for (Field field : rules.getFields()) {
            Rule annotation;
            if (!LIMIT.contains(field.getType()) || null == (annotation = field.getAnnotation(Rule.class))) continue;
            String[] categories = annotation.categories();
            Class<? extends IValidator<?>>[] validators = annotation.validators();
            String[] suggestions = annotation.suggestions();
            CurtainRule rule = annotation.serializedName().contentEquals("") ? CurtainRule.newRule(categories, validators, suggestions, field) : CurtainRule.newRule(categories, validators, suggestions, field, annotation.serializedName());
            String name = rule.getNormalName();
            for (String category : categories) {
                if (!CATEGORIES_RULES.containsKey(category)) {
                    CATEGORIES_RULES.put(category, new ArrayList());
                }
                CATEGORIES_RULES.get(category).add(name);
            }
            RULES.put(name, rule);
        }
    }

    @NotNull
    private File getFile() {
        return this.server.m_129843_(LevelResource.f_78182_).resolve(this.id + ".json").toFile();
    }

    public void saveToFile() {
        JsonObject object = new JsonObject();
        for (String name : this.defaultRuleMap.keySet()) {
            CurtainRule<?> rule = this.defaultRuleMap.get(name);
            Object value = rule.getValue();
            if (value instanceof String) {
                String str = (String)value;
                object.addProperty(name, str);
                continue;
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                object.addProperty(name, bool);
                continue;
            }
            if (value instanceof Byte) {
                Byte num = (Byte)value;
                object.addProperty(name, (Number)num);
                continue;
            }
            if (value instanceof Short) {
                Short num = (Short)value;
                object.addProperty(name, (Number)num);
                continue;
            }
            if (value instanceof Integer) {
                Integer num = (Integer)value;
                object.addProperty(name, (Number)num);
                continue;
            }
            if (value instanceof Long) {
                Long num = (Long)value;
                object.addProperty(name, (Number)num);
                continue;
            }
            if (value instanceof Float) {
                Float num = (Float)value;
                object.addProperty(name, (Number)num);
                continue;
            }
            if (value instanceof Double) {
                Double num = (Double)value;
                object.addProperty(name, (Number)num);
                continue;
            }
            throw RuleException.type();
        }
        try (FileWriter writer = new FileWriter(this.getFile());){
            GSON.toJson((JsonElement)object, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadFromFile() {
        if (!this.getFile().exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.getFile());){
            JsonObject object = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            for (String name : RULES.keySet()) {
                if (!object.has(name)) continue;
                JsonElement element = object.get(name);
                CurtainRule<?> rule = RULES.get(name);
                if (null == rule) {
                    throw RuleException.nu11();
                }
                Object value = rule.getValue();
                if (value instanceof String) {
                    this.setValue(rule, element.getAsString());
                } else if (value instanceof Boolean) {
                    this.setValue(rule, element.getAsBoolean());
                } else if (value instanceof Byte) {
                    this.setValue(rule, element.getAsByte());
                } else if (value instanceof Short) {
                    this.setValue(rule, element.getAsShort());
                } else if (value instanceof Integer) {
                    this.setValue(rule, element.getAsInt());
                } else if (value instanceof Long) {
                    this.setValue(rule, element.getAsLong());
                } else if (value instanceof Float) {
                    this.setValue(rule, Float.valueOf(element.getAsFloat()));
                } else if (value instanceof Double) {
                    this.setValue(rule, element.getAsDouble());
                } else {
                    throw RuleException.type();
                }
                this.ruleMap.put(name, rule);
                this.defaultRuleMap.put(name, rule);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setValue(CurtainRule<?> rule, Object newValue) {
        if (rule.validate(this.server.m_129893_(), String.valueOf(newValue))) {
            rule.setValue(newValue, newValue.getClass());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setDefault(String name) {
        this.defaultRuleMap.put(name, RULES.get(name));
    }

    static {
        Collections.addAll(LIMIT, String.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    }
}

