/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.tathan.sky_aesthetics.client.skies.record.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.record.Star;
import fr.tathan.sky_aesthetics.client.skies.utils.ShootingStar;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import fr.tathan.sky_aesthetics.client.skies.utils.StarHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1132;
import net.minecraft.class_243;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_758;
import org.joml.Matrix4f;

public class SkyRenderer {
    private final SkyProperties properties;
    private final class_291 starBuffer;
    private final Map<UUID, ShootingStar> shootingStars;

    public SkyRenderer(SkyProperties properties) {
        this.properties = properties;
        this.starBuffer = !properties.stars().vanilla() ? StarHelper.createStars(properties.stars().scale(), properties.stars().count(), properties.stars().color().r(), properties.stars().color().g(), properties.stars().color().b(), properties.constellations()) : StarHelper.createVanillaStars();
        this.shootingStars = new HashMap<UUID, ShootingStar>();
    }

    public void render(class_638 level, class_4587 poseStack, Matrix4f projectionMatrix, float partialTick, class_4184 camera, Runnable fogCallback) {
        if (!this.isSkyRendered()) {
            return;
        }
        if (this.properties.fog().booleanValue()) {
            fogCallback.run();
        }
        class_289 tesselator = class_289.method_1348();
        CustomVanillaObject customVanillaObject = this.properties.customVanillaObject();
        float dayAngle = level.method_30274(partialTick) * 360.0f % 360.0f;
        float nightAngle = dayAngle + 180.0f;
        class_243 vec3 = level.method_23777(camera.method_19326(), partialTick);
        if (this.properties.skyColor().customColor()) {
            vec3 = this.properties.skyColor().color();
        }
        float r = (float)vec3.field_1352;
        float g = (float)vec3.field_1351;
        float b = (float)vec3.field_1350;
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        class_5944 shaderInstance = RenderSystem.getShader();
        if (Objects.equals(this.properties.skyType(), "NORMAL")) {
            SkyHelper.drawSky(poseStack.method_23760().method_23761(), projectionMatrix, shaderInstance, tesselator, poseStack, partialTick);
        } else if (Objects.equals(this.properties.skyType(), "END")) {
            SkyHelper.renderEndSky(poseStack);
        }
        this.renderStars(level, partialTick, poseStack, projectionMatrix, fogCallback, nightAngle);
        this.properties.stars().shootingStars().ifPresent(shootingStar -> this.handleShootingStars(level, poseStack, projectionMatrix, this.properties.stars(), partialTick));
        if (customVanillaObject.sun()) {
            SkyHelper.drawCelestialBody(customVanillaObject.sunTexture(), tesselator, poseStack, customVanillaObject.sunHeight(), customVanillaObject.sunSize(), dayAngle, true);
        }
        if (customVanillaObject.moon()) {
            if (customVanillaObject.moonPhase()) {
                SkyHelper.drawMoonWithPhase(level, tesselator, poseStack, customVanillaObject.moonSize(), customVanillaObject, nightAngle);
            } else {
                SkyHelper.drawCelestialBody(customVanillaObject.moonTexture(), tesselator, poseStack, customVanillaObject.moonHeight(), customVanillaObject.moonSize(), nightAngle, 0.0f, 1.0f, 0.0f, 1.0f, false);
            }
        }
        for (SkyObject skyObject : this.properties.skyObjects()) {
            SkyHelper.drawCelestialBody(skyObject, tesselator, poseStack, dayAngle);
        }
        if (this.properties.fog().booleanValue()) {
            fogCallback.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    private void handleShootingStars(class_638 level, class_4587 poseStack, Matrix4f projectionMatrix, Star star, float partialTick) {
        if (!level.field_9236) {
            return;
        }
        float starLight = level.method_23787(partialTick) * (1.0f - level.method_8430(partialTick));
        if (!star.allDaysVisible() && !(starLight > 0.2f)) {
            if (!this.shootingStars.isEmpty()) {
                this.shootingStars.clear();
            }
            return;
        }
        Star.ShootingStars shootingStarConfig = star.shootingStars().get();
        Random random = new Random();
        if (random.nextInt(1001) >= shootingStarConfig.percentage()) {
            UUID starId = UUID.randomUUID();
            ShootingStar shootingStar = new ShootingStar(random.nextInt((int)shootingStarConfig.randomLifetime().field_1343, (int)shootingStarConfig.randomLifetime().field_1342), shootingStarConfig, starId);
            this.shootingStars.putIfAbsent(starId, shootingStar);
        }
        if (this.shootingStars == null || this.shootingStars.isEmpty()) {
            return;
        }
        ArrayList<UUID> starsToRemove = new ArrayList<UUID>();
        for (ShootingStar shootingStar : this.shootingStars.values()) {
            if (!shootingStar.render(poseStack, projectionMatrix)) continue;
            starsToRemove.add(shootingStar.starId);
        }
        starsToRemove.forEach(this.shootingStars::remove);
    }

    private void renderStars(class_638 level, float partialTick, class_4587 poseStack, Matrix4f projectionMatrix, Runnable fogCallback, float nightAngle) {
        float starsAngle;
        float starLight = level.method_23787(partialTick) * (1.0f - level.method_8430(partialTick));
        if (this.properties.stars().vanilla()) {
            if (starLight > 0.0f) {
                RenderSystem.setShaderColor((float)starLight, (float)starLight, (float)starLight, (float)starLight);
                class_758.method_23792();
                this.starBuffer.method_1353();
                this.starBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
                class_291.method_1354();
            }
            return;
        }
        float f = starsAngle = !this.properties.stars().movingStars() ? -90.0f : nightAngle;
        if (this.properties.stars().allDaysVisible()) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.setShaderColor((float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle);
        } else if (starLight > 0.2f) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.setShaderColor((float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle);
        }
        if (this.properties.fog().booleanValue()) {
            fogCallback.run();
        }
    }

    public Boolean shouldRemoveCloud() {
        return this.properties.cloud() == false;
    }

    public Boolean shouldRemoveSnowAndRain() {
        return this.properties.rain() == false;
    }

    public boolean isSkyRendered() {
        if (!this.properties.renderCondition().isPresent() || !this.properties.renderCondition().get().condition()) {
            return true;
        }
        SkyProperties.RenderCondition condition = this.properties.renderCondition().get();
        class_3218 level = this.getServerLevel();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || level == null) {
            return false;
        }
        if (condition.biomes().isPresent()) {
            return level.method_23753(player.method_23312()).method_40220(condition.biomes().get());
        }
        if (condition.biome().isPresent()) {
            return level.method_23753(player.method_23312()).method_40225(condition.biome().get());
        }
        return true;
    }

    private class_3218 getServerLevel() {
        class_310 minecraft = class_310.method_1551();
        class_1132 integratedServer = minecraft.method_1576();
        return integratedServer != null ? integratedServer.method_3847(minecraft.field_1687.method_27983()) : null;
    }
}

