/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.ambience.Screens.SpeakerContainer;
import vazkii.ambience.Screens.SpeakerScreen;
import vazkii.ambience.SongPicker;
import vazkii.ambience.Util.Handlers.SoundHandler;

@OnlyIn(value=Dist.CLIENT)
public class ScrollListWidget
extends ExtendedList<SoundEntry> {
    public ScrollListWidget(Minecraft mcIn, int width, int height, SpeakerContainer screenContainer, FontRenderer font) {
        super(mcIn, width - 52, 120, height / 2 - 71, height / 2 - 4, 15);
        this.setLeftPos(23);
        for (String sound : SoundHandler.SOUNDS) {
            if (sound.contains(".")) continue;
            SoundEntry soundEntry = new SoundEntry(sound, font);
            this.addEntry((AbstractList.AbstractListEntry)soundEntry);
            if (!sound.contains(SpeakerContainer.selectedSound)) continue;
            this.setSelected(soundEntry);
        }
        if (this.getSelected() != null) {
            this.centerScrollOn(this.getSelected());
        }
    }

    public ScrollListWidget(Minecraft mcIn, int width, int height, FontRenderer font, String selectedItem) {
        super(mcIn, width - 52, 120, height / 2 - 71, height / 2 - 4, 15);
        this.setLeftPos(23);
        for (Map.Entry<String, String[]> entry : SongPicker.areasMap.entrySet()) {
            if (entry.getKey().contains(".")) continue;
            SoundEntry soundEntry = new SoundEntry(entry.getKey(), font);
            this.addEntry((AbstractList.AbstractListEntry)soundEntry);
            if (!entry.getKey().contains(selectedItem)) continue;
            this.setSelected(soundEntry);
        }
        if (this.getSelected() != null) {
            this.centerScrollOn(this.getSelected());
        }
    }

    public void setSize(int width, int height) {
        this.updateSize(width - 50, 120, height / 2 - 71, height / 2 - 4);
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 17;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 15;
    }

    public void setSelected(@Nullable SoundEntry p_setSelected_1_) {
        super.setSelected((AbstractList.AbstractListEntry)p_setSelected_1_);
    }

    public void setSelected(String sound, FontRenderer font) {
        SoundEntry p_setSelected_1_ = new SoundEntry(sound, font);
        super.setSelected((AbstractList.AbstractListEntry)p_setSelected_1_);
    }

    protected void renderList(int p_renderList_1_, int p_renderList_2_, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        super.renderList(p_renderList_1_, p_renderList_2_, p_renderList_3_, p_renderList_4_, p_renderList_5_);
    }

    protected void renderHoleBackground(int p_renderHoleBackground_1_, int p_renderHoleBackground_2_, int p_renderHoleBackground_3_, int p_renderHoleBackground_4_) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(SpeakerScreen.textureBackground);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_((double)this.x0 + 100.0, (double)p_renderHoleBackground_2_, 0.0).func_225583_a_(0.0f, (float)p_renderHoleBackground_2_ / 153.0f).func_225586_a_(255, 255, 255, p_renderHoleBackground_4_).func_181675_d();
        bufferbuilder.func_225582_a_((double)(this.x0 + this.width) - 126.0, (double)p_renderHoleBackground_2_, 0.0).func_225583_a_((float)this.width / 600.0f, (float)p_renderHoleBackground_2_ / 153.0f).func_225586_a_(255, 255, 255, p_renderHoleBackground_4_).func_181675_d();
        bufferbuilder.func_225582_a_((double)(this.x0 + this.width) - 126.0, (double)p_renderHoleBackground_1_, 0.0).func_225583_a_((float)this.width / 600.0f, (float)p_renderHoleBackground_1_ / 153.0f).func_225586_a_(255, 255, 255, p_renderHoleBackground_3_).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.x0 + 100.0, (double)p_renderHoleBackground_1_, 0.0).func_225583_a_(0.0f, (float)p_renderHoleBackground_1_ / 153.0f).func_225586_a_(255, 255, 255, p_renderHoleBackground_3_).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void renderDecorations(int p_renderDecorations_1_, int p_renderDecorations_2_) {
        super.renderDecorations(p_renderDecorations_1_, p_renderDecorations_2_);
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        int i = this.getScrollbarPosition();
        int j = i + 6;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = 5;
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(k, l, tessellator);
        }
        this.renderList(k, l, p_render_1_, p_render_2_, p_render_3_);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        int i1 = 4;
        int j1 = this.getMaxScroll();
        if (j1 > 0) {
            int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
            int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
            if (l1 < this.y0) {
                l1 = this.y0;
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        this.renderDecorations(p_render_1_, p_render_2_);
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return super.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    protected void renderBackground() {
    }

    protected boolean isFocused() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class SoundEntry
    extends ExtendedList.AbstractListEntry<SoundEntry> {
        private final String sound;
        private final FontRenderer font;

        public SoundEntry(String sound, FontRenderer font) {
            this.sound = sound;
            this.font = font;
        }

        public void render(int p_render_1_, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
            this.font.func_78275_b(true);
            ScrollListWidget.this.drawCenteredString(this.font, this.sound, ScrollListWidget.this.width / 2 + 20, p_render_2_ + 1, 0xFFFFFF);
            this.font.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135035_b());
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (p_mouseClicked_5_ == 0) {
                this.setSelected();
                return true;
            }
            return false;
        }

        private void setSelected() {
            ScrollListWidget.this.setSelected(this);
        }

        public String getText() {
            return this.sound;
        }
    }
}

