/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.Util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import vazkii.ambience.World.Biomes.Area;

public class WorldData
extends WorldSavedData
implements Supplier {
    static final String key = "ambience";
    public DimensionSavedDataManager storage;
    public List<Area> listAreas = new ArrayList<Area>();
    private CompoundNBT data = new CompoundNBT();

    public WorldData(String name) {
        super(name);
    }

    public WorldData() {
        super(key);
    }

    public List<Area> getAreas() {
        return this.listAreas;
    }

    public void addArea(Area parArea) {
        this.listAreas.add(parArea);
        this.func_76185_a();
    }

    public void removeArea(Area parArea) {
        for (Area area : this.listAreas) {
            if (area.getID() != parArea.getID()) continue;
            this.listAreas.remove(area);
            break;
        }
        this.func_76185_a();
    }

    public void editArea(Area parArea) {
        int index = 0;
        for (Area area : this.listAreas) {
            if (area.getID() == parArea.getID()) {
                this.listAreas.set(index, parArea);
                break;
            }
            ++index;
        }
        this.func_76185_a();
    }

    public void clearAreas() {
        this.listAreas.clear();
        this.func_76185_a();
    }

    @Nullable
    public Area getAreaByName(String parName) {
        if (this.listAreas.size() > 0) {
            for (Area area : this.listAreas) {
                if (!area.getName().equals(parName)) continue;
                return area;
            }
        }
        return null;
    }

    public WorldData GetArasforWorld(ServerWorld world) {
        DimensionSavedDataManager storage = world.func_217481_x();
        WorldData data = (WorldData)world.func_217481_x().func_215752_a(() -> new WorldData(), key);
        storage.func_215757_a((WorldSavedData)data);
        this.listAreas = data.listAreas;
        return data;
    }

    public void saveData() {
        ListNBT tagList = new ListNBT();
        Iterator<Area> iteratorArea = this.listAreas.iterator();
        while (iteratorArea.hasNext()) {
            CompoundNBT tagCompound = new CompoundNBT();
            Area area = iteratorArea.next();
            tagCompound.func_218657_a("Pos", (INBT)area.getPosListTag());
            tagCompound.func_74778_a("Name", area.getName());
            tagCompound.func_74768_a("D", area.getDimension());
            tagCompound.func_74768_a("ID", area.getID());
            tagCompound.func_74757_a("playNight", area.isPlayatNight());
            tagCompound.func_74757_a("instP", area.isInstantPlay());
            tagCompound.func_74768_a("RedstoneStrength", area.getRedstoneStrength());
            tagList.add((Object)tagCompound);
        }
        this.data.func_218657_a("Areas", (INBT)tagList);
        this.func_76185_a();
    }

    public static CompoundNBT SerializeThis(List<Area> data) {
        CompoundNBT nbt = new CompoundNBT();
        int count = 0;
        Iterator<Area> iteratorArea = data.iterator();
        while (iteratorArea.hasNext()) {
            CompoundNBT tagCompound = new CompoundNBT();
            Area area = iteratorArea.next();
            tagCompound.func_218657_a("Pos", (INBT)area.getPosListTag());
            tagCompound.func_74778_a("Name", area.getName());
            tagCompound.func_74768_a("D", area.getDimension());
            tagCompound.func_74768_a("ID", area.getID());
            tagCompound.func_74757_a("playNight", area.isPlayatNight());
            tagCompound.func_74757_a("instP", area.isInstantPlay());
            tagCompound.func_74768_a("RedstoneStrength", area.getRedstoneStrength());
            nbt.func_218657_a("Area" + count++, (INBT)tagCompound);
        }
        nbt.func_74768_a("lenght", count);
        return nbt;
    }

    public Object get() {
        return null;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.data = nbt.func_74775_l(key);
        this.listAreas.clear();
        for (CompoundNBT areaCompound : this.data.func_150295_c("Areas", 10)) {
            Area area = new Area(areaCompound.func_74779_i("Name"));
            area.setDimension(areaCompound.func_74762_e("D"));
            area.setID(areaCompound.func_74762_e("ID"));
            area.setPlayAtNight(areaCompound.func_74767_n("playNight"));
            area.setInstantPlay(areaCompound.func_74767_n("instP"));
            area.setRedstoneStrength(areaCompound.func_74762_e("RedstoneStrength"));
            CompoundNBT tagListPos = areaCompound.func_74775_l("Pos");
            Vec3d pos1 = new Vec3d(tagListPos.func_74769_h("x1"), tagListPos.func_74769_h("y1"), tagListPos.func_74769_h("z1"));
            area.setPos1(pos1);
            Vec3d pos2 = new Vec3d(tagListPos.func_74769_h("x2"), tagListPos.func_74769_h("y2"), tagListPos.func_74769_h("z2"));
            area.setPos1(pos1);
            area.setPos2(pos2);
            this.listAreas.add(area);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_218657_a(key, (INBT)this.data);
        return compound;
    }
}

