/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.Util.Handlers;

import java.io.File;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import vazkii.ambience.Ambience;
import vazkii.ambience.AmbienceConfig;
import vazkii.ambience.NilMusicTicker;
import vazkii.ambience.PlayerThread;
import vazkii.ambience.SongLoader;
import vazkii.ambience.SongPicker;
import vazkii.ambience.Util.RegistryHandler;
import vazkii.ambience.Util.Utils;
import vazkii.ambience.items.Ocarina;
import vazkii.ambience.network.AmbiencePackageHandler;
import vazkii.ambience.network.MyMessage;
import vazkii.ambience.network.OcarinaMessage;
import vazkii.ambience.network.OcarinaPackageHandler;
import vazkii.ambience.render.CinematicRender;
import vazkii.ambience.render.HornRender;
import vazkii.ambience.render.SelectionBoxRenderer;

@Mod.EventBusSubscriber(modid="ambience", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class EventHandlers {
    public static String currentSong;
    public static String nextSong;
    private static final int WAIT_DURATION = 25;
    public static int FADE_DURATION;
    public static final int SILENCE_DURATION = 5;
    public static int waitTick;
    public static int fadeOutTicks;
    public static int fadeInTicks;
    public static boolean fadeIn;
    public static int silenceTicks;
    private static float masterAudioCount;
    public static KeyBinding[] keyBindings;
    public static float oldVolume;
    public static CinematicRender cinematic;
    static boolean playingAdvancement;
    static int adcancementTimer;
    static PlayerThread thread2;
    static String AdvancementSong;
    static int songLenght;
    public static boolean key_released;
    static int oldCameraMode;
    private static float zoomCount;
    public static float zoomAmount;
    public static double zoomSpeed;
    public static double oldFOV;
    public static boolean cameraChanged;
    public static boolean show;

    public static void onAdvancement() {
        if (SongPicker.eventMap.containsKey("advancement") & !playingAdvancement) {
            thread2 = new PlayerThread();
            Random rand = new Random();
            String[] songChoices = SongPicker.eventMap.get("advancement");
            if (songChoices != null & !playingAdvancement && songChoices.length > 0) {
                playingAdvancement = true;
                AdvancementSong = songChoices[rand.nextInt(songChoices.length)];
                EventHandlers.getSongLenght();
                thread2.play(AdvancementSong);
            }
        }
    }

    private static void getSongLenght() {
        File f = new File(Ambience.ambienceDir + "\\music\\", AdvancementSong + ".mp3");
        if (f.isFile()) {
            try {
                AudioFile af = AudioFileIO.read(f);
                AudioHeader ah = af.getAudioHeader();
                songLenght = ah.getTrackLength();
            }
            catch (Exception exception) {}
        } else {
            songLenght = 0;
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/simple_dungeon"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("ambience:chests/simple_dungeon"))).func_216044_b());
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/pillager_outpost"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("ambience:chests/pillager_outpost"))).func_216044_b());
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/underwater_ruin_big"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("ambience:chests/underwater_ruin_big"))).func_216044_b());
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/buried_treasure"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("ambience:chests/buried_treasure"))).func_216044_b());
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/abandoned_mineshaft"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("ambience:chests/abandoned_mineshaft"))).func_216044_b());
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/desert_pyramid"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("ambience:chests/desert_pyramid"))).func_216044_b());
        }
    }

    public static void playInstant() {
        fadeOutTicks = FADE_DURATION;
        silenceTicks = 5;
        waitTick = 0;
        Ambience.instantPlaying = true;
        Ambience.thread.setGain(PlayerThread.fadeGains[0]);
        fadeIn = false;
    }

    public static void registerKeyBindings() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        oldVolume = settings.func_186711_a(SoundCategory.MASTER);
        keyBindings = new KeyBinding[12];
        EventHandlers.keyBindings[0] = new KeyBinding("Options.Reload", 80, "Ambience");
        EventHandlers.keyBindings[1] = new KeyBinding("Force Play", 79, "Ambience");
        EventHandlers.keyBindings[2] = new KeyBinding("Options.Shortcut1", 97, "Ambience");
        EventHandlers.keyBindings[3] = new KeyBinding("Options.Shortcut2", 97, "Ambience");
        EventHandlers.keyBindings[4] = new KeyBinding("Options.Shortcut3", 98, "Ambience");
        EventHandlers.keyBindings[5] = new KeyBinding("Options.Shortcut4", 99, "Ambience");
        EventHandlers.keyBindings[6] = new KeyBinding("Options.Shortcut5", 100, "Ambience");
        EventHandlers.keyBindings[7] = new KeyBinding("Options.Ocarina1", 265, "Ambience");
        EventHandlers.keyBindings[8] = new KeyBinding("Options.Ocarina2", 264, "Ambience");
        EventHandlers.keyBindings[9] = new KeyBinding("Options.Ocarina3", 262, "Ambience");
        EventHandlers.keyBindings[10] = new KeyBinding("Options.Ocarina4", 263, "Ambience");
        EventHandlers.keyBindings[11] = new KeyBinding("Options.Ocarina5", 345, "Ambience");
        for (int i = 0; i < keyBindings.length; ++i) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBindings[i]);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent e) {
        if (e.isCanceled()) {
            return;
        }
        if (e.getFace() != null) {
            Block juckebox;
            ItemStack item = e.getPlayer().func_184586_b(e.getHand());
            if (item.func_77973_b() instanceof Ocarina) {
                e.setCanceled(true);
            }
            if (e.getPlayer().func_70613_aW() && (juckebox = e.getPlayer().field_70170_p.func_180495_p(e.getPos()).func_177230_c()) instanceof JukeboxBlock && Ambience.playingJuckebox) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a("playingJuckebox", false);
                AmbiencePackageHandler.sendToServer(new MyMessage(nbt));
                SongPicker.lastPlayerPos = e.getPlayer().func_180425_c();
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (Ambience.thread == null) {
            return;
        }
        if (playingAdvancement && ++adcancementTimer > songLenght * 40) {
            adcancementTimer = 0;
            playingAdvancement = false;
            thread2.forceKill();
        }
        if (event.phase == TickEvent.Phase.END) {
            String songs = SongPicker.getSongsString();
            String song = null;
            if (songs != null) {
                if (nextSong == null || !songs.contains(nextSong)) {
                    while ((song = SongPicker.getRandomSong()).equals(currentSong) && songs.contains(",")) {
                    }
                } else {
                    song = nextSong;
                }
            }
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            if (!Minecraft.func_71410_x().func_195544_aj()) {
                if (masterAudioCount >= 0.1f) {
                    masterAudioCount -= 0.05f;
                }
                if (((Boolean)AmbienceConfig.COMMON.lostFocusEnabled.get()).booleanValue()) {
                    settings.func_186712_a(SoundCategory.MASTER, masterAudioCount);
                }
            } else if (((Boolean)AmbienceConfig.COMMON.lostFocusEnabled.get()).booleanValue() && masterAudioCount <= Utils.clamp(oldVolume, 0.1f, 1.0f)) {
                settings.func_186712_a(SoundCategory.MASTER, masterAudioCount += 0.05f);
            }
            if (fadeIn) {
                Ambience.thread.setGain(PlayerThread.fadeGains[fadeInTicks]);
            }
            if (PlayerThread.gain < 0.0f & fadeInTicks > 0) {
                --fadeInTicks;
                fadeIn = true;
            } else {
                fadeIn = false;
                fadeInTicks = FADE_DURATION - 1;
            }
            if (songs != null && (!songs.equals(PlayerThread.currentSongChoices) || song == null && PlayerThread.currentSong != null || !Ambience.thread.playing)) {
                if (nextSong != null && nextSong.equals(song)) {
                    --waitTick;
                }
                if (!song.equals(currentSong)) {
                    if (currentSong != null && PlayerThread.currentSong != null && !PlayerThread.currentSong.equals(song) && songs.equals(PlayerThread.currentSongChoices)) {
                        currentSong = PlayerThread.currentSong;
                    } else {
                        nextSong = song;
                    }
                } else if (nextSong != null && !songs.contains(nextSong)) {
                    nextSong = null;
                }
                if (waitTick <= 0) {
                    if (PlayerThread.currentSong == null) {
                        currentSong = nextSong;
                        nextSong = null;
                        PlayerThread.currentSongChoices = songs;
                        EventHandlers.changeSongTo(song);
                        fadeOutTicks = 0;
                        waitTick = 25;
                    } else if (fadeOutTicks < FADE_DURATION) {
                        Ambience.thread.setGain(PlayerThread.fadeGains[fadeOutTicks]);
                        ++fadeOutTicks;
                        silenceTicks = 0;
                    } else if (silenceTicks < 5) {
                        ++silenceTicks;
                    } else {
                        nextSong = null;
                        PlayerThread.currentSongChoices = songs;
                        EventHandlers.changeSongTo(song);
                        fadeOutTicks = 0;
                        waitTick = 25;
                    }
                }
            } else {
                nextSong = null;
                silenceTicks = 0;
                fadeOutTicks = 0;
                waitTick = 25;
            }
            if (Ambience.thread != null) {
                Ambience.thread.setRealGain();
            }
        }
        if (((Ocarina)RegistryHandler.Ocarina.get()).playing) {
            if (!cameraChanged) {
                cameraChanged = true;
                oldCameraMode = Minecraft.func_71410_x().field_71474_y.field_74320_O;
                oldFOV = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            }
            EventHandlers.setCameraMode(2);
        }
    }

    @SubscribeEvent
    public static void keyEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().func_195544_aj()) {
            NilMusicTicker ticker;
            Minecraft mc;
            if (keyBindings[0].func_151468_f()) {
                SongPicker.reset();
                SongLoader.loadFrom(Ambience.ambienceDir);
                mc = Minecraft.func_71410_x();
                ticker = new NilMusicTicker(mc);
                ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)mc, (Object)((Object)ticker), (String)"field_147126_aw");
                SystemToast.func_193657_a((ToastGui)mc.func_193033_an(), (SystemToast.Type)SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TranslationTextComponent("Ambience.ReloadTitle", new Object[0]), (ITextComponent)new TranslationTextComponent("Ambience.Reload", new Object[0]));
            }
            if (keyBindings[1].func_151468_f()) {
                Ambience.thread.forceKill();
                Ambience.thread.run();
                SongLoader.loadFrom(Ambience.ambienceDir);
                if (SongLoader.enabled) {
                    Ambience.thread = new PlayerThread();
                }
                mc = Minecraft.func_71410_x();
                ticker = new NilMusicTicker(mc);
                ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)mc, (Object)((Object)ticker), (String)"field_147126_aw");
                SystemToast.func_193657_a((ToastGui)mc.func_193033_an(), (SystemToast.Type)SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TranslationTextComponent("Ambience.ReloadTitle", new Object[0]), (ITextComponent)new TranslationTextComponent("Ambience.Force", new Object[0]));
            }
            if (keyBindings[2].func_151468_f()) {
                EventHandlers.ToggleForcePlay(0);
            }
            if (keyBindings[3].func_151468_f()) {
                EventHandlers.ToggleForcePlay(1);
            }
            if (keyBindings[4].func_151468_f()) {
                EventHandlers.ToggleForcePlay(2);
            }
            if (keyBindings[5].func_151468_f()) {
                EventHandlers.ToggleForcePlay(3);
            }
            if (keyBindings[6].func_151468_f()) {
                EventHandlers.ToggleForcePlay(4);
            }
            if (keyBindings[7].func_151468_f()) {
                EventHandlers.addPressedKey(1);
            } else {
                EventHandlers.removePressedKey(1);
            }
            if (keyBindings[8].func_151468_f()) {
                EventHandlers.addPressedKey(2);
            } else {
                EventHandlers.removePressedKey(2);
            }
            if (keyBindings[9].func_151468_f()) {
                EventHandlers.addPressedKey(3);
            } else {
                EventHandlers.removePressedKey(3);
            }
            if (keyBindings[10].func_151468_f()) {
                EventHandlers.addPressedKey(4);
            } else {
                EventHandlers.removePressedKey(4);
            }
            if (keyBindings[11].func_151468_f()) {
                EventHandlers.addPressedKey(5);
            } else {
                EventHandlers.removePressedKey(5);
            }
        }
    }

    private static void addPressedKey(int key) {
        Ocarina Ocarina2 = (Ocarina)RegistryHandler.Ocarina.get();
        Ocarina2.key_id = key;
        if (!Ocarina2.actualPressedKeys.contains(Ocarina2.key_id) | Ocarina2.actualPressedKeys.size() == 0) {
            Ocarina2.actualPressedKeys.add(Ocarina2.key_id);
            Ocarina2.addPressedKey(key);
        }
        EventHandlers.syncKeysServer(key);
    }

    private static void removePressedKey(int key) {
        Ocarina Ocarina2 = (Ocarina)RegistryHandler.Ocarina.get();
        if (Ocarina2.actualPressedKeys.size() > 0 && Ocarina2.actualPressedKeys.contains(key)) {
            Ocarina2.actualPressedKeys.remove((Object)key);
        }
    }

    private static void syncKeysServer(int key) {
        Ocarina Ocarina2 = (Ocarina)RegistryHandler.Ocarina.get();
        String keys = "";
        for (Integer actualKey : Ocarina2.actualPressedKeys) {
            keys = keys + actualKey + ",";
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("keyPressed", key);
        nbt.func_74778_a("actualPressedKeys", keys);
        nbt.func_74757_a("playing", Ocarina2.playing);
        nbt.func_74757_a("runningCommand", Ocarina2.runningCommand);
        OcarinaPackageHandler.sendToServer(new OcarinaMessage(nbt));
    }

    private static void setCameraMode(int mode) {
        Minecraft.func_71410_x().field_71474_y.field_74320_O = mode;
    }

    @SubscribeEvent
    public static void onFOVModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        if (((Ocarina)RegistryHandler.Ocarina.get()).playing) {
            ItemStack item;
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack itemStack = item = mc.field_71439_g.func_184586_b(Hand.MAIN_HAND) == null ? mc.field_71439_g.func_184586_b(Hand.OFF_HAND) : mc.field_71439_g.func_184586_b(Hand.MAIN_HAND);
            if (item != null && item.func_77973_b() instanceof Ocarina) {
                Minecraft.func_71410_x().field_71474_y.field_74326_T = true;
                if (zoomCount > zoomAmount && (zoomCount = (float)((double)zoomCount - zoomSpeed)) < zoomAmount) {
                    zoomCount = zoomAmount;
                }
                event.setFOV((double)zoomCount);
                return;
            }
            EventHandlers.setCameraMode(oldCameraMode);
        }
        if (zoomCount != 70.0f) {
            Minecraft.func_71410_x().field_71474_y.field_74326_T = false;
            if ((double)zoomCount < event.getFOV() && (double)(zoomCount = (float)((double)zoomCount + zoomSpeed)) > event.getFOV()) {
                zoomCount = (float)event.getFOV();
            }
            event.setFOV((double)zoomCount);
            if ((double)zoomCount > oldFOV - 1.0) {
                Ocarina Ocarina2 = (Ocarina)RegistryHandler.Ocarina.get();
                EventHandlers.setCameraMode(oldCameraMode);
                cameraChanged = false;
                Ocarina2.pressedKeys.clear();
                Ocarina2.old_key_id = -1;
                Ocarina2.runningCommand = false;
                Ocarina2.songName = "";
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a("resetVariables", true);
                OcarinaPackageHandler.sendToServer(new OcarinaMessage(nbt));
            }
        }
    }

    private static void ToggleForcePlay(int id) {
        Minecraft mc = Minecraft.func_71410_x();
        Ambience.forcePlay = Ambience.forcePlay != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
        SongPicker.forcePlayID = id;
        if (mc.field_71439_g.func_225608_bj_()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("forcedPlay", Ambience.forcePlay.booleanValue());
            nbt.func_74768_a("forcedPlayID", SongPicker.forcePlayID);
            AmbiencePackageHandler.sendToServer(new MyMessage(nbt));
        }
    }

    @SubscribeEvent
    public static void onBackgroundMusic(PlaySoundEvent event) {
        if (SongLoader.enabled) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                Ambience.dimension = world.field_73011_w.func_186058_p().func_186068_a();
            }
            if (event.getSound().func_184365_d() == SoundCategory.MUSIC) {
                if (Ambience.dimension >= -1 & Ambience.dimension <= 1 | Ambience.overideBackMusicDimension) {
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    event.setResultSound(null);
                }
            } else if (event.getSound().func_184365_d() == SoundCategory.RECORDS) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a("playingJuckebox", true);
                AmbiencePackageHandler.sendToServer(new MyMessage(nbt));
            }
        }
    }

    public static void changeSongTo(String song) {
        if (song == "null") {
            Ambience.thread.playing = false;
            Ambience.thread.setGain(0.0f);
        }
        currentSong = song;
        Ambience.thread.play(song);
        Ambience.thread.setGain(PlayerThread.fadeGains[fadeInTicks]);
        if (!Ambience.attacked.booleanValue()) {
            fadeInTicks = FADE_DURATION - 1;
            fadeIn = true;
        }
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        ClientPlayerEntity currentplayer = Minecraft.func_71410_x().field_71439_g;
        if (Ambience.previewArea != null && Ambience.previewArea.getPos1() != null & Ambience.previewArea.getPos2() != null && Ambience.previewArea.getPos1().field_72450_a != 0.0 & Ambience.previewArea.getPos1().field_72448_b != 0.0 & Ambience.previewArea.getPos1().field_72449_c != 0.0 & Ambience.previewArea.getPos2().field_72450_a != 0.0 & Ambience.previewArea.getPos2().field_72448_b != 0.0 & Ambience.previewArea.getPos2().field_72449_c != 0.0) {
            SelectionBoxRenderer.drawBoundingBox(currentplayer.func_174791_d(), Ambience.previewArea.getPos1(), Ambience.previewArea.getPos2(), true, 2.0f, event.getPartialTicks(), event);
        }
        HornRender.drawBoundingBox(currentplayer.func_213303_ch(), event.getPartialTicks(), event, currentplayer.field_70170_p, (PlayerEntity)currentplayer);
    }

    @SubscribeEvent
    public static void onOverlayRender(RenderGameOverlayEvent.Post event) {
        Ocarina Ocarina2 = (Ocarina)RegistryHandler.Ocarina.get();
        Ocarina2.renderFX(event, zoomCount, zoomAmount, zoomSpeed, 20.0f);
        cinematic.renderFX(event, zoomCount, zoomAmount, 0.7f, 20.0f);
    }

    @SubscribeEvent
    public static void firstRender(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        int py = (int)Math.abs(zoomCount - 70.0f);
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR & py > 10) {
            event.setCanceled(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR & Math.abs(CinematicRender.fx_zoomCount - 70.0f) > 10.0f) {
            event.setCanceled(true);
        }
        if (!mc.func_195544_aj() || mc.field_71439_g == null) {
            return;
        }
        if (!show & Ambience.showUpdateNotification) {
            show = true;
            for (ModInfo container : ModList.get().getMods()) {
                VersionChecker.CheckResult res;
                if (container.getModId().startsWith("mcp") || container.getModId().equalsIgnoreCase("mcp") || container.getModId().equalsIgnoreCase("FML") || container.getModId().equalsIgnoreCase("Forge") || ((res = VersionChecker.getResult((IModInfo)container)) == null || res.status == VersionChecker.Status.PENDING || res.status != VersionChecker.Status.BETA_OUTDATED) && res.status != VersionChecker.Status.OUTDATED) continue;
                String comp = "\u00a7eNew version (\u00a77" + res.target + "\u00a7e) for\u00a7a " + container.getDisplayName() + " \u00a7eis available for download ";
                mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(comp));
            }
        }
    }

    static {
        FADE_DURATION = (Integer)AmbienceConfig.COMMON.fadeDuration.get();
        waitTick = 25;
        fadeOutTicks = FADE_DURATION;
        fadeInTicks = FADE_DURATION - 1;
        fadeIn = false;
        silenceTicks = 0;
        masterAudioCount = 0.0f;
        cinematic = new CinematicRender();
        playingAdvancement = false;
        adcancementTimer = 0;
        AdvancementSong = "";
        oldCameraMode = 0;
        zoomCount = 70.0f;
        zoomAmount = 30.0f;
        zoomSpeed = 0.5;
        oldFOV = 0.0;
        cameraChanged = false;
        show = false;
    }
}

