/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.ambience.PlayerThread;
import vazkii.ambience.Util.Handlers.EventHandlers;

@Mod.EventBusSubscriber(modid="ambience", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AmbienceConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
    }

    @SubscribeEvent
    public static void onFileChanged(ModConfig.Reloading event) {
        ModConfig configs = event.getConfig();
        if (configs.getConfigData().get("Ambience.Fade_Duration") != null) {
            AmbienceConfig.COMMON.fadeDuration.set(configs.getConfigData().get("Ambience.Fade_Duration"));
            AmbienceConfig.COMMON.sunsong_enabled.set(configs.getConfigData().get("Ambience.Ocarina.Sun_Song"));
            AmbienceConfig.COMMON.songofstorms_enabled.set(configs.getConfigData().get("Ambience.Ocarina.Song_of_Storms"));
            AmbienceConfig.COMMON.bolerooffire_enabled.set(configs.getConfigData().get("Ambience.Ocarina.Fire_Song"));
            AmbienceConfig.COMMON.horsesong_enabled.set(configs.getConfigData().get("Ambience.Ocarina.Horse_Song"));
            AmbienceConfig.COMMON.lostFocusEnabled.set(configs.getConfigData().get("Ambience.Lost_Focus_FadeOut"));
            AmbienceConfig.COMMON.structuresCinematic.set(configs.getConfigData().get("Ambience.Structures_Cinematic"));
            EventHandlers.fadeOutTicks = EventHandlers.FADE_DURATION = ((Integer)AmbienceConfig.COMMON.fadeDuration.get()).intValue();
            EventHandlers.fadeInTicks = EventHandlers.FADE_DURATION - 1;
            PlayerThread.fadeGains = new float[EventHandlers.FADE_DURATION];
            float totaldiff = -50.0f;
            float diff = totaldiff / (float)PlayerThread.fadeGains.length;
            for (int i = 0; i < PlayerThread.fadeGains.length; ++i) {
                PlayerThread.fadeGains[i] = 0.0f + diff * (float)i;
            }
        }
        System.out.println("Configs File Changed");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue sunsong_enabled;
        public final ForgeConfigSpec.BooleanValue songofstorms_enabled;
        public final ForgeConfigSpec.BooleanValue bolerooffire_enabled;
        public final ForgeConfigSpec.BooleanValue horsesong_enabled;
        public final ForgeConfigSpec.BooleanValue preludeoflight_enabled;
        public final ForgeConfigSpec.BooleanValue serenadeofwater;
        public final ForgeConfigSpec.BooleanValue minuetofforest;
        public final ForgeConfigSpec.BooleanValue lostFocusEnabled;
        public final ForgeConfigSpec.BooleanValue structuresCinematic;
        public final ForgeConfigSpec.IntValue fadeDuration;
        public final ForgeConfigSpec.IntValue attackedDistance;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Ambience Mod Configurations").push("Ambience");
            this.fadeDuration = builder.comment("Defines the sound volume fade in/out duration [Default:25,Range:1~500]").worldRestart().defineInRange("Fade_Duration", 25, 1, 500);
            this.lostFocusEnabled = builder.comment("Fade Out Sound Volume on Game Lost Focus[Default:true]").worldRestart().define("Lost_Focus_FadeOut", true);
            this.structuresCinematic = builder.comment("Show a cinematic enty with a image on enter a structure[Default:true]").worldRestart().define("Structures_Cinematic", true);
            this.attackedDistance = builder.comment("Defines the distance in blocks between the player and hostile mobs to determine if still in combat or not [Default:16,Range:10~128]").worldRestart().defineInRange("In_Battle_Distance", 16, 10, 128);
            builder.comment("Ocarina Configurations").push("Ocarina");
            this.sunsong_enabled = builder.comment("Enables or disables the Sun's Song [Default:true]").translation("ambience.configgui.sunsongenabled").worldRestart().define("Sun_Song", true);
            this.songofstorms_enabled = builder.comment("Enables or disables the Song of Storms [Default:true]").translation("ambience.configgui.songofstorms_enabled").worldRestart().define("Song_of_Storms", true);
            this.bolerooffire_enabled = builder.comment("Enables or disables the Bolero of Fire Song [Default:true]").translation("ambience.configgui.bolerooffire_enabled").worldRestart().define("Fire_Song", true);
            this.horsesong_enabled = builder.comment("Enables or disables the Horse's Song [Default:true]").translation("ambience.configgui.horsesong_enabled").worldRestart().define("Horse_Song", true);
            this.preludeoflight_enabled = builder.comment("Enables or disables the Prelude of Light Song [Default:true]").translation("ambience.configgui.preludeoflight_enabled").worldRestart().define("Prelude_of_light_Song", true);
            this.serenadeofwater = builder.comment("Enables or disables the Serenade of Water Song [Default:true]").translation("ambience.configgui.serenadeofwater_enabled").worldRestart().define("Serenade_of_Water_Song", true);
            this.minuetofforest = builder.comment("Enables or disables the Minuet of Forest Song [Default:true]").translation("ambience.configgui.horsesong_enabled").worldRestart().define("Minuet_of_Forest_Song", true);
            builder.pop(2);
        }
    }
}

