/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataSeekTable;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class FlacTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private VorbisCommentReader vorbisCommentReader = new VorbisCommentReader();

    public FlacTag read(Path path) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
            FlacTag flacTag;
            FlacStreamReader flacStream = new FlacStreamReader(fc, path.toString() + " ");
            flacStream.findStream();
            VorbisCommentTag tag = null;
            ArrayList<MetadataBlockDataPicture> images = new ArrayList<MetadataBlockDataPicture>();
            boolean isLastBlock = false;
            while (!isLastBlock) {
                MetadataBlockHeader mbh;
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config(path + " Looking for MetaBlockHeader at:" + fc.position());
                }
                if ((mbh = MetadataBlockHeader.readHeader(fc)) == null) break;
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config(path + " Reading MetadataBlockHeader:" + mbh.toString() + " ending at " + fc.position());
                }
                if (mbh.getBlockType() != null) {
                    switch (mbh.getBlockType()) {
                        case VORBIS_COMMENT: {
                            ByteBuffer commentHeaderRawPacket = ByteBuffer.allocate(mbh.getDataLength());
                            fc.read(commentHeaderRawPacket);
                            tag = this.vorbisCommentReader.read(commentHeaderRawPacket.array(), false);
                            break;
                        }
                        case PICTURE: {
                            try {
                                MetadataBlockDataPicture mbdp = new MetadataBlockDataPicture(mbh, fc);
                                images.add(mbdp);
                            }
                            catch (IOException ioe) {
                                logger.warning(path + "Unable to read picture metablock, ignoring:" + ioe.getMessage());
                            }
                            catch (InvalidFrameException ive) {
                                logger.warning(path + "Unable to read picture metablock, ignoring" + ive.getMessage());
                            }
                            break;
                        }
                        case SEEKTABLE: {
                            try {
                                long pos = fc.position();
                                MetadataBlockDataSeekTable mbdp = new MetadataBlockDataSeekTable(mbh, fc);
                                fc.position(pos + (long)mbh.getDataLength());
                            }
                            catch (IOException ioe) {
                                logger.warning(path + "Unable to readseek metablock, ignoring:" + ioe.getMessage());
                            }
                            break;
                        }
                        default: {
                            if (logger.isLoggable(Level.CONFIG)) {
                                logger.config(path + "Ignoring MetadataBlock:" + (Object)((Object)mbh.getBlockType()));
                            }
                            fc.position(fc.position() + (long)mbh.getDataLength());
                        }
                    }
                }
                isLastBlock = mbh.isLastBlock();
            }
            logger.config("Audio should start at:" + Hex.asHex(fc.position()));
            if (tag == null) {
                tag = VorbisCommentTag.createNewTag();
            }
            FlacTag flacTag2 = flacTag = new FlacTag(tag, images);
            return flacTag2;
        }
    }
}

