/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.logging.helper.ExplosionLogHelper;
import dev.dubhe.curtain.mixins.ExplosionAccessor;
import dev.dubhe.curtain.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class OptimizedExplosion {
    private static List<Entity> entitylist;
    private static Vec3 vec3dmem;
    private static long tickmem;
    public static int explosionSound;
    private static Object2DoubleOpenHashMap<Pair<Vec3, AABB>> densityCache;
    private static MutablePair<Vec3, AABB> pairMutable;
    private static Object2ObjectOpenHashMap<BlockPos, BlockState> stateCache;
    private static Object2ObjectOpenHashMap<BlockPos, FluidState> fluidCache;
    private static BlockPos.MutableBlockPos posMutable;
    private static ObjectOpenHashSet<BlockPos> affectedBlockPositionsSet;
    private static boolean firstRay;
    private static boolean rayCalcDone;
    private static ArrayList<Float> chances;
    private static BlockPos blastChanceLocation;

    public static void doExplosionA(Explosion e, ExplosionLogHelper eLogger) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        OptimizedExplosion.blastCalc(e);
        if (!CurtainRules.explosionNoBlockDamage) {
            rayCalcDone = false;
            firstRay = true;
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 0, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 15, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 0, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 15, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 0, 1, 14, 1, 14);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 15, 1, 14, 1, 14);
            stateCache.clear();
            fluidCache.clear();
            e.m_46081_().addAll(affectedBlockPositionsSet);
            affectedBlockPositionsSet.clear();
        }
        float f3 = eAccess.getRadius() * 2.0f;
        int k1 = Mth.m_14107_((double)(eAccess.getX() - (double)f3 - 1.0));
        int l1 = Mth.m_14107_((double)(eAccess.getX() + (double)f3 + 1.0));
        int i2 = Mth.m_14107_((double)(eAccess.getY() - (double)f3 - 1.0));
        int i1 = Mth.m_14107_((double)(eAccess.getY() + (double)f3 + 1.0));
        int j2 = Mth.m_14107_((double)(eAccess.getZ() - (double)f3 - 1.0));
        int j1 = Mth.m_14107_((double)(eAccess.getZ() + (double)f3 + 1.0));
        Vec3 vec3d = new Vec3(eAccess.getX(), eAccess.getY(), eAccess.getZ());
        if (vec3dmem == null || !vec3dmem.equals((Object)vec3d) || tickmem != eAccess.getLevel().m_46467_()) {
            vec3dmem = vec3d;
            tickmem = eAccess.getLevel().m_46467_();
            entitylist = eAccess.getLevel().m_45933_(null, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            explosionSound = 0;
        }
        ++explosionSound;
        Entity explodingEntity = eAccess.getSource();
        for (int k2 = 0; k2 < entitylist.size(); ++k2) {
            Player player;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = entitylist.get(k2);
            if (entity == explodingEntity) {
                OptimizedExplosion.removeFast(entitylist, k2);
                --k2;
                continue;
            }
            if (entity instanceof PrimedTnt && explodingEntity != null && entity.m_20185_() == explodingEntity.m_20185_() && entity.m_20186_() == explodingEntity.m_20186_() && entity.m_20189_() == explodingEntity.m_20189_()) {
                if (eLogger == null) continue;
                eLogger.onEntityImpacted(entity, new Vec3(0.0, -0.9923437498509884, 0.0));
                continue;
            }
            if (entity.m_6128_() || !((d12 = Math.sqrt(entity.m_20275_(eAccess.getX(), eAccess.getY(), eAccess.getZ())) / (double)f3) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - eAccess.getX()) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - eAccess.getY()) * d7 + (d9 = entity.m_20189_() - eAccess.getZ()) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            pairMutable.setLeft((Object)vec3d);
            pairMutable.setRight((Object)entity.m_20191_());
            double density = densityCache.getOrDefault(pairMutable, Double.MAX_VALUE);
            if (density == Double.MAX_VALUE) {
                Pair pair = Pair.of((Object)vec3d, (Object)entity.m_20191_());
                density = Explosion.m_46064_((Vec3)vec3d, (Entity)entity);
                densityCache.put((Object)pair, density);
            }
            double d10 = (1.0 - d12) * density;
            entity.m_6469_(e.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            if (eLogger != null) {
                eLogger.onEntityImpacted(entity, new Vec3(d5 * d11, d7 * d11, d9 * d11));
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            e.m_46078_().put(player, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
        densityCache.clear();
    }

    public static void doExplosionB(Explosion e, boolean spawnParticles) {
        boolean damagesTerrain;
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        Level world = eAccess.getLevel();
        double posX = eAccess.getX();
        double posY = eAccess.getY();
        double posZ = eAccess.getZ();
        boolean bl = damagesTerrain = eAccess.getBlockInteraction() != Explosion.BlockInteraction.NONE;
        if (explosionSound < 100 || explosionSound % 100 == 0) {
            world.m_6263_(null, posX, posY, posZ, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            if (spawnParticles) {
                if (eAccess.getRadius() >= 2.0f && damagesTerrain) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, posX, posY, posZ, 1.0, 0.0, 0.0);
                } else {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, posX, posY, posZ, 1.0, 0.0, 0.0);
                }
            }
        }
        if (damagesTerrain) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            Util.m_214673_((ObjectArrayList)((ObjectArrayList)e.m_46081_()), (RandomSource)world.f_46441_);
            boolean dropFromExplosions = CurtainRules.xpFromExplosions || e.m_46079_() instanceof Player;
            for (BlockPos blockpos : e.m_46081_()) {
                BlockState state = world.m_8055_(blockpos);
                Block block = state.m_60734_();
                if (state.m_60767_() == Material.f_76296_) continue;
                if (block.m_6903_(e) && world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    BlockEntity blockEntity = state.m_155947_() ? world.m_7702_(blockpos) : null;
                    LootContext.Builder lootBuilder = new LootContext.Builder((ServerLevel)eAccess.getLevel()).m_230911_(eAccess.getLevel().f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockEntity).m_78984_(LootContextParams.f_81455_, (Object)eAccess.getSource());
                    if (eAccess.getBlockInteraction() == Explosion.BlockInteraction.DESTROY) {
                        lootBuilder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(eAccess.getRadius()));
                    }
                    state.m_222967_(serverLevel, blockpos, ItemStack.f_41583_, dropFromExplosions);
                    state.m_60724_(lootBuilder).forEach(itemStackx -> OptimizedExplosion.method_24023((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectArrayList, itemStackx, blockpos.m_7949_()));
                }
                world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
                block.m_7592_(world, blockpos, e);
            }
            objectArrayList.forEach(p -> Block.m_49840_((Level)world, (BlockPos)((BlockPos)p.getRight()), (ItemStack)((ItemStack)p.getLeft())));
        }
        if (eAccess.isFire()) {
            for (BlockPos blockpos1 : e.m_46081_()) {
                LevelChunk chunk = world.m_6325_(blockpos1.m_123341_() >> 4, blockpos1.m_123343_() >> 4);
                BlockPos down = blockpos1.m_6625_(1);
                if (eAccess.getRandom().m_188503_(3) != 0 || chunk.m_8055_(blockpos1).m_60767_() != Material.f_76296_ || !chunk.m_8055_(down).m_60804_((BlockGetter)world, down)) continue;
                world.m_46597_(blockpos1, Blocks.f_50083_.m_49966_());
            }
        }
    }

    private static void method_24023(ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, ItemStack itemStack, BlockPos blockPos) {
        int i = objectArrayList.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)objectArrayList.get(j);
            ItemStack itemStack2 = (ItemStack)pair.getLeft();
            if (!ItemEntity.m_32026_((ItemStack)itemStack2, (ItemStack)itemStack)) continue;
            ItemStack itemStack3 = ItemEntity.m_32029_((ItemStack)itemStack2, (ItemStack)itemStack, (int)16);
            objectArrayList.set(j, (Object)Pair.of((Object)itemStack3, (Object)((BlockPos)pair.getRight())));
            if (!itemStack.m_41619_()) continue;
            return;
        }
        objectArrayList.add((Object)Pair.of((Object)itemStack, (Object)blockPos));
    }

    private static void removeFast(List<Entity> lst, int index) {
        if (index < lst.size() - 1) {
            lst.set(index, lst.get(lst.size() - 1));
        }
        lst.remove(lst.size() - 1);
    }

    private static void rayCalcs(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        boolean first = true;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    float rand = eAccess.getLevel().f_46441_.m_188501_();
                    if (CurtainRules.tntRandomRange >= 0.0) {
                        rand = (float)CurtainRules.tntRandomRange;
                    }
                    double d4 = eAccess.getX();
                    double d6 = eAccess.getY();
                    double d8 = eAccess.getZ();
                    float f1 = 0.3f;
                    for (float f = eAccess.getRadius() * (0.7f + rand * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = OptimizedExplosion.containing(d4, d6, d8);
                        BlockState state = eAccess.getLevel().m_8055_(blockpos);
                        FluidState fluidState = eAccess.getLevel().m_6425_(blockpos);
                        if (state.m_60767_() != Material.f_76296_) {
                            float f2 = Math.max(state.m_60734_().m_7325_(), fluidState.m_76190_());
                            if (eAccess.getSource() != null) {
                                f2 = eAccess.getSource().m_7077_(e, (BlockGetter)eAccess.getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.getSource() == null || eAccess.getSource().m_7349_(e, (BlockGetter)eAccess.getLevel(), blockpos, state, f))) {
                            affectedBlockPositionsSet.add((Object)blockpos);
                        } else if (first) {
                            return;
                        }
                        first = false;
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneX(Explosion e, int x, int yStart, int yEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double xRel = (double)x / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneY(Explosion e, int y, int xStart, int xEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double yRel = (double)y / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int x = xStart; x <= xEnd; ++x) {
                    double xRel = (double)x / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneZ(Explosion e, int z, int xStart, int xEnd, int yStart, int yEnd) {
        if (!rayCalcDone) {
            double zRel = (double)z / 15.0 * 2.0 - 1.0;
            for (int x = xStart; x <= xEnd; ++x) {
                double xRel = (double)x / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static boolean checkAffectedPosition(Explosion e, double xRel, double yRel, double zRel) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double len = Math.sqrt(xRel * xRel + yRel * yRel + zRel * zRel);
        double xInc = xRel / len * 0.3;
        double yInc = yRel / len * 0.3;
        double zInc = zRel / len * 0.3;
        float rand = eAccess.getLevel().f_46441_.m_188501_();
        float sizeRand = CurtainRules.tntRandomRange >= 0.0 ? (float)CurtainRules.tntRandomRange : rand;
        double posX = eAccess.getX();
        double posY = eAccess.getY();
        double posZ = eAccess.getZ();
        float f1 = 0.3f;
        for (float size = eAccess.getRadius() * (0.7f + sizeRand * 0.6f); size > 0.0f; size -= 0.22500001f) {
            posMutable.m_122169_(posX, posY, posZ);
            BlockState state = (BlockState)stateCache.get((Object)posMutable);
            FluidState fluid = (FluidState)fluidCache.get((Object)posMutable);
            BlockPos posImmutable = null;
            if (state == null) {
                posImmutable = posMutable.m_7949_();
                state = eAccess.getLevel().m_8055_(posImmutable);
                stateCache.put((Object)posImmutable, (Object)state);
                fluid = eAccess.getLevel().m_6425_(posImmutable);
                fluidCache.put((Object)posImmutable, (Object)fluid);
            }
            if (state.m_60767_() != Material.f_76296_) {
                float resistance = Math.max(state.m_60734_().m_7325_(), fluid.m_76190_());
                if (eAccess.getSource() != null) {
                    resistance = eAccess.getSource().m_7077_(e, (BlockGetter)eAccess.getLevel(), (BlockPos)posMutable, state, fluid, resistance);
                }
                size -= (resistance + 0.3f) * 0.3f;
            }
            if (size > 0.0f) {
                if (eAccess.getSource() == null || eAccess.getSource().m_7349_(e, (BlockGetter)eAccess.getLevel(), (BlockPos)posMutable, state, size)) {
                    affectedBlockPositionsSet.add((Object)(posImmutable != null ? posImmutable : posMutable.m_7949_()));
                }
            } else if (firstRay) {
                rayCalcDone = true;
                return true;
            }
            firstRay = false;
            posX += xInc;
            posY += yInc;
            posZ += zInc;
        }
        return false;
    }

    public static void setBlastChanceLocation(BlockPos p) {
        blastChanceLocation = p;
    }

    private static void blastCalc(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        if (blastChanceLocation == null || blastChanceLocation.m_203202_(eAccess.getX(), eAccess.getY(), eAccess.getZ()) > 200.0) {
            return;
        }
        chances.clear();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = eAccess.getX();
                    double d6 = eAccess.getY();
                    double d8 = eAccess.getZ();
                    boolean found = false;
                    float f1 = 0.3f;
                    for (float f = eAccess.getRadius() * 1.3f; f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = OptimizedExplosion.containing(d4, d6, d8);
                        BlockState state = eAccess.getLevel().m_8055_(blockpos);
                        FluidState fluidState = eAccess.getLevel().m_6425_(blockpos);
                        if (state.m_60767_() != Material.f_76296_) {
                            float f2 = Math.max(state.m_60734_().m_7325_(), fluidState.m_76190_());
                            if (eAccess.getSource() != null) {
                                f2 = eAccess.getSource().m_7077_(e, (BlockGetter)eAccess.getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.getSource() == null || eAccess.getSource().m_7349_(e, (BlockGetter)eAccess.getLevel(), blockpos, state, f)) && !found && blockpos.equals((Object)blastChanceLocation)) {
                            chances.add(Float.valueOf(f));
                            found = true;
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void showTNTblastChance(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double randMax = 0.6f * eAccess.getRadius();
        double total = 0.0;
        boolean fullyBlownUp = false;
        boolean first = true;
        int rays = 0;
        for (float f3 : chances) {
            ++rays;
            double calc = (double)f3 - randMax;
            if (calc > 0.0) {
                fullyBlownUp = true;
            }
            double chancePerRay = Math.abs(calc) / randMax;
            if (fullyBlownUp) continue;
            if (first) {
                first = false;
                total = chancePerRay;
                continue;
            }
            total *= chancePerRay;
        }
        if (fullyBlownUp) {
            total = 0.0;
        }
        double chance = 1.0 - total;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMaximumFractionDigits(2);
        for (Player player : eAccess.getLevel().m_6907_()) {
            Messenger.m(player, "w Pop: ", "c " + nf.format(chance) + " ", "^w Chance for the block to be destroyed by the blast: " + chance, "?" + chance, "w Remain: ", String.format("c %.2f ", total), "^w Chance the block survives the blast: " + total, "?" + total, "w Rays: ", String.format("c %d ", rays), "^w TNT blast rays going through the block", "?" + rays, "w Size: ", String.format("c %.1f ", Float.valueOf(eAccess.getRadius())), "^w TNT blast size", "?" + eAccess.getRadius(), "w @: ", String.format("c [%.1f %.1f %.1f] ", eAccess.getX(), eAccess.getY(), eAccess.getZ()), "^w TNT blast location X:" + eAccess.getX() + " Y:" + eAccess.getY() + " Z:" + eAccess.getZ(), "?" + eAccess.getX() + " " + eAccess.getY() + " " + eAccess.getZ());
        }
    }

    public static BlockPos containing(double x, double y, double z) {
        return new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
    }

    static {
        explosionSound = 0;
        densityCache = new Object2DoubleOpenHashMap();
        pairMutable = new MutablePair();
        stateCache = new Object2ObjectOpenHashMap();
        fluidCache = new Object2ObjectOpenHashMap();
        posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        affectedBlockPositionsSet = new ObjectOpenHashSet();
        chances = new ArrayList();
    }
}

