/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins.rules.desert_shrubs;

import dev.dubhe.curtain.CurtainRules;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SaplingBlock.class})
public abstract class SaplingBlockMixin {
    @Inject(method={"advanceTree"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/level/block/grower/AbstractTreeGrower;growTree(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/util/RandomSource;)Z")}, cancellable=true)
    private void onGenerate(ServerLevel level, BlockPos pos, BlockState blockState, RandomSource random, CallbackInfo ci) {
        if (CurtainRules.desertShrubs && level.m_204166_(pos).m_203656_(BiomeTags.f_207614_) && !SaplingBlockMixin.nearWater((LevelAccessor)level, pos)) {
            level.m_7731_(pos, Blocks.f_50036_.m_49966_(), 3);
            ci.cancel();
        }
    }

    private static boolean nearWater(LevelAccessor level, @NotNull BlockPos pos) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, -4, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }
}

