/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins.rules.stackable_shulker_boxes;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.rules.fakes.ItemEntityInterface;
import dev.dubhe.curtain.utils.InventoryHelper;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements ItemEntityInterface {
    @Shadow
    private int f_31986_;
    @Shadow
    private int f_31985_;

    public ItemEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public int getPickupDelayCM() {
        return this.f_31986_;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void removeEmptyShulkerBoxTags(Level worldIn, double x, double y, double z, ItemStack stack, CallbackInfo ci) {
        BlockItem blockItem;
        Item item;
        if (CurtainRules.shulkerBoxStackSize > 1 && (item = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) {
            InventoryHelper.cleanUpShulkerBoxTag(stack);
        }
    }

    @Redirect(method={"isMergable()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I"))
    private int getItemStackMaxAmount(ItemStack stack) {
        BlockItem blockItem;
        Item item;
        if (CurtainRules.shulkerBoxStackSize > 1 && (item = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) {
            return CurtainRules.shulkerBoxStackSize;
        }
        return stack.m_41741_();
    }

    @Inject(method={"tryToMerge(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryStackShulkerBoxes(ItemEntity other, CallbackInfo ci) {
        BlockItem blockItem;
        Item item;
        ItemEntity self = (ItemEntity)this;
        ItemStack selfStack = self.m_32055_();
        if (CurtainRules.shulkerBoxStackSize == 1 || !((item = selfStack.m_41720_()) instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock)) {
            return;
        }
        ItemStack otherStack = other.m_32055_();
        if (selfStack.m_41720_() == otherStack.m_41720_() && !InventoryHelper.shulkerBoxHasItems(selfStack) && !InventoryHelper.shulkerBoxHasItems(otherStack) && Objects.equals(selfStack.m_41783_(), otherStack.m_41783_()) && selfStack.m_41613_() != CurtainRules.shulkerBoxStackSize) {
            int amount = Math.min(otherStack.m_41613_(), CurtainRules.shulkerBoxStackSize - selfStack.m_41613_());
            selfStack.m_41769_(amount);
            self.m_32045_(selfStack);
            this.f_31986_ = Math.max(((ItemEntityInterface)other).getPickupDelayCM(), this.f_31986_);
            this.f_31985_ = Math.min(other.m_32059_(), this.f_31985_);
            otherStack.m_41774_(amount);
            if (otherStack.m_41619_()) {
                other.m_146870_();
            } else {
                other.m_32045_(otherStack);
            }
            ci.cancel();
        }
    }
}

